/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.sql;

import at.grid.cms.storage.DataStorage;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.util.Util;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HistoryPanel
extends JPanel {
    DataStorage storage;
    ThemisApplication app = ThemisApplication.getInstance();
    private JTextField fldElementId;
    private JTextField fldSearch;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JList list;
    private JTextArea text;

    public HistoryPanel(DataStorage s) {
        this.initComponents();
        this.storage = s;
        this.loadContent();
    }

    private void loadContent() {
        try {
            String where;
            String id = this.fldElementId.getText().trim();
            long idelement = -1L;
            if (!"".equals(id)) {
                idelement = Long.parseLong(id);
            }
            String s = this.fldSearch.getText().trim();
            String string = where = idelement < 0L ? "" : " WHERE h.idelement=" + idelement + " ";
            if (!"".equals(s)) {
                where = where + ("".equals(where) ? " WHERE " : " AND ") + " lower(el.title) LIKE '%" + s.toLowerCase() + "%'";
            }
            ResultSet rs = this.storage.executeQueryForResultSet("select h.*,el.title from tdtaelementhistory AS h LEFT JOIN tdtaelementlng AS el ON (h.idelement=el.idelement) " + where + "order by idelement", true);
            DefaultListModel<Record> m = new DefaultListModel<Record>();
            while (rs.next()) {
                m.addElement(new Record(rs.getTimestamp("savedate"), rs.getLong("idelement"), rs.getString("title"), Util.inflate((byte[])rs.getBytes("data"))));
            }
            this.list.setModel(m);
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldSearch = new JTextField();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.fldElementId = new JTextField();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.text = new JTextArea();
        this.jSplitPane1.setMinimumSize(new Dimension(10, 3));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel.jLabel2.text"));
        this.fldSearch.setText(NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel.fldSearch.text"));
        this.fldSearch.setMinimumSize(new Dimension(5, 24));
        this.fldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.fldSearchActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel.jButton2.text"));
        this.jButton2.setMinimumSize(new Dimension(5, 32));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel.jLabel1.text"));
        this.fldElementId.setText(NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel.fldElementId.text"));
        this.fldElementId.setMinimumSize(new Dimension(5, 24));
        this.fldElementId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.fldElementIdActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel.jButton1.text"));
        this.jButton1.setMinimumSize(new Dimension(5, 32));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jScrollPane1.setMinimumSize(new Dimension(10, 20));
        this.list.setModel(new DefaultListModel());
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                HistoryPanel.this.listValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.fldElementId, -1, 140, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.fldSearch, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, -1, -2))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fldSearch, -2, -1, -2).addComponent(this.jButton2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fldElementId, -2, -1, -2).addComponent(this.jButton1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 286, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jScrollPane2.setMinimumSize(new Dimension(10, 20));
        this.text.setColumns(20);
        this.text.setRows(5);
        this.jScrollPane2.setViewportView(this.text);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 409, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 349, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void listValueChanged(ListSelectionEvent evt) {
        Record r = (Record)this.list.getSelectedValue();
        if (r != null) {
            final int scroll = this.jScrollPane2.getVerticalScrollBar().getValue();
            this.text.setText(r.getXml());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoryPanel.this.jScrollPane2.getVerticalScrollBar().setValue(scroll);
                }
            });
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.loadContent();
    }

    private void fldElementIdActionPerformed(ActionEvent evt) {
        this.loadContent();
    }

    private void fldSearchActionPerformed(ActionEvent evt) {
        this.loadContent();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.loadContent();
    }

    class Record {
        Date dt;
        long id;
        String title;
        String xml;

        public Record(Date dt, long id, String title, String xml) {
            this.dt = dt;
            this.id = id;
            this.title = title;
            this.xml = xml;
        }

        public String toString() {
            return Util.formatDate((Date)this.dt, (String)Util.DATETIME_ISO, (TimeZone)HistoryPanel.this.app.getTimeZone()) + " [" + this.id + "] " + (this.title == null ? "<NO_TITLE>" : this.title);
        }

        public String getXml() {
            return this.xml;
        }
    }
}

