/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.sql;

import at.grid.cms.storage.DataStorage;
import at.grid.cms.storage.SearchResult;
import at.grid.ontology.swing.search.SearchResultTableModel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SQLQueryPanel
extends JPanel {
    private String DIALOG_CODE = "sqlpanel";
    public static final int DIALOG_WIDTH = 1170;
    public static final int DIALOG_HEIGHT = 770;
    DataStorage storage;
    private JButton btnClose;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblPerformance;
    private JTextArea slqTextarea;
    private JTextField sqlField;
    private JTable table;

    public SQLQueryPanel(DataStorage s) {
        this.initComponents();
        this.storage = s;
    }

    public void displayQueryResults(final String q) {
        final long performanceMillis = new Date().getTime();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (q.toLowerCase().startsWith("select")) {
                        SearchResult r = SQLQueryPanel.this.storage.executeQuery(q, true);
                        SearchResultTableModel tm = new SearchResultTableModel(r);
                        SQLQueryPanel.this.table.setModel((TableModel)tm);
                        SQLQueryPanel.this.lblPerformance.setText(Long.toString(new Date().getTime() - performanceMillis));
                    } else {
                        int executeUpdate = SQLQueryPanel.this.storage.executeUpdate(q, true);
                        Dialogs.getInstance().showInfoDialog(executeUpdate + " Results for SQL:\n " + q);
                    }
                }
                catch (Exception ex) {
                    Dialogs.getInstance().showErrorDialog(ex.getLocalizedMessage(), ex);
                }
            }
        });
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.sqlField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.slqTextarea = new JTextArea();
        this.jButton2 = new JButton();
        this.jLabel2 = new JLabel();
        this.lblPerformance = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.btnClose = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(SQLQueryPanel.class, (String)"SQLQueryPanel.jButton1.text"));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SQLQueryPanel.class, (String)"SQLQueryPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.sqlField.setText(NbBundle.getMessage(SQLQueryPanel.class, (String)"SQLQueryPanel.sqlField.text"));
        this.sqlField.setMinimumSize(new Dimension(5, 24));
        this.sqlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLQueryPanel.this.sqlFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.sqlField, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(200, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 100));
        this.slqTextarea.setColumns(20);
        this.slqTextarea.setRows(3);
        this.slqTextarea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SQLQueryPanel.this.slqTextareaKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.slqTextarea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(SQLQueryPanel.class, (String)"SQLQueryPanel.jButton2.text"));
        this.jButton2.setMinimumSize(new Dimension(50, 30));
        this.jButton2.setPreferredSize(new Dimension(50, 30));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLQueryPanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jButton2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SQLQueryPanel.class, (String)"SQLQueryPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblPerformance, (String)NbBundle.getMessage(SQLQueryPanel.class, (String)"SQLQueryPanel.lblPerformance.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.lblPerformance, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(10, 20));
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setMinimumSize(new Dimension(5, 64));
        this.jScrollPane2.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(SQLQueryPanel.class, (String)"SQLQueryPanel.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLQueryPanel.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnClose, gridBagConstraints);
    }

    private void slqTextareaKeyPressed(KeyEvent evt) {
        if (evt.isControlDown() && 13 == evt.getKeyCode()) {
            this.displayQueryResults(this.slqTextarea.getText());
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.displayQueryResults(this.slqTextarea.getText());
    }

    private void sqlFieldActionPerformed(ActionEvent evt) {
        this.displayQueryResults(this.sqlField.getText());
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    public void showDialog() {
        JFrame dlg = new JFrame(ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.DIALOG_CODE + ".title"));
        dlg.setLayout(new BorderLayout());
        dlg.add((Component)this, "Center");
        THEMIS.applyWindowSizeAndLocation((String)this.DIALOG_CODE, (Window)dlg, (int)1170, (int)770);
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JFrame parent = (JFrame)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation((String)this.DIALOG_CODE, (Window)parent);
        parent.dispose();
    }
}

