/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.terra;

import at.grid.cms.content.UploadItem;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import at.grid.themis.ontology.javafx.io.ExportCsvFxPanel;
import at.grid.themis.special.terra.TerraReportGeneratorV3;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TerraPanel
extends JPanel {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private JButton btnDeleteImages;
    private JButton btnExportCSV;
    private JButton btnExportThemis;
    private JButton btnExportV3;
    private JButton btnSelectFolder;
    private JButton btnSelectTemplate;
    private JCheckBox chkCreateFolder;
    private JTextField fldFilename;
    private JTextField fldFolder;
    private JTextField fldTemplate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;

    public TerraPanel() {
        this.initComponents();
        this.fldTemplate.setText(this.project.getProjectProperty("cutom.terra.template", ""));
        this.fldFolder.setText(this.project.getProjectProperty("cutom.terra.folder", ""));
        this.fldFilename.setText(this.project.getProjectProperty("cutom.terra.file", ""));
        new DropTarget(this.fldTemplate, (DropTargetListener)new ThemisDropTargetListener(false, false, new String[]{"docx"}){

            public void dropFileAction(File f, DropTargetDropEvent event) {
                TerraPanel.this.fldTemplate.setText(f.getAbsolutePath());
                TerraPanel.this.project.setProjectProperty("cutom.terra.template", f.getAbsolutePath());
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.fldTemplate = new JTextField();
        this.btnSelectTemplate = new JButton();
        this.jLabel2 = new JLabel();
        this.fldFolder = new JTextField();
        this.btnSelectFolder = new JButton();
        this.jLabel3 = new JLabel();
        this.fldFilename = new JTextField();
        this.btnExportV3 = new JButton();
        this.chkCreateFolder = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.btnDeleteImages = new JButton();
        this.jLabel5 = new JLabel();
        this.btnExportThemis = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.btnExportCSV = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel7.text"));
        this.jLabel7.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.fldTemplate.setEditable(false);
        this.fldTemplate.setFont(THEMIS.fontTextfield);
        this.fldTemplate.setText(NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.fldTemplate.text"));
        this.fldTemplate.setMinimumSize(new Dimension(100, 30));
        this.fldTemplate.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldTemplate, gridBagConstraints);
        this.btnSelectTemplate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectTemplate, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.btnSelectTemplate.text"));
        this.btnSelectTemplate.setBorder(new SoftBevelBorder(0));
        this.btnSelectTemplate.setMinimumSize(new Dimension(60, 30));
        this.btnSelectTemplate.setPreferredSize(new Dimension(60, 30));
        this.btnSelectTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerraPanel.this.btnSelectTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectTemplate, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel2.text"));
        this.jLabel2.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.fldFolder.setEditable(false);
        this.fldFolder.setFont(THEMIS.fontTextfield);
        this.fldFolder.setText(NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.fldFolder.text"));
        this.fldFolder.setMinimumSize(new Dimension(100, 30));
        this.fldFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFolder, gridBagConstraints);
        this.btnSelectFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFolder, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.btnSelectFolder.text"));
        this.btnSelectFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectFolder.setMinimumSize(new Dimension(60, 30));
        this.btnSelectFolder.setPreferredSize(new Dimension(60, 30));
        this.btnSelectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerraPanel.this.btnSelectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectFolder, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel3.text"));
        this.jLabel3.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setText(NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.fldFilename.text"));
        this.fldFilename.setMinimumSize(new Dimension(100, 30));
        this.fldFilename.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFilename, gridBagConstraints);
        this.btnExportV3.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportV3, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.btnExportV3.text"));
        this.btnExportV3.setBorder(new SoftBevelBorder(0));
        this.btnExportV3.setMinimumSize(new Dimension(60, 30));
        this.btnExportV3.setPreferredSize(new Dimension(60, 30));
        this.btnExportV3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerraPanel.this.btnExportV3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnExportV3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkCreateFolder, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.chkCreateFolder.text"));
        this.chkCreateFolder.setMinimumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.chkCreateFolder, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.btnDeleteImages.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteImages, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.btnDeleteImages.text"));
        this.btnDeleteImages.setBorder(new SoftBevelBorder(0));
        this.btnDeleteImages.setMinimumSize(new Dimension(60, 30));
        this.btnDeleteImages.setPreferredSize(new Dimension(60, 30));
        this.btnDeleteImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerraPanel.this.btnDeleteImagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnDeleteImages, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.btnExportThemis.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportThemis, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.btnExportThemis.text"));
        this.btnExportThemis.setBorder(new SoftBevelBorder(0));
        this.btnExportThemis.setMinimumSize(new Dimension(60, 30));
        this.btnExportThemis.setPreferredSize(new Dimension(60, 30));
        this.btnExportThemis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerraPanel.this.btnExportThemisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnExportThemis, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.btnExportCSV.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportCSV, (String)NbBundle.getMessage(TerraPanel.class, (String)"TerraPanel.btnExportCSV.text"));
        this.btnExportCSV.setBorder(new SoftBevelBorder(0));
        this.btnExportCSV.setMinimumSize(new Dimension(60, 30));
        this.btnExportCSV.setPreferredSize(new Dimension(60, 30));
        this.btnExportCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TerraPanel.this.btnExportCSVActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnExportCSV, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnSelectFolderActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Ordner f\u00fcr Export ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, this.app.getPathExportFolder(), null, null, null, false).getSelectedFile();
        if (f != null) {
            this.fldFolder.setText(f.getAbsolutePath());
            this.project.setProjectProperty("cutom.terra.folder", f.getAbsolutePath());
            this.app.setPathExportFolder(f);
        }
    }

    private void btnDeleteImagesActionPerformed(ActionEvent evt) {
        CmsEvent ev = this.project.getSelectionManager().getCurrentEvent();
        if (ev == null) {
            Dialogs.getInstance().showInfoDialog("Kein Ereignis ausgew\u00e4hlt");
            return;
        }
        List historyIds = ev.getRelationAttribute("histories").getElementIds();
        Iterator iterator = historyIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsHistory hist = (CmsHistory)this.project.loadElement(id, this.project.getUser());
            ArrayList items = hist.getImageUploadItems();
            for (UploadItem item : items) {
                hist.getUploadAttribute("files").deleteUpload(item);
                item.getFile().delete();
            }
            hist.getUploadAttribute("files").removeDeletedItems();
        }
    }

    private void btnSelectTemplateActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Vorlage ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getSettings().getFolderReportTemplate().getValue(true), null, (FileFilter)new FileNameExtensionFilter(this.project.getResourceText("dialog.load.protocol-template.word"), "docx"), null, false).getSelectedFile();
        if (f == null) {
            this.fldTemplate.setText("");
            return;
        }
        if (!f.isFile() || f.isDirectory()) {
            this.app.getDialog().showWarningDialog("Keine Datei ausgew\u00e4hlt");
            return;
        }
        this.fldTemplate.setText(f.getAbsolutePath());
        this.project.setProjectProperty("cutom.terra.template", f.getAbsolutePath());
    }

    private void btnExportV3ActionPerformed(ActionEvent evt) {
        File f;
        if (this.project.getSelectionManager().getCurrentEvent() == null) {
            this.app.getDialog().showWarningDialog("app.core.text.noevent");
            return;
        }
        String templateName = this.fldTemplate.getText();
        if ("".equals(templateName)) {
            this.app.getDialog().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.template-required"));
            return;
        }
        String folderName = this.fldFolder.getText();
        if ("".equals(folderName)) {
            this.app.getDialog().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.folder-required"));
            return;
        }
        String fname = this.fldFilename.getText() + (this.fldFilename.getText().toLowerCase().endsWith(".docx") ? "" : ".docx");
        if ("".equals(fname.trim())) {
            this.app.getDialog().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.filename-required"));
            return;
        }
        String fnameBase = Util.getFileNameWithoutExtension((File)new File(fname));
        File folder = new File(folderName);
        File file = f = this.chkCreateFolder.isSelected() ? new File(new File(folder, fnameBase), fname) : new File(folder, fname);
        if (f.exists()) {
            this.app.getDialog().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.file-exists"));
            return;
        }
        File templatefile = new File(this.fldTemplate.getText());
        Runnable runner = () -> {
            f.getParentFile().mkdirs();
            try {
                CmsReport rep = new CmsReport();
                rep.setTemplateFile(templatefile);
                TerraReportGeneratorV3 r = new TerraReportGeneratorV3(rep);
                r.createReport(f, null, 0, 100);
                int option = this.app.getDialog().showInfoOptionDialog("Bericht erfolgreich erstellt", "Sonderbericht", (Object[])new String[]{"Datei \u00f6ffnen", "Ordner zeigen", "Schlie\u00dfen"});
                try {
                    if (option == 0) {
                        Desktop.getDesktop().open(f);
                    } else if (option == 1) {
                        Desktop.getDesktop().open(f.getParentFile());
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException ex) {
                this.app.getDialog().showErrorDialog(ex.getMessage(), (Exception)ex);
            }
        };
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runner, (String)"Das Protokoll wird erzeugt ...");
    }

    private void btnExportThemisActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Exportdatei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.SAVE, null, null, THEMIS.getThemisFileFilter(), null, false).getSelectedFile();
        if (f == null) {
            return;
        }
        f.delete();
        CmsEvent event = this.project.getSelectionManager().getCurrentEvent();
        if (event == null) {
            this.app.getDialog().showWarningDialog("Kein aktuelles Ereignis ausgew\u00e4hlt");
            return;
        }
        ThemisTaskWithDialog.createTaskWithCounter((String)"Die Datei wird erstellt ...", ph -> {
            ThemisFile tf = new ThemisFile();
            tf.setWithPlans();
            tf.setWithTemplates();
            tf.addContent(this.app.getFilter().getFilteredLocationIds());
            tf.addContent(this.app.getFilter().getFilteredObservationIds());
            try {
                tf.saveToFile(f, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.app.getDialog().showErrorDialog("Datei kann nicht erstellt werden");
            }
        });
        if (f.isFile()) {
            THEMIS.showFileResultDialog((File)f, (boolean)false);
        }
    }

    private void btnExportCSVActionPerformed(ActionEvent evt) {
        if (!ThemisApplication.getInstance().getProject().isOpen()) {
            this.app.getDialog().showWarningDialog("Es ist kein Projekt ge\u00f6ffnet.");
            return;
        }
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("csv-export", 850, 900);
        ExportCsvFxPanel panel = new ExportCsvFxPanel().populate();
        JavaFxDialog fx = new JavaFxDialog((Node)panel);
        fx.addSaveButton("Exportieren").setOnAction(ev -> ThemisTaskWithFxDialog.createTask((String)"csv-export.exporting", ph -> {
            panel.apply(ph);
            try {
                File file = panel.export(ph);
                if (file != null && file.exists()) {
                    SwingUtilities.invokeLater(() -> THEMIS.showFileResultDialog((File)file));
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
                this.app.getDialog().showErrorDialog("Export fehlgeschlagen!", e);
            }
        }));
        fx.addCancelButton("Abbrechen");
        dlg.setContent((Node)fx);
        dlg.show();
    }
}

