/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.terra;

import at.grid.cms.content.UploadItem;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.report.doc.WordReportGenerator;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class TerraReportGeneratorV3
extends WordReportGenerator {
    public TerraReportGeneratorV3(CmsReport rep) throws FileNotFoundException, IOException {
        super(rep);
    }

    public void addSpecificContent(File destinationFile, ThemisFilter filter, String sort) {
        ArrayList<String> fotos = new ArrayList<String>();
        int fotonummer = 1;
        File folder = destinationFile.getParentFile();
        File imagefolder = new File(folder, "fotos");
        imagefolder.mkdirs();
        File imagefolderOrig = new File(folder, "fotos_orig");
        imagefolderOrig.mkdirs();
        if (sort == null) {
            sort = "plan.sort,ele.number,observation.number,observation.idelement";
        }
        List recs = filter.getFilteredLocations(sort, null, true);
        String lastSubheading = null;
        String lastPlan = null;
        boolean newInnenAussen = false;
        int observationCounter = 1;
        for (DataRecord rec : recs) {
            XWPFParagraph p;
            CmsLocation loc = (CmsLocation)this.project.loadElement(rec.getLong("meta_id").longValue(), this.project.getUser());
            if (loc.isBuilding()) continue;
            newInnenAussen = false;
            String innenAussen = loc.getAttributeValue("list1");
            String plan = rec.getString("plantitle");
            if ("".equals(innenAussen)) {
                innenAussen = "Innen/Aussen nicht definiert";
            }
            if (lastSubheading == null || !lastSubheading.equals(innenAussen)) {
                lastSubheading = loc.getAttributeValue("list1");
                if ("".equals(lastSubheading)) {
                    lastSubheading = "Innen/Aussen nicht definiert";
                }
                p = this.addParagraph(lastSubheading, this.FORMAT_HEADING);
                p.setPageBreak(true);
                newInnenAussen = true;
                lastPlan = null;
            }
            if (lastPlan == null || !lastPlan.equals(plan)) {
                lastPlan = plan;
                if ("".equals(lastPlan)) {
                    lastPlan = "keine Angabe";
                }
                p = this.addParagraph(lastPlan, this.FORMAT_HEADING2);
                if (!newInnenAussen) {
                    p.setPageBreak(true);
                }
            }
            String title = "";
            title = innenAussen.toLowerCase().startsWith("aussen") ? loc.getAttributeValue("title") : (innenAussen.toLowerCase().startsWith("innen") ? "Geschoss:" + rec.getString("plantitle") + "\nRaum:" + loc.getAttributeValue("title") : loc.getAttributeValue("title"));
            this.createTable(new float[]{1.0f}, 0);
            XWPFTableRow row = this.addTableRow(this.table, 1, -1);
            p = this.setTableCellContent(row, 0, title.replaceAll(": ", ":").replaceAll(":", ":\t"), this.FORMAT_BOLD);
            this.setTab(p, TerraReportGeneratorV3.cmToUnits((double)3.0));
            p = this.addTableCellContent(row, 0, loc.getAttributeValue("description").replaceAll(": ", ":").replaceAll(":", ":\t"), this.FORMAT_TEXT);
            this.setTab(p, TerraReportGeneratorV3.cmToUnits((double)3.0));
            this.addParagraph();
            if (innenAussen.toLowerCase().startsWith("aussen")) {
                this.createTable(new float[]{1.0f}, 0);
                row = this.addTableRow(this.table, 1, -1);
                p = this.setTableCellContent(row, 0, "", this.FORMAT_TEXT);
                this.addParagraph();
            }
            ArrayList obsIds = loc.getFilteredObservationIds();
            float[] tblWidthObs = new float[]{7.0f, 10.0f, 10.0f, 60.0f, 13.0f};
            this.createTable(tblWidthObs, 1);
            row = this.addTableRow(this.table, tblWidthObs, -1);
            this.setTableRowContent(row, new String[]{"Nr.", "L\u00e4nge\n[cm]", "Breite\n[mm]", "Beschreibung, Lage, Form", "Foto-Nr."}, this.FORMAT_BOLD);
            Iterator iterator = obsIds.iterator();
            while (iterator.hasNext()) {
                long obsId = (Long)iterator.next();
                CmsObservation obs = (CmsObservation)this.project.loadElement(obsId, this.project.getUser());
                ArrayList images = obs.getUploads(true);
                fotos.clear();
                for (UploadItem image : images) {
                    try {
                        Util.copy((File)image.getFile(), (File)new File(imagefolder, fotonummer + ".jpg"));
                        Util.copy((File)new File(this.project.getImagefileLocation(), image.getFilename()), (File)new File(imagefolderOrig, fotonummer + ".jpg"));
                        fotos.add(Integer.toString(fotonummer));
                        ++fotonummer;
                    }
                    catch (IOException ex) {
                        this.project.getLogger().severe("Error while copying files: " + ex.getMessage());
                    }
                }
                row = this.addTableRow(this.table, tblWidthObs, -1);
                StringBuilder description = new StringBuilder();
                description.append(obs.getAttributeValue("description").trim());
                description.append(obs.hasAttributeValue("observationtype") && description.length() > 0 ? ", " : "");
                description.append(obs.getAttributeValue("observationtype").trim());
                description.append(obs.hasAttributeValue("topic") && description.length() > 0 ? ", " : "");
                description.append(obs.getAttributeValue("topic").trim());
                description.append(obs.hasAttributeValue("priority") && description.length() > 0 ? ", " : "");
                description.append(obs.getAttributeValue("priority").trim());
                description.append(obs.hasAttributeValue("freetext3") && description.length() > 0 ? ", " : "");
                description.append(obs.getAttributeValue("freetext3").trim());
                this.setTableRowContent(row, new String[]{Integer.toString(observationCounter), obs.getAttributeValue("freetext1"), obs.getAttributeValue("freetext2"), description.toString(), String.join((CharSequence)", ", fotos)}, this.FORMAT_TEXT);
                ++observationCounter;
            }
            if (obsIds.isEmpty()) {
                row = this.addTableRow(this.table, tblWidthObs, -1);
                this.setTableRowContent(row, new String[]{"", "", "", "", ""}, this.FORMAT_TEXT);
            }
            this.addParagraph();
            this.addParagraph();
        }
    }
}

