/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.ExportUtil;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.PlanSnippetGenerator;
import at.grid.themis.ontology.report.ReportPageSetup;
import at.grid.themis.ontology.report.pdf.PdfExportBase;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfPCell;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;

public class PdfObservationExporter
extends PdfExportBase {
    protected ArrayList<Long> observationIds = new ArrayList();
    boolean isEventFilter = false;
    boolean withTitlePage;
    public boolean noPlans;
    Date fromDate;
    Date untilDate;
    boolean includeOpenTasks = true;

    public boolean doIncludeOpenTasks() {
        return this.includeOpenTasks;
    }

    public void setIncludeOpenTasks(boolean includeOpenTasks) {
        this.includeOpenTasks = includeOpenTasks;
    }

    public PdfObservationExporter(CmsReport rep) {
        this(rep, true);
    }

    public PdfObservationExporter(CmsReport rep, boolean withTitlePage) {
        super(rep);
        this.withTitlePage = withTitlePage;
        this.noPlans = ThemisApplication.getInstance().getProject().getPlans().size() == 0;
        this.rep.pageFormat = new ReportPageSetup();
        try {
            Image img;
            File logofile = this.project.getProjectElement().getUploadAttribute("projectlogo").getFirstUploadItemFile();
            if (logofile != null && (img = Image.getInstance((byte[])Files.readAllBytes(logofile.toPath()))) != null) {
                float height = img.getHeight();
                float heightCm = 2.54f * height / 72.0f;
                float scale = 1.5f / heightCm;
                this.rep.pageFormat.logoWidth = 2.54f * (img.getWidth() * scale) / 72.0f;
                this.getPageEvent().initialise(rep);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPeriod(Date from, Date until) {
        this.fromDate = from;
        this.untilDate = until;
        ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance());
        filter.setTriggerEnabled(false);
        filter.setEventRange(this.fromDate, this.untilDate, (Object)this);
        List recs = filter.getFilteredObservations(this.rep.getSortSql(), null);
        this.elementIds.clear();
        for (DataRecord rec : recs) {
            long id = rec.getLong("observationid");
            long idloc = rec.getLong("meta_id");
            if (id > 0L && !this.elementIds.contains(id)) {
                this.elementIds.add(id);
            } else {
                this.elementIds.add(idloc);
            }
            if (this.locationIds.contains(idloc)) continue;
            this.locationIds.add(idloc);
        }
    }

    public ArrayList<Long> getObservationList() {
        return this.observationIds;
    }

    public ArrayList<Long> getElementList() {
        return this.elementIds;
    }

    public void createContent(CmsUser user) throws DocumentException {
        try {
            ArrayList openObservationIds = new ArrayList();
            if (this.rep.event != null && this.doIncludeOpenTasks()) {
                openObservationIds = this.getOpenTasks(this.observationIds);
            }
            ArrayList eventIds = new ArrayList();
            if (this.rep.contentType == CmsReport.Content.PERIOD) {
                eventIds = this.project.getEventSearchResult(this.fromDate, this.untilDate).getResultIds();
            }
            int countTotal = this.elementIds.size() + openObservationIds.size() + eventIds.size();
            this.progressStep = (this.progressTo - this.progressFrom) / (double)countTotal;
            this.progressCurrent = this.progressFrom;
            if (this.withTitlePage) {
                this.createTitlePage();
            } else {
                this.createTitle();
            }
            this.createObservationTable(this.project, user, this.elementIds, this.rep.event);
            if (!openObservationIds.isEmpty()) {
                this.document.newPage();
                this.document.add((Element)this.createParagraph("Aktuell offene Punkte", this.formatHeading1));
                this.createObservationTable(this.project, user, openObservationIds, null);
            }
            if (this.rep.hasSignature()) {
                this.document.newPage();
                this.document.add((Element)this.createParagraph("Unterschriften", this.formatHeading1));
                this.document.add((Element)this.createParagraph("Dieser Bericht wurde in bestem Wissen und Gewissen angefertigt und wird als vollst\u00e4ndig best\u00e4tigt.", this.formatText));
                this.document.add((Element)this.createParagraph(" ", this.formatText));
                this.createSignature();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
            ex.printStackTrace();
        }
    }

    protected String getPeriodAsString() {
        return Util.formatDate((Date)this.fromDate, (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone()) + " - " + Util.formatDate((Date)this.untilDate, (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
    }

    public void createEventListTable(ArrayList<Long> eventIds) throws DocumentException {
        int[] widths = new int[]{4, 8, 12, 5, 5};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Datum/Uhrzeit", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Ereignis", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Information", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Erfassung", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        for (long id : eventIds) {
            this.progressCurrent += this.progressStep;
            if (this.progress != null) {
                this.progress.progress((int)this.progressCurrent);
            }
            CmsEvent event = (CmsEvent)this.project.loadElement(id, this.project.getUser());
            this.table.addCell(this.createPdfCell(Util.formatDate((Date)event.getDateAttribute("date").getDate(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone()) + (event.hasAttributeValue("time") ? " " + event.getAttributeValue("time") : ""), true, this.formatTable, 0, 2));
            this.table.addCell(this.createPdfCell(event.getEventTitle(), true, this.formatTable, 0, 2));
            StringBuilder infoText = new StringBuilder();
            if (event.hasAttributeValue("comment")) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append(infoText.length() > 0 ? "\n" : "").append(event.getAttributeValue("comment"));
            }
            if (event.hasAttributeValue("participants")) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append("Teilnehmer:\n  ").append(event.getAttributeValue("participants").replaceAll("\\n", "\\n  "));
            }
            if (event.hasAttributeValue("place")) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append("Ort:\n  ").append(event.getAttributeValue("place"));
            }
            if (event.isSigned()) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append("Das Ereignis ist versiegelt!");
            }
            this.table.addCell(this.createPdfCell(infoText.toString(), true, this.formatTable, 0, 2));
            infoText = new StringBuilder();
            Properties props = event.getEventStatistics();
            if (Util.parseInt((String)props.getProperty("obs.type1", "0"), (int)0) > 0) {
                infoText.append(this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel)).append(": ").append(props.getProperty("obs.type1", "0"));
            }
            if (Util.parseInt((String)props.getProperty("obs.type2", "0"), (int)0) > 0) {
                infoText.append("\n").append(this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle)).append(": ").append(props.getProperty("obs.type2", "-"));
            }
            if (Util.parseInt((String)props.getProperty("obs.type3", "0"), (int)0) > 0) {
                infoText.append("\n").append(this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation)).append(": ").append(props.getProperty("obs.type3", "-"));
            }
            if (Util.parseInt((String)props.getProperty("obs.type4", "0"), (int)0) > 0) {
                infoText.append("\n").append(this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe)).append(": ").append(props.getProperty("obs.type4", "-"));
            }
            this.table.addCell(this.createPdfCell(infoText.toString(), true, this.formatTable, 0, 2));
            this.table.completeRow();
        }
        this.document.add((Element)this.table);
    }

    public void createObservationTable(ThemisProject project, CmsUser user, ArrayList<Long> ids, CmsEvent event) throws DocumentException, IOException {
        int[] widths = this.noPlans ? new int[]{8, 70, 37, 15} : new int[]{8, 55, 29, 25, 15};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        HashMap<Long, CmsEvent> events = new HashMap<Long, CmsEvent>();
        boolean useMeasure = this.app.getSettings().getObservationAttribute("measure").isUsed();
        boolean useStatus = this.app.getSettings().getObservationAttribute("done").isUsed();
        ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("donedate"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("type"));
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Pos", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Gegenstand/Plan, Beobachtung" + (useMeasure ? ", Ma\u00dfnahme" : ""), this.formatTableHeader, 1.0f, 0, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Datum", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        if (!this.noPlans) {
            headerCells.add(this.createPdfCell("Plan", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        }
        headerCells.add(this.createPdfCell("Status", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        Object colPixelsLoc = null;
        long lastLoc = -1L;
        File planSnippetfile = null;
        ArrayList<CmsHistory> histories = new ArrayList<CmsHistory>();
        int counter = 1;
        String statusText = "";
        Placeholder ph = new Placeholder(this.rep);
        ph.setEvent(event);
        if (this.progress != null) {
            this.progress.progress("Planausschnitte werden erzeugt");
        }
        PlanSnippetGenerator.generate((CmsReport)this.rep, (List)this.locationIds, (ProgressHandler)this.progress);
        if (this.progress != null) {
            this.progress.progress("Beobachtungen werden geladen, PDF wird erstellt");
        }
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        for (long id : ids) {
            long docId;
            CmsLocation loc;
            CmsObservation obs;
            this.progressCurrent += this.progressStep;
            if (this.progress != null) {
                this.progress.progress((int)this.progressCurrent);
            }
            CmsPlan plan = null;
            boolean planHasBuilding = false;
            CmsElement ele = project.loadElement(id, user);
            if ("observation".equals(ele.getElementcode())) {
                obs = (CmsObservation)ele;
                loc = null;
            } else {
                obs = (CmsObservation)project.getDefaultElement("observation");
                loc = (CmsLocation)ele;
                if (!this.rep.exportLocationsWithoutObservations) continue;
            }
            if (obs != null) {
                Iterator iterator = obs.getRelationAttribute("infos").getElementIds(false).iterator();
                while (iterator.hasNext()) {
                    docId = (Long)iterator.next();
                    if (this.documentIds.contains(docId)) continue;
                    this.documentIds.add(docId);
                }
                if (loc == null) {
                    long locid = obs.getRelationAttribute("location").getFirstElementId();
                    if (locid >= 0L) {
                        loc = (CmsLocation)project.loadElement(locid, user);
                    }
                } else {
                    long locid = loc.getId();
                }
            }
            if (loc != null) {
                if (!loc.getRelationAttribute("plan").isEmpty()) {
                    plan = (CmsPlan)loc.getRelationAttribute("plan").getFirstElement().getElement();
                    planHasBuilding = plan.hasAttributeValue("building");
                }
                Iterator locid = loc.getRelationAttribute("infos").getElementIds(false).iterator();
                while (locid.hasNext()) {
                    docId = (Long)locid.next();
                    if (this.documentIds.contains(docId)) continue;
                    this.documentIds.add(docId);
                }
                planSnippetfile = new File(ThemisApplication.getInstance().getProject().getPlansnippetLocation(), loc.getId() + "_" + this.rep.getPlanSnippetSize() + ".jpg");
            }
            histories.clear();
            if (this.rep.exportWithHistories) {
                if (obs.getHistories() != null) {
                    for (CmsElement h : obs.getHistories()) {
                        if (h == null) continue;
                        histories.add((CmsHistory)h);
                    }
                }
            } else {
                CmsHistory h;
                CmsHistory cmsHistory = h = event == null ? obs.getLatestHistory() : obs.getHistory(event);
                if (h != null) {
                    histories.add(h);
                }
            }
            if (histories.isEmpty()) {
                histories.add((CmsHistory)project.getDefaultElement("history"));
            }
            for (CmsHistory hist : histories) {
                obs.applyHistory(hist);
                this.table.addCell(this.createPdfCell(loc == null ? "" : loc.getFullNumber() + (obs.getId() >= 0L ? "." + obs.getAttributeValue("number") : ""), true, this.formatTable, 1, 2));
                StringBuilder infoText = new StringBuilder();
                if (this.rep.exportWithHistories) {
                    long idEvent = hist.getEventId();
                    CmsEvent ev = null;
                    if (events.containsKey(idEvent)) {
                        ev = (CmsEvent)events.get(idEvent);
                    } else {
                        ev = hist.getEvent();
                        if (ev != null) {
                            events.put(ev.getId(), ev);
                        }
                    }
                    if (ev != null) {
                        infoText.append("Ereignis: ").append(ev.getTitle()).append("\n");
                    }
                }
                if (loc != null) {
                    infoText.append(loc.getAttributeValue("title") + (loc.getRelationAttribute("plan").isEmpty() ? "" : " / " + (planHasBuilding ? "[" + plan.getRelationAttribute("building").getFirstElementTitle() + "] " : "") + loc.getRelationAttribute("plan").getFirstElementTitle()));
                    infoText.append("\n");
                }
                infoText.append(obs.toStringWithIgnore("", "\n", false, ignoreAtts));
                this.table.addCell(this.createPdfCell(infoText.toString(), true, this.formatTable, 0, 2));
                if (obs.getId() >= 0L) {
                    String dateText = "Erstellt: " + obs.getAttributeValue("creationdate") + "\nKontrolliert: " + hist.getAttributeValue("eventdate");
                    if (hist.hasAttributeValue("duedate")) {
                        dateText = dateText + "\n" + (obs.isOfType(2) ? "Termin: " : "F\u00e4llig: ") + hist.getAttributeValue("duedate");
                    }
                    if (useStatus && obs.getBooleanAttribute("done").isSet() && (obs.isOfType(1) || obs.isOfType(4))) {
                        dateText = dateText + "\nErledigt: " + obs.getAttributeValue("donedate");
                    }
                    this.table.addCell(this.createPdfCell(dateText, true, this.formatTable, 2, 2));
                } else {
                    this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                }
                if (!this.noPlans) {
                    if (planSnippetfile != null && planSnippetfile.isFile()) {
                        this.createImageCell(null, null, planSnippetfile, colWidthCm[3] - 2.0f * this.imagePadding, null);
                        this.table.addCell(this.tableCell);
                    } else {
                        this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                    }
                }
                if (obs.getId() >= 0L) {
                    String obstype = "";
                    switch ((int)obs.getKeyAttribute("type").getId()) {
                        case 2: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle);
                            break;
                        }
                        case 1: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel);
                            break;
                        }
                        case 3: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation);
                            break;
                        }
                        case 4: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe);
                        }
                    }
                    Color bgColor = null;
                    if (useStatus && obs.isOfType(1) || obs.isOfType(4)) {
                        statusText = obstype + ("".equals(obstype) ? "" : "\n") + (obs.getBooleanAttribute("done").isSet() ? this.rep.textStatusDone : this.rep.textStatusOpen);
                        bgColor = obs.getBooleanAttribute("done").isSet() ? ThemisColors.lightgreen : ThemisColors.COLOR_DEFECT;
                    } else {
                        statusText = obstype;
                    }
                    this.table.addCell(this.createPdfCell(statusText, this.formatTable, 1.0f, 1, 2, bgColor, 5.0f));
                } else {
                    this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                }
                this.table.completeRow();
                ArrayList imageUploadItems = ExportUtil.getImages((CmsReport)this.rep, (CmsLocation)loc, (CmsObservation)obs, (CmsHistory)hist);
                this.addImageRow(imageUploadItems, this.table);
                ++counter;
            }
        }
        this.document.add((Element)this.table);
    }
}

