/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw;

import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.special.wrw.WienerWohnenSoapClient;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.openide.util.Exceptions;

public class WienerWohnenConfigurationPanelFx
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private TextField endpointUrlField;
    private TextField keystoreFileField;
    private PasswordField passwordField;
    private ComboBox<String> keystoreTypeCombo;
    private TextField otfUserField;
    private TextField partnerIdField;
    private TextField objecttypeField;
    private String endpointUrl;
    private String keystoreFile;
    private String keystoreType;
    private String keystorePassword;
    private String otfUser;
    private String partnerId;
    private String objecttype;
    private final Properties sapConfig = new Properties();
    File propertiesFile = null;

    public WienerWohnenConfigurationPanelFx() {
        this.initialize();
    }

    private void initialize() {
        this.setMaxWidth(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPadding(new Insets(10.0));
        this.setSpacing(10.0);
        GridPane settingsGrid = this.createSettingsGrid();
        this.getChildren().add((Object)settingsGrid);
    }

    public void populate() {
        try {
            this.propertiesFile = new File(this.app.getApplicationDataConfigFolder(), "hab.properties");
            if (this.propertiesFile.isFile()) {
                this.sapConfig.load(new FileReader(this.propertiesFile));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.endpointUrl = this.sapConfig.getProperty("custom.wrw.soap.endpoint", "");
        this.endpointUrlField.setText(this.endpointUrl);
        this.keystoreFile = this.sapConfig.getProperty("cert.keystore", "");
        this.keystoreFileField.setText(this.keystoreFile);
        this.keystoreTypeCombo.getItems().add((Object)WienerWohnenSoapClient.KEYSTORE_TYPE_PKCS12);
        this.keystoreType = this.sapConfig.getProperty("cert.keystore.type", "");
        this.keystoreTypeCombo.getSelectionModel().select((Object)this.keystoreType);
        this.keystorePassword = this.sapConfig.getProperty("cert.keystore.password", "");
        this.passwordField.setText(this.keystorePassword);
        this.otfUser = this.sapConfig.getProperty("custom.wrw.soap.otfuser", "");
        this.otfUserField.setText(this.otfUser);
        this.partnerId = this.sapConfig.getProperty("custom.wrw.soap.partnerid", "");
        this.partnerIdField.setText(this.partnerId);
        this.objecttype = this.sapConfig.getProperty("custom.wrw.soap.objecttype", "06");
        this.objecttypeField.setText(this.objecttype);
    }

    public void applyConfig() throws FileNotFoundException, IOException {
        boolean changed = false;
        String newEndpointUrl = this.endpointUrlField.getText().trim();
        String newKeystoreFile = this.keystoreFileField.getText();
        String newKeystoreType = (String)this.keystoreTypeCombo.getSelectionModel().getSelectedItem();
        String newKeystorePassword = this.passwordField.getText().trim();
        String newOtfUser = this.otfUserField.getText().trim();
        String newPartnerId = this.partnerIdField.getText().trim();
        String newObjecttype = this.objecttypeField.getText().trim();
        if (this.endpointUrl != newEndpointUrl) {
            this.sapConfig.setProperty("custom.wrw.soap.endpoint", newEndpointUrl);
            changed = true;
        }
        if (this.keystoreFile != newKeystoreFile) {
            this.sapConfig.setProperty("cert.keystore", newKeystoreFile);
            changed = true;
        }
        if (this.keystoreType != newKeystoreType) {
            this.sapConfig.setProperty("cert.keystore.type", newKeystoreType);
            changed = true;
        }
        if (this.keystorePassword != newKeystorePassword) {
            this.sapConfig.setProperty("cert.keystore.password", newKeystorePassword);
            changed = true;
        }
        if (this.otfUser != newOtfUser) {
            this.sapConfig.setProperty("custom.wrw.soap.otfuser", newOtfUser);
            changed = true;
        }
        if (this.partnerId != newPartnerId) {
            this.sapConfig.setProperty("custom.wrw.soap.partnerid", newPartnerId);
            changed = true;
        }
        if (this.objecttype != newObjecttype) {
            this.sapConfig.setProperty("custom.wrw.soap.objecttype", newObjecttype);
            changed = true;
        }
        if (changed) {
            this.sapConfig.store(new FileOutputStream(this.propertiesFile), "");
            Dialogs.getInstance().showInfoDialog(this.app.getProject().getResourceText("dialog.restartTHEMIS.title"));
        }
    }

    private GridPane createSettingsGrid() {
        GridPane result = new GridPane();
        result.setHgap(10.0);
        result.setVgap(5.0);
        result.setMaxWidth(Double.MAX_VALUE);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setMaxWidth(Double.NEGATIVE_INFINITY);
        result.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setMaxWidth(Double.MAX_VALUE);
        cc2.setHgrow(Priority.ALWAYS);
        result.getColumnConstraints().add((Object)cc2);
        ColumnConstraints cc3 = new ColumnConstraints();
        cc3.setMaxWidth(Double.NEGATIVE_INFINITY);
        result.getColumnConstraints().add((Object)cc3);
        Label endpointLabel = new Label("SOAP Schnittstelle");
        this.endpointUrlField = new TextField();
        this.endpointUrlField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setColumnSpan((Node)this.endpointUrlField, (Integer)2);
        result.addRow(0, new Node[]{endpointLabel, this.endpointUrlField});
        Label keystoreLabel = new Label("Zertifikat");
        this.keystoreFileField = new TextField();
        this.keystoreFileField.setMaxWidth(Double.MAX_VALUE);
        this.keystoreFileField.setDisable(true);
        Button chooseKeystoreButton = new Button("Ausw\u00e4hlen");
        chooseKeystoreButton.setOnAction(t -> {
            File targetfile;
            FileChooser chooser = new FileChooser();
            File file = chooser.showOpenDialog((Window)new Stage());
            if (null != file && !(targetfile = new File(this.app.getApplicationDataConfigFolder(), file.getName())).getPath().equals(file.getPath())) {
                try {
                    Util.copy((File)file, (File)targetfile);
                    this.keystoreFileField.setText(targetfile.getPath());
                }
                catch (IOException ex) {
                    this.app.getDialog().showErrorDialog("Kann Datei nicht speichern: " + ex.getMessage());
                    this.app.getProject().getLogger().severe("error while saving keystore to CONF: " + ex.getMessage());
                }
            }
        });
        result.addRow(1, new Node[]{keystoreLabel, this.keystoreFileField, chooseKeystoreButton});
        Label keystoreTypeLabel = new Label("Typ");
        this.keystoreTypeCombo = new ComboBox();
        this.keystoreTypeCombo.setMaxWidth(Double.MAX_VALUE);
        GridPane.setColumnSpan(this.keystoreTypeCombo, (Integer)2);
        result.addRow(2, new Node[]{keystoreTypeLabel, this.keystoreTypeCombo});
        Label passwordLabel = new Label("Passwort");
        this.passwordField = new PasswordField();
        this.passwordField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setColumnSpan((Node)this.passwordField, (Integer)2);
        result.addRow(3, new Node[]{passwordLabel, this.passwordField});
        Label otfUserLabel = new Label("OTF-User");
        this.otfUserField = new TextField();
        this.otfUserField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setColumnSpan((Node)this.otfUserField, (Integer)2);
        result.addRow(4, new Node[]{otfUserLabel, this.otfUserField});
        Label partnerIdLabel = new Label("Partner-ID");
        this.partnerIdField = new TextField();
        this.partnerIdField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setColumnSpan((Node)this.partnerIdField, (Integer)2);
        result.addRow(5, new Node[]{partnerIdLabel, this.partnerIdField});
        Label objecttypeLabel = new Label("Gewerk");
        this.objecttypeField = new TextField();
        this.objecttypeField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setColumnSpan((Node)this.objecttypeField, (Integer)2);
        result.addRow(6, new Node[]{objecttypeLabel, this.objecttypeField});
        return result;
    }
}

