/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw;

import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.util.Pair;
import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.special.wrw.WienerWohnenSoapClient;
import at.grid.themis.special.wrw.data.CreateReportRequest;
import at.grid.themis.special.wrw.data.CreateReportResponse;
import at.grid.themis.special.wrw.data.ProcessingInfo;
import at.grid.themis.special.wrw.data.SoapObservationObject;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.soap.SOAPException;
import org.openide.util.Exceptions;

public class WienerWohnenObservationPanelFx
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private ComboBox<CmsEvent> eventsCombo;
    private TableView<Pair<SoapObservationObject, BooleanProperty>> observationTable;
    private boolean useFilter = true;
    Button btnAll = new Button("Alle");
    boolean closeDialog = false;

    public WienerWohnenObservationPanelFx() {
        this.initialize();
    }

    private void initialize() {
        this.setMaxWidth(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPadding(new Insets(10.0));
        this.setSpacing(10.0);
        GridPane filterGrid = this.createFilterGrid();
        this.getChildren().add((Object)filterGrid);
        GridPane content = this.createContentGrid();
        this.getChildren().add((Object)content);
        this.eventsCombo.getSelectionModel().selectFirst();
    }

    private GridPane createFilterGrid() {
        GridPane result = new GridPane();
        result.setHgap(10.0);
        result.setVgap(5.0);
        result.setMaxWidth(Double.MAX_VALUE);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setMaxWidth(Double.NEGATIVE_INFINITY);
        result.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setMaxWidth(Double.MAX_VALUE);
        cc2.setHgrow(Priority.ALWAYS);
        result.getColumnConstraints().add((Object)cc2);
        Label eventsLabel = new Label("Ereignis");
        this.eventsCombo = new ComboBox();
        ArrayList<CmsEvent> events = new ArrayList<CmsEvent>();
        for (CmsElementSummary es : this.project.getEvents()) {
            CmsEvent event = (CmsEvent)es.getElement();
            if (event.isSigned()) continue;
            events.add(event);
        }
        this.eventsCombo.getItems().addAll(events);
        this.eventsCombo.setMaxWidth(Double.MAX_VALUE);
        this.eventsCombo.getSelectionModel().selectedItemProperty().addListener((observable, prev, next) -> this.updateView(true));
        result.addRow(0, new Node[]{eventsLabel, this.eventsCombo});
        this.useFilter = true;
        return result;
    }

    private void updateView(final boolean select) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                Platform.runLater(() -> {
                    WienerWohnenObservationPanelFx.this.updateTableView(null, false);
                    WienerWohnenObservationPanelFx.this.observationTable.setPlaceholder((Node)new Label("Beobachtungen werden geladen ..."));
                });
                CmsEvent event = (CmsEvent)WienerWohnenObservationPanelFx.this.eventsCombo.getSelectionModel().getSelectedItem();
                ArrayList recs = new ArrayList();
                if (WienerWohnenObservationPanelFx.this.useFilter) {
                    ThemisFilter filter = new ThemisFilter(WienerWohnenObservationPanelFx.this.app, false);
                    filter.setFilter(WienerWohnenObservationPanelFx.this.app.getFilter(), false);
                    filter.getEventId().setItem(event.getId(), (Object)this);
                    recs.addAll(filter.getFilteredObservations());
                } else {
                    ThemisFilter filter = new ThemisFilter(WienerWohnenObservationPanelFx.this.app, false);
                    filter.getEventId().setItem(event.getId(), (Object)this);
                    recs.addAll(filter.getFilteredObservations());
                }
                Platform.runLater(() -> WienerWohnenObservationPanelFx.this.updateTableView(recs, select));
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.start();
    }

    private void updateTableView(List<DataRecord> recs, boolean select) {
        this.btnAll.setText("Alle");
        if (null != this.observationTable) {
            this.observationTable.getItems().clear();
            if (recs != null) {
                for (DataRecord rec : recs) {
                    this.observationTable.getItems().add((Object)new Pair((Object)SoapObservationObject.fromRecord(rec), (Object)new SimpleBooleanProperty(select)));
                }
                this.btnAll.setText("Alle [" + recs.size() + "]");
            }
            this.observationTable.setPlaceholder((Node)new Label("Keine Beobachtungen gefunden!"));
        }
    }

    private GridPane createContentGrid() {
        GridPane result = new GridPane();
        result.setHgap(10.0);
        result.setVgap(5.0);
        result.setMaxWidth(Double.MAX_VALUE);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setMaxWidth(Double.NEGATIVE_INFINITY);
        result.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setMaxWidth(Double.MAX_VALUE);
        cc2.setHgrow(Priority.ALWAYS);
        result.getColumnConstraints().add((Object)cc2);
        VBox buttonBox = this.createButtonBox();
        this.observationTable = this.createObservationTable();
        result.addRow(0, new Node[]{buttonBox, this.observationTable});
        return result;
    }

    private VBox createButtonBox() {
        VBox result = new VBox();
        result.setSpacing(10.0);
        this.btnAll.setMinWidth(150.0);
        this.btnAll.setPrefWidth(150.0);
        this.btnAll.setMinHeight(50.0);
        this.btnAll.setPrefHeight(50.0);
        this.btnAll.setOnAction(ev -> this.observationTable.getItems().forEach(item -> ((BooleanProperty)item.value2).set(true)));
        result.getChildren().add((Object)this.btnAll);
        Button btnNo = new Button("Keine");
        btnNo.setMinWidth(150.0);
        btnNo.setPrefWidth(150.0);
        btnNo.setMinHeight(50.0);
        btnNo.setPrefHeight(50.0);
        btnNo.setOnAction(ev -> this.observationTable.getItems().forEach(item -> ((BooleanProperty)item.value2).set(false)));
        result.getChildren().add((Object)btnNo);
        return result;
    }

    private TableView<Pair<SoapObservationObject, BooleanProperty>> createObservationTable() {
        TableView result = new TableView();
        result.setEditable(true);
        result.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        result.getColumns().add(this.createSelectionColumn(result));
        result.getColumns().add(this.createNumberColumn(result));
        result.getColumns().add(this.createTitleColumn(result));
        result.getColumns().add(this.createDescriptionColumn(result));
        return result;
    }

    private TableColumn<Pair<SoapObservationObject, BooleanProperty>, String> createDescriptionColumn(TableView table) {
        TableColumn col = new TableColumn("Beschreibung");
        col.setCellValueFactory(observation -> new ReadOnlyStringWrapper(((SoapObservationObject)((Pair)observation.getValue()).value1).getDescription()));
        col.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.5));
        return col;
    }

    private TableColumn<Pair<SoapObservationObject, BooleanProperty>, String> createTitleColumn(TableView table) {
        TableColumn result = new TableColumn("Titel");
        result.setCellValueFactory(observation -> new ReadOnlyStringWrapper(((SoapObservationObject)((Pair)observation.getValue()).value1).getTitle()));
        result.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.4));
        return result;
    }

    private TableColumn<Pair<SoapObservationObject, BooleanProperty>, String> createNumberColumn(TableView table) {
        TableColumn result = new TableColumn("Nummer");
        result.setCellValueFactory(observation -> new ReadOnlyStringWrapper(((SoapObservationObject)((Pair)observation.getValue()).value1).getNumber()));
        result.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.07));
        return result;
    }

    private TableColumn<Pair<SoapObservationObject, BooleanProperty>, Boolean> createSelectionColumn(TableView table) {
        TableColumn result = new TableColumn("");
        result.setCellFactory(column -> new CheckBoxTableCell());
        result.setCellValueFactory(observation -> (BooleanProperty)((Pair)observation.getValue()).value2);
        result.prefWidthProperty().bind((ObservableValue)table.widthProperty().multiply(0.03));
        return result;
    }

    public void transferObservations(String endpoint, boolean onlyCheck) {
        WienerWohnenSoapClient client;
        try {
            client = new WienerWohnenSoapClient(new URL(endpoint));
        }
        catch (IOException ex) {
            this.app.getDialog().showErrorDialog("Error reading SAP Mapping in c:/programdata/themis", (Exception)ex);
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        ArrayList<Long> observationIds = new ArrayList<Long>();
        for (Pair item : this.observationTable.getItems()) {
            if (!((BooleanProperty)item.value2).getValue().booleanValue()) continue;
            observationIds.add(((SoapObservationObject)item.value1).getObservationId());
        }
        if (observationIds.size() <= 0 && !Dialogs.showConfirmDialog((String)"Es sind keine Beobachtungen f\u00fcr die \u00dcbertragung ausgew\u00e4hlt. Trotzdem senden?")) {
            return;
        }
        CmsEvent event = (CmsEvent)this.eventsCombo.getSelectionModel().getSelectedItem();
        if (null == event) {
            this.app.getDialog().showWarningDialog("Es ist kein Ereignis vorhanden!");
            return;
        }
        if (!this.project.getProjectElement().hasAttributeValue("projectnumber")) {
            this.app.getDialog().showWarningDialog("Es ist keine Projektnummer erfasst!");
            return;
        }
        if (!this.project.getProjectElement().hasAttributeValue("info")) {
            this.app.getDialog().showWarningDialog("Es ist keine Bestellnummer (unter 'Sonstiges') erfasst!");
            return;
        }
        RequestResponsePair r = new RequestResponsePair();
        ThemisTaskWithDialog.createTaskWithCounterAndCancel((String)"\u00dcbertragen", ph -> {
            ph.switchToDeterminate(observationIds.size());
            client.setEvent(event, observationIds);
            boolean count = true;
            ph.setDisplayName("Ereignis mit " + observationIds.size() + " Beobachtungen wird \u00fcbertragen.");
            try {
                r.setRequest(client.createReport(onlyCheck, ph));
                if (ph.isCancelled()) {
                    return;
                }
                if (!onlyCheck && !client.hasErrors()) {
                    ph.progress("\u00dcbertragung wird gestartet ...");
                    r.setResponse(client.sendReport(r.request, ph));
                }
            }
            catch (SOAPException ex) {
                Dialogs.showErrorDialog((String)"Fehler beim \u00dcbertragen", (Exception)((Object)ex));
                this.project.getLogger().severe(ex.getMessage());
                ex.printStackTrace();
            }
            catch (JAXBException ex) {
                Dialogs.showErrorDialog((String)"Fehler beim \u00dcbertragen", (Exception)((Object)ex));
                this.project.getLogger().severe(ex.getMessage());
                ex.printStackTrace();
            }
            catch (DatatypeConfigurationException ex) {
                Dialogs.showErrorDialog((String)"Datentypfehler beim Erstellen des Berichts", (Exception)ex);
                this.project.getLogger().severe(ex.getMessage());
                ex.printStackTrace();
            }
            catch (IOException ex) {
                Dialogs.showErrorDialog((String)"Fehler beim Erstellen des Berichts", (Exception)ex);
                this.project.getLogger().severe(ex.getMessage());
                ex.printStackTrace();
            }
        });
        if (client.hasErrors()) {
            this.app.getDialog().showInfoMessageDialog(client.getErrorsAsString(true), "Fehler in den Daten");
            return;
        }
        if (onlyCheck) {
            this.app.getDialog().showInfoDialog("Keine Fehler");
            return;
        }
        if (r.response != null && r.response.isProcessingOK()) {
            if (r.response.isDuplicate()) {
                Dialogs.showInfoDialog((String)"Ereignis ist bereits \u00fcbertragen worden, \u00dcbertragung abgebrochen");
            } else {
                this.app.getDialog().showInfoDialog("Ereignis wurde erfolgreich \u00fcbertragen!");
                String foldername = this.app.getProject().getProjectProperty("custom.wienerwohnen.folder.befund");
                File folder = foldername == null ? null : new File(foldername);
                File fBefund = client.getBefundFile();
                folder = new ThemisFileDialog("In welchen Ordner soll der Befund gespeichert werden", ThemisFileDialog.DIALOGTYPE.DIRECTORY, folder, null, THEMIS.getFolderFilter(), null, false).getSelectedFile();
                if (folder != null) {
                    try {
                        ThemisFolder tf;
                        foldername = folder.getAbsolutePath();
                        String t = this.project.getProjectElement().getAttributeValue("title", "");
                        if ("".equals(t) && (tf = this.project.getThemisFile()) != null) {
                            t = tf.getFolderName();
                        }
                        t = t.replaceAll("\\\\", "-");
                        t = t.replaceAll("/", "-");
                        Date dt0 = event.getDateAttribute("date").getDate();
                        String dtStr2 = Util.formatDate((Date)dt0, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone());
                        File fDest = new File(folder, "OBS - " + t + " - " + dtStr2 + ".pdf");
                        Util.copy((File)fBefund, (File)fDest);
                        this.app.getProject().setProjectProperty("custom.wienerwohnen.folder.befund", foldername);
                        THEMIS.showFileResultDialog((File)fDest, (boolean)true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.closeDialog = true;
            }
        } else if (client.hasErrors()) {
            this.app.getDialog().showInfoMessageDialog(client.getErrorsAsString(true), "Fehler in den Daten");
        } else if (r.response != null) {
            StringBuilder sb = new StringBuilder();
            for (ProcessingInfo i : r.response.getProcessingInfo()) {
                sb.append("\n- ").append(i.getDescription());
            }
            this.app.getDialog().showInfoMessageDialog(sb.toString(), "Fehler bei der Verarbeitung auf dem Server");
        }
        this.updateView(false);
    }

    public boolean doClose() {
        return this.closeDialog;
    }

    private class RequestResponsePair {
        CreateReportResponse response;
        CreateReportRequest request;

        private RequestResponsePair() {
        }

        public void setRequest(CreateReportRequest r) {
            this.request = r;
        }

        public void setResponse(CreateReportResponse r) {
            this.response = r;
        }
    }

    private class FilterComboboxModel {
        private final int id;
        private final String title;

        public FilterComboboxModel(int value, String title) {
            this.id = value;
            this.title = title;
        }

        public int getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return this.title;
        }
    }
}

