/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw;

import at.grid.cms.storage.DataRecord;
import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.special.wrw.WienerWohnenConfigurationPanelFx;
import at.grid.themis.special.wrw.WienerWohnenObservationPanelFx;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WienerWohnenPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private JButton btnSettings;
    private JButton btnTransfer;
    private JButton btnUpdateFrist;
    private JButton btnUpdateFrist1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;

    public WienerWohnenPanel() {
        this.initComponents();
    }

    private void correctFristSettings() {
        List recs = this.project.getDatastorage().executeQuery("SELECT idelement,title FROM tdtaEleObservation", true).getResult();
        ThemisTaskWithDialog.createTaskWithCounterAndCancel((String)"Wird aktualisiert", ph -> {
            ph.switchToDeterminate(recs.size());
            for (DataRecord rec : recs) {
                long id = rec.getLong("idelement");
                ph.progress("OBS #" + id + " (" + rec.getString("title") + ")");
                ph.increaseProgress(1);
                try {
                    ResultSet rs = this.project.getDatastorage().executeQueryForResultSet(" SELECT * FROM tdtaelementhistory AS h WHERE idelement=" + id + " AND savedate<'2023-06-16' ORDER BY savedate DESC LIMIT 1", true);
                    if (rs.next()) {
                        String xml = Util.inflate((byte[])rs.getBytes("data"));
                        String dt = rs.getString("savedate");
                        SAXBuilder sb = new SAXBuilder();
                        Document doc = sb.build((Reader)new StringReader(xml));
                        String obstype = Util.getXmlAttribute((Element)doc.getRootElement(), (String)"/observation/data/observationtype/@id", null);
                        String set = obstype == null || "-1".equals(obstype) ? "null" : obstype;
                        String sql = "UPDATE tdtaEleObservation SET idobservationtype=" + set + " WHERE idelement=" + id;
                        this.project.getDatastorage().executeUpdate(sql, true);
                        sql = "UPDATE tdtaEleHistory SET idobservationtype=" + set + " WHERE idelement IN (SELECT elementfrom FROM tdtaRelation WHERE elementto=" + id + " AND relationcode='historyobservation')";
                        this.project.getDatastorage().executeUpdate(sql, true);
                    }
                }
                catch (IOException | SQLException | JDOMException throwable) {
                    // empty catch block
                }
                if (!ph.isCancelled()) continue;
                break;
            }
        });
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.btnTransfer = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.btnSettings = new JButton();
        this.jLabel4 = new JLabel();
        this.btnUpdateFrist = new JButton();
        this.jLabel5 = new JLabel();
        this.btnUpdateFrist1 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.jLabel2.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.btnTransfer.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTransfer, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.btnTransfer.text"));
        this.btnTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WienerWohnenPanel.this.btnTransferActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 8;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnTransfer, gridBagConstraints);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 127, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.btnSettings.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSettings, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.btnSettings.text"));
        this.btnSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WienerWohnenPanel.this.btnSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSettings, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.jLabel4.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.btnUpdateFrist.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpdateFrist, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.btnUpdateFrist.text"));
        this.btnUpdateFrist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WienerWohnenPanel.this.btnUpdateFristActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnUpdateFrist, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.jLabel5.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.btnUpdateFrist1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpdateFrist1, (String)NbBundle.getMessage(WienerWohnenPanel.class, (String)"WienerWohnenPanel.btnUpdateFrist1.text"));
        this.btnUpdateFrist1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WienerWohnenPanel.this.btnUpdateFrist1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnUpdateFrist1, gridBagConstraints);
    }

    private void btnSettingsActionPerformed(ActionEvent evt) {
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("WienerWohnenSAPKonfiguration", 500, 500).setParentFrame(THEMIS.getMainWindow());
        WienerWohnenConfigurationPanelFx pane = new WienerWohnenConfigurationPanelFx();
        pane.populate();
        JavaFxDialog fxDlg = new JavaFxDialog((Node)pane);
        fxDlg.addSaveButton("Speichern").setOnAction(ev -> {
            try {
                pane.applyConfig();
                fxDlg.closeDialog();
                dlg.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
        fxDlg.addCancelButton("Abbrechen").setOnAction(ev -> {
            fxDlg.closeDialog();
            dlg.close();
        });
        dlg.setContent((Node)fxDlg);
        dlg.show();
    }

    private void btnTransferActionPerformed(ActionEvent evt) {
        if (!this.project.isOpen()) {
            Dialogs.showWarningDialog((String)"Es ist kein Projekt ge\u00f6ffnet!");
            return;
        }
        File propertiesFile = new File(this.app.getApplicationDataConfigFolder(), "hab.properties");
        try {
            if (propertiesFile.isFile()) {
                Properties sapConfig = new Properties();
                sapConfig.load(new FileReader(propertiesFile));
                String endpoint = sapConfig.getProperty("custom.wrw.soap.endpoint", "");
                if (endpoint == null || endpoint.trim().length() < 1) {
                    Dialogs.showWarningDialog((String)"Keine URL f\u00fcr die \u00dcbertragung definiert!");
                    return;
                }
                JavaFxSwingDialog dlg = new JavaFxSwingDialog("DatentransferWienerWohnenSAP", 500, 500).setParentFrame(THEMIS.getMainWindow());
                WienerWohnenObservationPanelFx pane = new WienerWohnenObservationPanelFx();
                JavaFxDialog fxDlg = new JavaFxDialog((Node)pane);
                fxDlg.addCancelButton("Abbrechen").setOnAction(ev -> {
                    fxDlg.closeDialog();
                    dlg.close();
                });
                fxDlg.addSaveButton("Nur pr\u00fcfen").setOnAction(ev -> SwingUtilities.invokeLater(() -> pane.transferObservations(endpoint, true)));
                fxDlg.addSaveButton("Senden").setOnAction(ev -> SwingUtilities.invokeLater(() -> {
                    pane.transferObservations(endpoint, false);
                    if (pane.doClose()) {
                        fxDlg.closeDialog();
                        dlg.close();
                    }
                }));
                dlg.setContent((Node)fxDlg);
                dlg.show();
            } else {
                Dialogs.showWarningDialog((String)"Konfigurationsdatei nicht gefunden! (hab.properties)");
            }
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btnUpdateFristActionPerformed(ActionEvent evt) {
        this.correctFristSettings();
    }

    private void btnUpdateFrist1ActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("\u00dcbertragungsdatei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, new File(this.project.getThemisFile().getProjectFolder(), "soap"), null, THEMIS.getFileExtensionFilter((String)"xml", (String)"*.xml SOAP Nachrichten"), "xml", false).getSelectedFile();
        if (f != null) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Namespace nsSoap = Namespace.getNamespace((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
                Namespace ns3 = Namespace.getNamespace((String)"ns3", (String)"http://www.wien.gv.at/befundung");
                Document doc = builder.build(f);
                Element root = doc.getRootElement();
                Element body = root.getChild("Body", nsSoap);
                Element request = body.getChild("CreateReportRequest", ns3);
                Element attachments = request.getChild("Attachments");
                Element base64 = attachments.getChild("Base64Content");
                String base64content = base64.getText();
                byte[] data = Base64.getDecoder().decode(base64content);
                File ftemp = new File(this.project.getTempfileLocation(), "wrw" + new Date().getTime() + ".pdf");
                FileUtils.writeByteArrayToFile((File)ftemp, (byte[])data);
                Desktop.getDesktop().open(ftemp);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.app.getDialog().showErrorDialog("Fehler beim Laden der DAtei", ex);
            }
        }
    }
}

