/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.report.ExportUtil;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.special.wrw.PdfObservationExporter;
import at.grid.util.Util;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;

public class WienerWohnenPdfExporter
extends PdfObservationExporter {
    public WienerWohnenPdfExporter(CmsReport rep, boolean withTitlePage) {
        super(rep, withTitlePage);
        rep.templatePdfLayout.add(new PdfContentStandardTable());
    }

    public void createTitle() {
        this.addToDocument((Element)this.createParagraph("Organisatorischer Brandschutz", this.formatTitle));
        this.addToDocument((Element)this.createParagraph("\u00dcberpr\u00fcfung lt. TRVB N 116", this.formatTitle2));
        this.addToDocument((Element)this.createParagraph(" ", this.formatTitle2));
    }

    public void createTitlePage(boolean withImage, boolean withProjectInfo, boolean withEventInfo, boolean withReportInfo) {
        try {
            this.createTitle();
            PdfPTable table = new PdfPTable(2);
            table.setWidthPercentage(100.0f);
            table.setWidths(new int[]{40, 60});
            table.setHorizontalAlignment(0);
            LayoutCell l1 = this.getCellLayoutNoBorder().derive(11, true);
            LayoutCell l2 = this.getCellLayoutNoBorder().derive(11, false);
            table.addCell(this.createPdfCell("Auftraggeber:", l1, null));
            table.addCell(this.createPdfCell(this.projectElement.getAttributeValue("customer"), l2, null));
            table.completeRow();
            table.completeRow();
            table.addCell(this.createPdfCell("Geb\u00e4udeart:", l1, null));
            table.addCell(this.createPdfCell("Wohnhaus/Garage", l2, null));
            table.completeRow();
            table.completeRow();
            table.addCell(this.createPdfCell("HBZ:", l1, null));
            table.addCell(this.createPdfCell(this.projectElement.getAttributeValue("projectnumber"), l2, null));
            table.completeRow();
            table.completeRow();
            table.addCell(this.createPdfCell("Adresse", l1, null));
            table.addCell(this.createPdfCell(this.projectElement.getAttributeValue("projectlocation"), l2, null));
            table.completeRow();
            table.completeRow();
            table.addCell(this.createPdfCell("Pr\u00fcfung durch:", l1, null));
            table.addCell(this.createPdfCell("Wiener Wohnen\nHausbetreuung GmbH\n1030 Wien, Erdbergstra\u00dfe 200", l2, null));
            table.completeRow();
            table.completeRow();
            table.addCell(this.createPdfCell("Pr\u00fcfdatum:", l1, null));
            String dt = "";
            String time = "";
            String participants = "";
            if (this.rep.event != null) {
                dt = Util.formatDate((Date)this.rep.event.getDateAttribute("date").getDate(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone());
                time = this.rep.event.getAttributeValue("time");
                participants = this.rep.event.getAttributeValue("participants");
            }
            table.addCell(this.createPdfCell(dt, l2, null));
            table.completeRow();
            table.addCell(this.createPdfCell("Uhrzeit", l1, null));
            table.addCell(this.createPdfCell(time, l2, null));
            table.completeRow();
            table.completeRow();
            table.addCell(this.createPdfCell("Pr\u00fcfer:", l1, null));
            table.addCell(this.createPdfCell(participants, l2, null));
            table.completeRow();
            table.completeRow();
            this.addToDocument((Element)table);
            this.addToDocument((Element)this.createParagraph(" ", this.formatText));
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
        }
        this.document.newPage();
    }

    @Override
    public void createObservationTable(ThemisProject project, CmsUser user, ArrayList<Long> ids, CmsEvent event) throws DocumentException, IOException {
        int[] widths = new int[]{8, 70, 37, 15};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        HashMap<Long, CmsEvent> events = new HashMap<Long, CmsEvent>();
        boolean useMeasure = this.app.getSettings().getObservationAttribute("measure").isUsed();
        boolean useStatus = this.app.getSettings().getObservationAttribute("done").isUsed();
        ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("donedate"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("type"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("text2"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("longtext2"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("list1"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("list3"));
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Pos", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Gegenstand/Plan, Beobachtung" + (useMeasure ? ", Ma\u00dfnahme" : ""), this.formatTableHeader, 1.0f, 0, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Datum", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Status", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        Object colPixelsLoc = null;
        long lastLoc = -1L;
        ArrayList<CmsHistory> histories = new ArrayList<CmsHistory>();
        int counter = 1;
        String statusText = "";
        Placeholder ph = new Placeholder(this.rep);
        ph.setEvent(event);
        if (this.progress != null) {
            this.progress.progress("Beobachtungen werden geladen, PDF wird erstellt");
        }
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        for (long id : ids) {
            long docId;
            CmsLocation loc;
            CmsObservation obs;
            CmsElement ele;
            this.progressCurrent += this.progressStep;
            if (this.progress != null) {
                this.progress.progress((int)this.progressCurrent);
            }
            if ("observation".equals((ele = project.loadElement(id, user)).getElementcode())) {
                obs = (CmsObservation)ele;
                loc = null;
            } else {
                obs = (CmsObservation)project.getDefaultElement("observation");
                loc = (CmsLocation)ele;
                if (!this.rep.exportLocationsWithoutObservations) continue;
            }
            if (obs != null) {
                Iterator iterator = obs.getRelationAttribute("infos").getElementIds(false).iterator();
                while (iterator.hasNext()) {
                    docId = (Long)iterator.next();
                    if (this.documentIds.contains(docId)) continue;
                    this.documentIds.add(docId);
                }
                if (loc == null) {
                    long locid = obs.getRelationAttribute("location").getFirstElementId();
                    if (locid >= 0L) {
                        loc = (CmsLocation)project.loadElement(locid, user);
                    }
                } else {
                    long locid = loc.getId();
                }
            }
            if (loc != null) {
                Iterator locid = loc.getRelationAttribute("infos").getElementIds(false).iterator();
                while (locid.hasNext()) {
                    docId = (Long)locid.next();
                    if (this.documentIds.contains(docId)) continue;
                    this.documentIds.add(docId);
                }
            }
            histories.clear();
            if (this.rep.exportWithHistories) {
                if (obs.getHistories() != null) {
                    for (CmsElement h : obs.getHistories()) {
                        if (h == null) continue;
                        histories.add((CmsHistory)h);
                    }
                }
            } else {
                CmsHistory h;
                CmsHistory cmsHistory = h = event == null ? obs.getLatestHistory() : obs.getHistory(event);
                if (h != null) {
                    histories.add(h);
                }
            }
            if (histories.isEmpty()) {
                histories.add((CmsHistory)project.getDefaultElement("history"));
            }
            for (CmsHistory hist : histories) {
                obs.applyHistory(hist);
                this.table.addCell(this.createPdfCell(loc == null ? "" : loc.getFullNumber() + (obs.getId() >= 0L ? "." + obs.getAttributeValue("number") : ""), true, this.formatTable, 1, 2));
                StringBuilder infoText = new StringBuilder();
                if (this.rep.exportWithHistories) {
                    long idEvent = hist.getEventId();
                    CmsEvent ev = null;
                    if (events.containsKey(idEvent)) {
                        ev = (CmsEvent)events.get(idEvent);
                    } else {
                        ev = hist.getEvent();
                        if (ev != null) {
                            events.put(ev.getId(), ev);
                        }
                    }
                    if (ev != null) {
                        infoText.append("Ereignis: ").append(ev.getTitle()).append("\n");
                    }
                }
                if (loc != null) {
                    infoText.append(loc.getAttributeValue("title"));
                    infoText.append("\n");
                    ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
                    block22: for (ThemisAttribute att : this.app.getSettings().getLocationAttributesUsed()) {
                        switch (att.getCmsCode()) {
                            case "title": 
                            case "building": 
                            case "plan": 
                            case "boolean1": {
                                continue block22;
                            }
                        }
                        atts.add(att);
                    }
                    String otherAtts = ThemisUtil.toString((CmsElement)loc, (String)"\n", (String)"\n", (boolean)false, atts, (boolean)false);
                    infoText.append(otherAtts).append("\n");
                }
                infoText.append(obs.toStringWithIgnore("", "\n", false, ignoreAtts));
                this.table.addCell(this.createPdfCell(infoText.toString(), true, this.formatTable, 0, 2));
                if (obs.getId() >= 0L) {
                    String dateText = "Erstellt: " + obs.getAttributeValue("creationdate") + "\nKontrolliert: " + hist.getAttributeValue("eventdate");
                    if (hist.hasAttributeValue("duedate")) {
                        dateText = dateText + "\n" + (obs.isOfType(2) ? "Termin: " : "F\u00e4llig: ") + hist.getAttributeValue("duedate");
                    }
                    if (useStatus && obs.getBooleanAttribute("done").isSet() && (obs.isOfType(1) || obs.isOfType(4))) {
                        dateText = dateText + "\nErledigt: " + obs.getAttributeValue("donedate");
                    }
                    this.table.addCell(this.createPdfCell(dateText, true, this.formatTable, 2, 2));
                } else {
                    this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                }
                if (obs.getId() >= 0L) {
                    String obstype = "";
                    switch ((int)obs.getKeyAttribute("type").getId()) {
                        case 2: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle);
                            break;
                        }
                        case 1: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel);
                            break;
                        }
                        case 3: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation);
                            break;
                        }
                        case 4: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe);
                        }
                    }
                    Color bgColor = null;
                    if (useStatus && obs.isOfType(1) || obs.isOfType(4)) {
                        statusText = obstype + ("".equals(obstype) ? "" : "\n") + (obs.getBooleanAttribute("done").isSet() ? this.rep.textStatusDone : this.rep.textStatusOpen);
                        bgColor = obs.getBooleanAttribute("done").isSet() ? ThemisColors.lightgreen : ThemisColors.COLOR_DEFECT;
                    } else {
                        statusText = obstype;
                    }
                    this.table.addCell(this.createPdfCell(statusText, this.formatTable, 1.0f, 1, 2, bgColor, 5.0f));
                } else {
                    this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                }
                this.table.completeRow();
                ArrayList imageUploadItems = ExportUtil.getImages((CmsReport)this.rep, (CmsLocation)loc, (CmsObservation)obs, (CmsHistory)hist);
                this.addImageRow(imageUploadItems, this.table);
                ++counter;
            }
        }
        this.document.add((Element)this.table);
    }
}

