/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.special.wrw.WienerWohnenPdfExporter;
import at.grid.themis.special.wrw.data.AdditionalReferenceInfo;
import at.grid.themis.special.wrw.data.AddressInfo;
import at.grid.themis.special.wrw.data.Attachments;
import at.grid.themis.special.wrw.data.CreateReportRequest;
import at.grid.themis.special.wrw.data.CreateReportResponse;
import at.grid.themis.special.wrw.data.FloorInfo;
import at.grid.themis.special.wrw.data.ReportHeader;
import at.grid.themis.special.wrw.data.ReportPositions;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WienerWohnenSoapClient {
    public static String TEST_ENDPOINT = "https://stp-test.wien.gv.at:4543/wrwsap_befundung/";
    public static String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final Logger logger = this.project.getLogger();
    private final URL endpoint;
    private CmsEvent event;
    private ArrayList<Long> observationIds = new ArrayList();
    private Properties sapMapping = new Properties();
    private ArrayList<String> errors = new ArrayList();
    private File fBefund = null;

    public WienerWohnenSoapClient(URL endpoint) throws FileNotFoundException, IOException {
        this.endpoint = endpoint;
        File f = new File(this.app.getApplicationDataConfigFolder(), "wienerwohnen.properties");
        if (f.isFile()) {
            this.sapMapping.load(new FileReader(f));
        }
        this.checkProperty(this.sapMapping, "ort.keller", "6");
        this.checkProperty(this.sapMapping, "ort.dachboden", "26");
        this.checkProperty(this.sapMapping, "ort.stiegenhaus", "29");
        this.checkProperty(this.sapMapping, "ort.m\u00fcllraum", "19");
        this.checkProperty(this.sapMapping, "ort.waschk\u00fcche", "22");
        this.checkProperty(this.sapMapping, "ort.kinderwagenraum", "16");
        this.checkProperty(this.sapMapping, "ort.heizraum", "13");
        this.checkProperty(this.sapMapping, "ort.flachdach", "11");
        this.checkProperty(this.sapMapping, "ort.abstellraum", "7");
        this.checkProperty(this.sapMapping, "ort.installationsschacht,-keller", "15");
        this.checkProperty(this.sapMapping, "ort.garage", "12");
        this.checkProperty(this.sapMapping, "ort.absperreinrichtungsraum", "42");
        this.checkProperty(this.sapMapping, "ort.gr\u00fcnfl\u00e4che", "41");
        this.checkProperty(this.sapMapping, "ort.befestigte fl\u00e4che", "3");
        this.checkProperty(this.sapMapping, "ort.fassade", "2");
        this.checkProperty(this.sapMapping, "ort.z\u00e4hlernische", "24");
        this.checkProperty(this.sapMapping, "ort.triebwerksraum", "5");
        this.checkProperty(this.sapMapping, "ort.abstellraum", "7");
        this.checkProperty(this.sapMapping, "ort.heizraum", "13");
        this.checkProperty(this.sapMapping, "ort.installationsschacht", "14");
        this.checkProperty(this.sapMapping, "ort.installationsschacht,-keller", "15");
        this.checkProperty(this.sapMapping, "ort.waschk\u00fcche", "22");
        this.checkProperty(this.sapMapping, "ort.zentralwaschk\u00fcche", "25");
        this.checkProperty(this.sapMapping, "ort.gemeinschaftsraum", "27");
        this.checkProperty(this.sapMapping, "ort.notfallstiegenhaus", "28");
        this.checkProperty(this.sapMapping, "ort.kellergang", "30");
        this.checkProperty(this.sapMapping, "ort.schachtumwehrung", "36");
        this.checkProperty(this.sapMapping, "ort.stahl-glas-aufzugsturm", "38");
        this.checkProperty(this.sapMapping, "ort.schachtt\u00fcre", "35");
        this.checkProperty(this.sapMapping, "stockwerk.erdgeschoss", "59");
        this.checkProperty(this.sapMapping, "stockwerk.eg/1", "61");
        this.checkProperty(this.sapMapping, "stockwerk.1", "4");
        this.checkProperty(this.sapMapping, "stockwerk.1/2", "52");
        this.checkProperty(this.sapMapping, "stockwerk.2", "5");
        this.checkProperty(this.sapMapping, "stockwerk.2/3", "53");
        this.checkProperty(this.sapMapping, "stockwerk.3", "6");
        this.checkProperty(this.sapMapping, "stockwerk.3/4", "54");
        this.checkProperty(this.sapMapping, "stockwerk.4", "7");
        this.checkProperty(this.sapMapping, "stockwerk.4/5", "55");
        this.checkProperty(this.sapMapping, "stockwerk.5", "8");
        this.checkProperty(this.sapMapping, "stockwerk.5/6", "56");
        this.checkProperty(this.sapMapping, "stockwerk.6", "9");
        this.checkProperty(this.sapMapping, "stockwerk.6/7", "57");
        this.checkProperty(this.sapMapping, "stockwerk.7", "10");
        this.checkProperty(this.sapMapping, "stockwerk.7/8", "58");
        this.checkProperty(this.sapMapping, "stockwerk.8", "11");
        this.checkProperty(this.sapMapping, "stockwerk.9", "12");
        this.checkProperty(this.sapMapping, "stockwerk.10", "13");
        this.checkProperty(this.sapMapping, "stockwerk.11", "14");
        this.checkProperty(this.sapMapping, "stockwerk.12", "15");
        this.checkProperty(this.sapMapping, "stockwerk.13", "16");
        this.checkProperty(this.sapMapping, "stockwerk.14", "17");
        this.checkProperty(this.sapMapping, "stockwerk.15", "18");
        this.checkProperty(this.sapMapping, "stockwerk.16", "19");
        this.checkProperty(this.sapMapping, "stockwerk.17", "20");
        this.checkProperty(this.sapMapping, "stockwerk.18", "21");
        this.checkProperty(this.sapMapping, "stockwerk.19", "22");
        this.checkProperty(this.sapMapping, "stockwerk.20", "23");
        this.checkProperty(this.sapMapping, "stockwerk.21", "24");
        this.checkProperty(this.sapMapping, "stockwerk.22", "25");
        this.checkProperty(this.sapMapping, "stockwerk.-1", "2");
        this.checkProperty(this.sapMapping, "stockwerk.-2", "1");
        this.checkProperty(this.sapMapping, "stockwerk.dachgeschoss", "60");
        this.checkProperty(this.sapMapping, "stockwerk.0", "3");
        this.checkProperty(this.sapMapping, "stockwerk.hochparterre", "50");
        this.checkProperty(this.sapMapping, "stockwerk.mezzanin", "51");
        this.checkProperty(this.sapMapping, "frist.sofort", "1");
        this.checkProperty(this.sapMapping, "frist.3 monate", "3");
        this.checkProperty(this.sapMapping, "frist.6 monate", "4");
        this.checkProperty(this.sapMapping, "frist.9 monate", "5");
        this.checkProperty(this.sapMapping, "frist.12 monate", "6");
        this.checkProperty(this.sapMapping, "frist.information", "7");
        this.checkProperty(this.sapMapping, "frist.wird durch hab behoben", "8");
        this.checkProperty(this.sapMapping, "frist.sofort behoben", "9");
        this.checkProperty(this.sapMapping, "nofloor.flachdach", "1");
        this.checkProperty(this.sapMapping, "nofloor.gr\u00fcnfl\u00e4che", "1");
        this.checkProperty(this.sapMapping, "nofloor.befestigte fl\u00e4che", "1");
        this.sapMapping.store(new FileWriter(f), "");
    }

    private void checkProperty(Properties props, String key, String defaultValue) {
        props.setProperty(key, props.getProperty(key, defaultValue));
    }

    public void setEvent(CmsEvent event, ArrayList<Long> observationIds) {
        this.event = event;
        this.observationIds.clear();
        this.observationIds.addAll(observationIds);
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String getErrorsAsString(boolean all) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String e : this.errors) {
            if (count == 10 && !all) {
                sb.append("... und " + (this.errors.size() - 10) + " weitere Fehler");
                break;
            }
            sb.append("- ").append(e).append("\n");
            ++count;
        }
        return sb.toString();
    }

    public CreateReportRequest createReport(boolean onlyCheck, ProgressHandler ph) throws SOAPException, JAXBException, DatatypeConfigurationException, IOException {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        int reportStatus = 1;
        CreateReportRequest request = new CreateReportRequest();
        ArrayList positions = new ArrayList();
        int counter = 0;
        for (long id : this.observationIds) {
            CmsObservation obs = (CmsObservation)this.project.loadElement(id, this.project.getUser());
            ph.progress("Beobachtung " + obs.getFullNumber(), ++counter);
            ReportPositions pos = this.createReportPosition(obs);
            if (pos != null) {
                request.addReportPosition(pos);
                String frist = obs.getKeyAttribute("priority").getValue();
                switch (frist.toLowerCase()) {
                    case "sofort": {
                        reportStatus = 3;
                        break;
                    }
                    case "3 monate": 
                    case "6 monate": 
                    case "9 monate": 
                    case "12 monate": {
                        reportStatus = Math.max(reportStatus, 2);
                        break;
                    }
                    default: {
                        reportStatus = Math.max(reportStatus, 2);
                    }
                }
            }
            if (!ph.isCancelled()) continue;
            return null;
        }
        ReportHeader header = this.createReportHeader(this.event, reportStatus);
        request.setReportHeader(header);
        if (!onlyCheck) {
            ph.progress("Anhang wird erstellt...");
            Attachments att = this.createAttachment();
            request.addAttachment(att);
        }
        return this.errors.isEmpty() ? request : null;
    }

    public ReportHeader createReportHeader(CmsEvent event, int status) throws DatatypeConfigurationException, FileNotFoundException, FileNotFoundException, SOAPException, IOException {
        ReportHeader result = new ReportHeader();
        result.setCommunicationGUID(event.getUUIDasString());
        File propertiesFile = new File(this.app.getApplicationDataConfigFolder(), "hab.properties");
        if (!propertiesFile.isFile()) {
            this.errors.add("Die Konfiguration f\u00fcr den Datentransfer ist nicht gesetzt");
            return null;
        }
        Properties sapConfig = new Properties();
        sapConfig.load(new FileReader(propertiesFile));
        result.setOTFUUser(sapConfig.getProperty("custom.wrw.soap.otfuser", ""));
        result.setPartnerID(sapConfig.getProperty("custom.wrw.soap.partnerid", ""));
        Instant dt = Instant.ofEpochMilli(event.getDateAttribute("date").getDate().getTime());
        String dtStr = dt.toString();
        Date dt0 = event.getDateAttribute("date").getDate();
        String dtStr2 = Util.formatDate((Date)dt0, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone());
        XMLGregorianCalendar date = DatatypeFactory.newInstance().newXMLGregorianCalendar(dtStr2);
        result.setReportingDate(date);
        String poNr = this.project.getProjectElement().getAttributeValue("info");
        if (poNr == null || "".equals(poNr)) {
            this.errors.add("Es ist keine Bestellnummer angegeben - Bestellnummer in Projekteigenschaften unter 'Projekt / Sonstiges' eintragen");
            return null;
        }
        poNr = poNr.substring(0, 10);
        result.setPONumber(poNr);
        result.setReportStatus("0" + Integer.toString(status));
        String projectNumber = this.project.getProjectElement().getAttributeValue("projectnumber");
        result.setExternalRefID(projectNumber + "_" + event.getId());
        AdditionalReferenceInfo refinfo = new AdditionalReferenceInfo();
        refinfo.setAccountingEntity(projectNumber.split("-")[0]);
        result.setAdditionalReferenceInfo(refinfo);
        String objecttype = sapConfig.getProperty("custom.wrw.soap.objecttype", "06");
        result.setObjectType(Util.expandString((String)objecttype, (String)"0", (int)2, (boolean)true));
        return result;
    }

    private ReportPositions createReportPosition(CmsObservation observation) throws DatatypeConfigurationException, SOAPException {
        boolean floorRequired;
        String projectNumber;
        int idx;
        String templateid;
        ReportPositions result = new ReportPositions();
        result.setPositionID(observation.getUUIDasString());
        String sap = observation.getAttributeValue("langtext2");
        if ((sap == null || "".equals(sap)) && null != (templateid = observation.getAttributeValue("templateid"))) {
            sap = this.project.getDatastorage().getElementAttribute(Util.parseLong((String)templateid, (long)-1L), "langtext2");
        }
        if (sap == null) {
            this.errors.add("Beobachtung '" + observation.getFullNumber() + " " + observation.getTitle() + "', Keine Vorlage bzw. keinen SAP-Code zu dieser Beobachtung gefunden");
            return null;
        }
        String[] tokens = sap.split("\n");
        if (tokens.length != 3) {
            this.errors.add("Beobachtung '" + observation.getFullNumber() + " " + observation.getTitle() + "': Der Fehlercode '" + sap + "' ist nicht g\u00fcltig");
            return null;
        }
        String faultMainGroup = tokens[0].split(":")[0];
        result.setFaultMainGroup(Util.expandString((String)faultMainGroup, (String)"0", (int)6, (boolean)true));
        String faultGroup = tokens[1].split(":")[0];
        result.setFaultGroup(Util.expandString((String)faultGroup, (String)"0", (int)6, (boolean)true));
        String faultType = tokens[2].split(":")[0];
        result.setFaultType(Util.expandString((String)faultType, (String)"0", (int)6, (boolean)true));
        CmsLocation loc = observation.getLocation();
        result.setExternalRefPosID(observation.getFullNumber());
        long id = observation.getKeyAttribute("observationtype").getId();
        String term = observation.getKeyAttribute("observationtype").getValue();
        if (term == null || "".equals(term)) {
            this.errors.add("Beobachtung '" + observation.getFullNumber() + " " + observation.getTitle() + "': Es ist kein Behebungszeitraum definiert");
            return null;
        }
        String repairPeriod = Util.expandString((String)this.sapMapping.getProperty("frist." + term.toLowerCase(), "3"), (String)"0", (int)5, (boolean)true);
        result.setRepairPeriod(repairPeriod);
        result.setRiskClass("00001");
        AddressInfo info = new AddressInfo();
        id = loc.getKeyAttribute("list1").getId();
        String ortterm = loc.getKeyAttribute("list1").getValue();
        if (ortterm == null) {
            this.errors.add("Gegenstand '" + loc.getFullNumber() + " " + loc.getTitle() + "': Es ist kein Ort definiert");
            return null;
        }
        String location = Util.expandString((String)this.sapMapping.getProperty("ort." + ortterm.toLowerCase(), "29"), (String)"0", (int)5, (boolean)true);
        info.setLocation(location);
        if (this.project.getProjectElement().hasAttributeValue("projectnumber") && (idx = (projectNumber = this.project.getProjectElement().getAttributeValue("projectnumber")).lastIndexOf("-")) > 0 && idx < projectNumber.length() - 1) {
            info.setStair(projectNumber.substring(idx + 1));
        }
        FloorInfo floorinfo = new FloorInfo();
        id = loc.getKeyAttribute("list2").getId();
        term = loc.getKeyAttribute("list2").getValue();
        boolean bl = floorRequired = !this.sapMapping.containsKey("nofloor." + ortterm.toLowerCase());
        if (floorRequired) {
            if (term == null || "".equals(term)) {
                this.errors.add("Gegenstand '" + loc.getTitle() + "': Es ist kein Stockwerk definiert");
                return null;
            }
            String floor = Util.expandString((String)this.sapMapping.getProperty("stockwerk." + term.toLowerCase(), "59"), (String)"0", (int)5, (boolean)true);
            floorinfo.setFloor(floor);
            info.setFloorInfo(floorinfo);
        }
        result.setLocationInfo(info);
        StringBuilder sb = new StringBuilder();
        sb.append(observation.getAttributeValue("description"));
        if (observation.hasAttributeValue("topic")) {
            sb.append("\nAbteilung: " + observation.getAttributeValue("topic"));
        }
        if (observation.hasAttributeValue("freetext1")) {
            sb.append("\nGewerk: " + observation.getAttributeValue("freetext1"));
        }
        if (observation.hasAttributeValue("quantity")) {
            sb.append("\nMenge: " + observation.getAttributeValue("quantity"));
        }
        if (loc.hasAttributeValue("code2")) {
            sb.append("\nAngabe zum Ort: " + loc.getAttributeValue("code2"));
        }
        result.setNotes(sb.toString());
        return result;
    }

    private Attachments createAttachment() throws DatatypeConfigurationException {
        Attachments result = new Attachments();
        try {
            CmsReport rep = new CmsReport();
            rep.exportImages = CmsReport.ImageIntegration.ALL;
            rep.event = this.event;
            WienerWohnenPdfExporter pdf = new WienerWohnenPdfExporter(rep, true);
            pdf.setIncludeOpenTasks(false);
            pdf.setObservations(this.observationIds);
            File folder = this.project.getTempfileLocation();
            String filename = this.event.getAttributeValue("title") + "_" + Util.formatDate((Date)this.event.getDateAttribute("date").getDate(), (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone());
            this.fBefund = new File(folder, filename + ".pdf");
            pdf.exportToPdf(this.fBefund, rep, this.project.getUser());
            File fld = new File(this.project.getProjectFolder(), "soap");
            if (this.app.isDebugMode()) {
                fld.mkdirs();
                Util.copy((File)this.fBefund, (File)fld);
            }
            byte[] encodedBytes = Files.readAllBytes(this.fBefund.toPath());
            result.setBase64Content(encodedBytes);
            result.setMimeType("application/pdf");
            result.setName(filename);
            result.setType("main");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public CreateReportResponse sendReport(CreateReportRequest request, ProgressHandler ph) throws SOAPException, JAXBException {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        this.logger.fine("sending request: " + request.toString());
        ph.progress("SOAP Nachricht wird erstellt ...");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage msg = factory.createMessage();
        SOAPPart soapPart = msg.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CreateReportRequest.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        jaxbMarshaller.marshal((Object)request, (Node)soapBody);
        msg.saveChanges();
        File fld = new File(this.project.getProjectFolder(), "soap");
        File fSoapMessage = new File(fld, "soapmsg_" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone()) + "_" + request.getReportHeader().getCommunicationGUID() + ".xml");
        File fSoapResponse = new File(fld, "soapmsg_" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone()) + "_" + request.getReportHeader().getCommunicationGUID() + "_response.xml");
        if (this.app.isDebugMode()) {
            ph.progress("SOAP Datei wird gespeichert ...");
            fld.mkdirs();
            try {
                FileOutputStream fos = new FileOutputStream(fSoapMessage);
                msg.writeTo((OutputStream)fos);
                fos.close();
            }
            catch (IOException ex) {
                throw new SOAPException("unable to write file: " + ex.toString());
            }
        }
        ph.progress("Daten werden \u00fcbertragen ...");
        SOAPConnectionFactory myFct = SOAPConnectionFactory.newInstance();
        SOAPConnection myCon = myFct.createConnection();
        SOAPMessage reply = myCon.call(msg, (Object)this.endpoint);
        SOAPBody replyBody = reply.getSOAPBody();
        if (this.app.isDebugMode()) {
            try {
                ph.progress("Server Antwort wird gespeichert ...");
                FileOutputStream fos = new FileOutputStream(fSoapResponse);
                reply.writeTo((OutputStream)fos);
                fos.close();
            }
            catch (IOException ex) {
                throw new SOAPException("unable to write file: " + ex.toString());
            }
        }
        CreateReportResponse response = null;
        if (replyBody.hasFault()) {
            String error = "Der Server meldet folgenden Fehler:\n";
            error = error + replyBody.toString() + "\n";
            error = error + replyBody.getFault().toString() + "\n";
            error = error + "Inhalt der Server-Antwort:\n";
            try {
                error = error + WienerWohnenSoapClient.documenetToString(replyBody.extractContentAsDocument());
            }
            catch (IOException ex) {
                error = error + "IO-Fehler: " + ex.getMessage();
            }
            catch (TransformerException ex) {
                error = error + "Transform-Fehler: " + ex.getMessage();
            }
            this.app.getDialog().showInfoMessageDialog(error, "Fehler bei der Daten\u00fcbertragung");
            this.project.getLogger().severe("SOAP ERROR after transfer" + error);
        } else {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CreateReportResponse.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            response = (CreateReportResponse)unmarshaller.unmarshal(reply.getSOAPBody().getFirstChild());
            this.logger.fine("received response: " + response.toString());
        }
        return response;
    }

    public File getBefundFile() {
        return this.fBefund;
    }

    public static String documenetToString(Document doc) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }
}

