/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw;

import at.grid.cms.content.Keytable;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.template.TemplateManager;
import at.grid.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.netbeans.api.progress.ProgressHandle;

public class WienerWohnenUpdater {
    public static void updateProject(ThemisProject project, File f, boolean doAsk, ProgressHandle ph) {
        try {
            ThemisApplication app = ThemisApplication.getInstance();
            if (!project.isOpen()) {
                if (doAsk) {
                    app.getDialog().showErrorDialog("Es ist kein Projekt ge\u00f6ffnet.");
                }
                return;
            }
            if (!f.isFile()) {
                if (doAsk) {
                    app.getDialog().showErrorDialog("Die Datei '" + f.getAbsolutePath() + "' existiert nicht!");
                }
                return;
            }
            int ver = Util.parseInt((String)project.getProjectProperty("wienerwohnen_version", "0"), (int)0);
            int result = -1;
            switch (ver) {
                case 0: {
                    for (String sql : new String[]{"UPDATE tdtaelelocation SET description = description || char(13) WHERE description IS NOT null AND description != ''", "UPDATE tdtaelelocation AS E set description = E.description || 'Hersteller: ' || E.text3 || char(13) || 'Menge: ' || E.text4 || char(13) || 'Mittel: ' || (select L.list3term FROM tkeyList3Lng AS L WHERE L.idList3=E.idList3) WHERE E.text3 IS NOT null AND E.text3 != ''", "UPDATE tdtaelelocation AS E set description = E.description || 'Brandmelder: ' || (select L.list4term FROM tkeyList4Lng AS L WHERE L.idList4=E.idList4) WHERE E.idList4>=0"}) {
                        result = project.getDatastorage().executeUpdate(sql, true);
                        project.getLogger().info("Update project -> " + result + " ... using SQL: " + sql);
                    }
                    ++ver;
                }
            }
            project.setProjectProperty("wienerwohnen_version", Integer.toString(ver));
            app.getSettings().setTemplateUseTexts(true);
            app.getSettings().setTemplateUseLists(true);
            app.getSettings().setTemplateUseIcons(true);
            app.getSettings().setTemplateUseSettings(true);
            app.getSettings().setTemplateUseContacts(true);
            app.getSettings().setTemplateUseDocuments(true);
            app.getSettings().setTemplateDeleteMissingItems(true);
            app.getSettings().setTemplateAutoUpdate(false);
            app.getSettings().setTemplateMatchByTitle(true);
            TemplateManager tm = new TemplateManager(app, project);
            boolean success = tm.loadTemplatesFromXls(null, null, f);
            if (success) {
                Properties tmresult = tm.getLoadResult();
                StringBuilder sb = new StringBuilder();
                sb.append("Neue Vorlagen: " + tmresult.getProperty("text.new", "-")).append("\n");
                sb.append("Modifizierte Vorlagen: " + tmresult.getProperty("text.modified", "-")).append("\n");
                sb.append("Zu l\u00f6schende Vorlagen: " + tmresult.getProperty("text.missing", "-")).append("\n");
                sb.append("\nSollen obsoleten Vorlagen gel\u00f6scht werden?");
                if (!doAsk || app.getDialog().showConfirmDialog(sb.toString())) {
                    project.getDatastorage().setElementTrash(tm.getMissingTemplateIds(), true);
                }
            } else if (doAsk) {
                app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage");
            }
            Keytable keytable = project.getKeytable("list1");
            long idPruefen = keytable.createNewId();
            keytable.addTerm(idPruefen, "de", "PR\u00dcFEN");
            keytable.save();
            List recs = project.getDatastorage().executeQuery("SELECT idList1 AS id, list1Term AS term FROM tkeyList1Lng", true).getResult();
            HashMap<String, Long> mappingTermId = new HashMap<String, Long>();
            for (DataRecord rec : recs) {
                mappingTermId.put(rec.get("term"), rec.getLong("id"));
            }
            HashMap<String, String> mapping = new HashMap<String, String>();
            mapping.put("Stiegeneingang", "Stiegenhaus");
            mapping.put("Hobbyrau", "Gemeinschaftsraum");
            mapping.put("Hobbyraum", "Gemeinschaftsraum");
            mapping.put("Hauseingang", "Stiegenhaus");
            mapping.put("Zutritt", "PR\u00dcFEN");
            mapping.put("Hauptabsperreinrichtung Gas", "PR\u00dcFEN");
            mapping.put("Hauptabsperreinrichtung Strom", "PR\u00dcFEN");
            mapping.put("Hauptabsperreinrichtung Wasser", "PR\u00dcFEN");
            mapping.put("Brandschutzplan", "PR\u00dcFEN");
            mapping.put("Verhalten im Brandfall", "PR\u00dcFEN");
            mapping.put("Kontrolle der periodischen \u00dcberpr\u00fcfungen", "PR\u00dcFEN");
            mapping.put("Alarmorganisation", "PR\u00dcFEN");
            mapping.put("Gang", "Stiegenhaus");
            mapping.put("Abstellraum/Fahradraum", "Fahrradabstellraum");
            mapping.put("Fahrradraum", "Fahrradabstellraum");
            mapping.put("Kinderwagenraum/ Fahrradraum", "Kinderwagenraum");
            mapping.put("Hobbyraum", "Gemeinschaftsraum");
            mapping.put("Z\u00e4hlerkasten", "Z\u00e4hlernische");
            mapping.put("ZK 1", "Z\u00e4hlernische");
            mapping.put("ZK 2", "Z\u00e4hlernische");
            mapping.put("ZK 3", "Z\u00e4hlernische");
            mapping.put("ZK 4", "Z\u00e4hlernische");
            mapping.put("ZK 5", "Z\u00e4hlernische");
            mapping.put("ZK 6", "Z\u00e4hlernische");
            mapping.put("ZK 7", "Z\u00e4hlernische");
            mapping.put("ZK 8", "Z\u00e4hlernische");
            mapping.put("ZK 9", "Z\u00e4hlernische");
            mapping.put("ZK 10", "Z\u00e4hlernische");
            mapping.put("ZK 11", "Z\u00e4hlernische");
            mapping.put("ZK 12", "Z\u00e4hlernische");
            mapping.put("ZK 13", "Z\u00e4hlernische");
            mapping.put("ZK 14", "Z\u00e4hlernische");
            mapping.put("ZK 15", "Z\u00e4hlernische");
            mapping.put("ZK 16", "Z\u00e4hlernische");
            mapping.put("ZK 17", "Z\u00e4hlernische");
            mapping.put("ZK 18", "Z\u00e4hlernische");
            mapping.put("ZK 19", "Z\u00e4hlernische");
            mapping.put("Stiegenhauseingang", "Stiegenhaus");
            mapping.put("Fahrrad,-Kinderwagenraum", "Fahrradraum");
            mapping.put("Au\u00dfenbereich", "Fassade");
            mapping.put("K1", "Keller");
            mapping.put("K2", "Keller");
            mapping.put("K3", "Keller");
            mapping.put("K4", "Keller");
            mapping.put("Technikraum", "PR\u00dcFEN");
            mapping.put("D1", "Dachboden");
            mapping.put("D2", "Dachboden");
            mapping.put("D3", "Dachboden");
            mapping.put("Gesamtgeb\u00e4ude", "Stiegenhaus");
            ArrayList<String> validEntries = new ArrayList<String>();
            validEntries.add("Keller");
            validEntries.add("Dachboden");
            validEntries.add("Stiegenhaus");
            validEntries.add("M\u00fcllraum");
            validEntries.add("Waschk\u00fcche");
            validEntries.add("Kinderwagenraum");
            validEntries.add("Heizraum");
            validEntries.add("Flachdach");
            validEntries.add("Abstellraum");
            validEntries.add("Installationsschacht,-keller");
            validEntries.add("Garage");
            validEntries.add("Fahrradabstellraum");
            validEntries.add("Absperreinrichtungsraum");
            validEntries.add("Gr\u00fcnfl\u00e4che");
            validEntries.add("befestigte Fl\u00e4che");
            validEntries.add("Fassade");
            validEntries.add("Z\u00e4hlernische");
            validEntries.add("Triebwerksraum");
            validEntries.add("Installationsschacht");
            validEntries.add("Zentralwaschk\u00fcche");
            validEntries.add("Gemeinschaftsraum");
            validEntries.add("Notfallstiegenhaus");
            validEntries.add("Kellergang");
            validEntries.add("Schachtumwehrung");
            validEntries.add("Stahl-Glas-Aufzugsturm");
            validEntries.add("Schachtt\u00fcre");
            for (String k : mappingTermId.keySet()) {
                if (validEntries.contains(k)) continue;
                String k2 = (String)mapping.get(k);
                Long id1 = (Long)mappingTermId.get(k);
                Long id2 = null;
                if (k2 != null) {
                    id2 = (Long)mappingTermId.get(k2);
                }
                if (id2 == null) {
                    id2 = idPruefen;
                }
                project.getLogger().info("Update project -> " + result + " location items updated from '" + k + "' (" + id1 + ") to '" + (k2 == null ? "Pr\u00fcfen" : k2) + "' (" + id2 + ")");
                result = project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation set idList1=" + id2 + " WHERE idList1=" + id1, true);
                if (id1 == idPruefen) continue;
                result = project.getDatastorage().executeUpdate("DELETE FROM tkeyList1 WHERE idList1=" + id1, true);
                project.getLogger().info("Update project -> '" + k + "' " + (result > 0 ? "" : "NOT ") + "deleted");
            }
            keytable.load();
            long idFassade = mappingTermId.getOrDefault("Fassade", -1L);
            if (idFassade >= 0L) {
                int count = project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET idList1=" + idFassade + " WHERE titel ILIKE 'Hauseingang%'", true);
                boolean id1 = false;
            }
            keytable = project.getKeytable("list2");
            idPruefen = keytable.createNewId();
            keytable.addTerm(idPruefen, "de", "PR\u00dcFEN");
            keytable.save();
            recs = project.getDatastorage().executeQuery("SELECT idList2 AS id, list2Term AS term FROM tkeyList2Lng", true).getResult();
            mappingTermId.clear();
            for (DataRecord rec : recs) {
                mappingTermId.put(rec.get("term"), rec.getLong("id"));
            }
            mapping.clear();
            mapping.put("Gesamtgeb\u00e4ude", "Erdgeschoss");
            mapping.put("Erdgescho\u00df", "Erdgeschoss");
            mapping.put("Sockelgescho\u00df", "PR\u00dcFEN");
            mapping.put("Zwischengescho\u00df", "PR\u00dcFEN");
            mapping.put("1 / EG", "EG/1");
            mapping.put("1. OG", "1");
            mapping.put("2 / 1 ZG", "1/2");
            mapping.put("2. OG", "2");
            mapping.put("3 / 2 ZG", "2/3");
            mapping.put("3. OG", "3");
            mapping.put("4 / 3 ZG", "3/4");
            mapping.put("4. OG", "4");
            mapping.put("5 / 4 ZG", "4/5");
            mapping.put("5. OG", "5");
            mapping.put("6 / 5 ZG", "5/6");
            mapping.put("6. OG", "6");
            mapping.put("7 / 6 ZG", "6/7");
            mapping.put("7. OG", "7");
            mapping.put("8 / 7 ZG", "7/8");
            mapping.put("8. OG", "8");
            mapping.put("9 / 8 ZG", "9");
            mapping.put("9. OG", "9");
            mapping.put("10 / 9 ZG", "10");
            mapping.put("10. OG", "10");
            mapping.put("11 / 10 ZG", "11");
            mapping.put("11. OG", "11");
            mapping.put("12 / 11 ZG", "12");
            mapping.put("12. OG", "12");
            mapping.put("13 / 12 ZG", "13");
            mapping.put("13. OG", "13");
            mapping.put("14 / 13 ZG", "14");
            mapping.put("14. OG", "14");
            mapping.put("15 / 14 ZG", "15");
            mapping.put("15. OG", "15");
            mapping.put("16 / 15 ZG", "16");
            mapping.put("16. OG", "16");
            mapping.put("17 / 16 ZG", "17");
            mapping.put("17. OG", "17");
            mapping.put("18 / 17 ZG", "18");
            mapping.put("18. OG", "18");
            mapping.put("19 / 18 ZG", "19");
            mapping.put("19. OG", "19");
            mapping.put("20 / 19 ZG", "20");
            mapping.put("20. OG", "20");
            mapping.put("21 / 20 ZG", "21");
            mapping.put("21. OG", "21");
            mapping.put("22 / 21 ZG", "22");
            mapping.put("22. OG", "22");
            mapping.put("23 / 22 ZG", "PR\u00dcFEN");
            mapping.put("23. OG", "PR\u00dcFEN");
            mapping.put("KG 1", "-1");
            mapping.put("KG 2", "-2");
            mapping.put("KG 3", "-2");
            mapping.put("DG", "Dachgeschoss");
            mapping.put("DG 1", "Dachgeschoss");
            mapping.put("DG 2", "Dachgeschoss");
            mapping.put("DG 3", "Dachgeschoss");
            mapping.put("EG / KG", "Erdgeschoss");
            mapping.put("KG", "-1");
            validEntries.clear();
            validEntries.add("Erdgeschoss");
            validEntries.add("Hochparterre");
            validEntries.add("Dachgeschoss");
            validEntries.add("-2");
            validEntries.add("-1");
            validEntries.add("0");
            validEntries.add("1");
            validEntries.add("1/2");
            validEntries.add("2");
            validEntries.add("2/3");
            validEntries.add("3");
            validEntries.add("3/4");
            validEntries.add("4");
            validEntries.add("4/5");
            validEntries.add("5");
            validEntries.add("5/6");
            validEntries.add("6");
            validEntries.add("6/7");
            validEntries.add("7");
            validEntries.add("7/8");
            validEntries.add("8");
            validEntries.add("9");
            validEntries.add("10");
            validEntries.add("11");
            validEntries.add("12");
            validEntries.add("13");
            validEntries.add("14");
            validEntries.add("15");
            validEntries.add("16");
            validEntries.add("17");
            validEntries.add("18");
            validEntries.add("19");
            validEntries.add("20");
            validEntries.add("21");
            validEntries.add("22");
            validEntries.add("23");
            validEntries.add("Mezzanin");
            for (String k : mappingTermId.keySet()) {
                if (validEntries.contains(k)) continue;
                String k2 = (String)mapping.get(k);
                Long id1 = (Long)mappingTermId.get(k);
                Long id2 = null;
                if (k2 != null) {
                    id2 = (Long)mappingTermId.get(k2);
                }
                if (id2 == null) {
                    id2 = idPruefen;
                }
                project.getLogger().info("Update project -> " + result + " location items updated from '" + k + "' (" + id1 + ") to '" + k2 + "' (" + id2 + ")");
                result = project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation set idList2=" + id2 + " WHERE idList2=" + id1, true);
                result = project.getDatastorage().executeUpdate("DELETE FROM tkeyList2 WHERE idList2=" + id1, true);
                project.getLogger().info("Update project -> '" + k + "' " + (result > 0 ? "" : "NOT ") + "deleted");
            }
            keytable.load();
            long idFrist3Monate = -1L;
            keytable = project.getKeytable("observationtype");
            validEntries.clear();
            validEntries.add("Sofort");
            validEntries.add("3 Monate");
            validEntries.add("6 Monate");
            validEntries.add("9 Monate");
            validEntries.add("12 Monate");
            validEntries.add("Information");
            validEntries.add("Durch HAB behoben");
            validEntries.add("sofort behoben");
            recs = project.getDatastorage().executeQuery("SELECT idObservationtype AS id, ObservationtypeTerm AS term FROM tkeyObservationtypeLng", true).getResult();
            mappingTermId.clear();
            for (DataRecord rec : recs) {
                mappingTermId.put(rec.get("term"), rec.getLong("id"));
                if (!"3 Monate".equals(rec.get("term"))) continue;
                idFrist3Monate = rec.getLong("id");
            }
            for (String k : mappingTermId.keySet()) {
                if (validEntries.contains(k)) continue;
                result = project.getDatastorage().executeUpdate("DELETE FROM tkeyObservationtype WHERE idObservationtype=" + mappingTermId.get(k), true);
            }
            if (idFrist3Monate >= 0L) {
                result = project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET idObservationtype=" + idFrist3Monate + " WHERE idtype IN (1,4) ", true);
            }
            keytable.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

