/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw.data;

import at.grid.themis.special.wrw.data.AdditionalReferenceInfo;
import at.grid.themis.special.wrw.data.AddressInfo;
import at.grid.themis.special.wrw.data.Attachments;
import at.grid.themis.special.wrw.data.FloorInfo;
import at.grid.themis.special.wrw.data.ReportHeader;
import at.grid.themis.special.wrw.data.ReportPositions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CreateReportRequest", propOrder={"reportHeader", "reportPositions", "attachments"})
@XmlRootElement(name="CreateReportRequest", namespace="http://www.wien.gv.at/befundung")
public class CreateReportRequest {
    @XmlElement(name="ReportHeader", required=true)
    protected ReportHeader reportHeader;
    @XmlElement(name="ReportPositions", required=true)
    protected List<ReportPositions> reportPositions;
    @XmlElement(name="Attachments")
    protected List<Attachments> attachments;

    public void setReportPositions(List<ReportPositions> positions) {
        this.reportPositions = positions;
    }

    public List<ReportPositions> getReportPositions() {
        return this.reportPositions;
    }

    public void addReportPosition(ReportPositions pos) {
        if (this.reportPositions == null) {
            this.reportPositions = new ArrayList<ReportPositions>();
        }
        this.reportPositions.add(pos);
    }

    public void setAttachments(List<Attachments> attachements) {
        this.attachments = attachements;
    }

    public List<Attachments> getAttchements() {
        return this.attachments;
    }

    public void addAttachment(Attachments att) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachments>();
        }
        this.attachments.add(att);
    }

    public ReportHeader getReportHeader() {
        return this.reportHeader;
    }

    public void setReportHeader(ReportHeader value) {
        this.reportHeader = value;
    }

    public String toString() {
        String string = "CreateReportRequest { ";
        string = string + "ReportHeader { ";
        string = string + "CommunicationGUID: " + this.reportHeader.getCommunicationGUID();
        string = string + ", ";
        string = string + "OTFUUser: " + this.reportHeader.getOTFUUser();
        string = string + ", ";
        if (null != this.reportHeader.getReportingDate()) {
            string = string + "ReportingDate: " + this.reportHeader.getReportingDate().toString();
            string = string + ", ";
        }
        string = string + "PONumber: " + this.reportHeader.getPONumber();
        string = string + ", ";
        string = string + "Stiege: " + this.reportHeader.getStiege();
        string = string + ", ";
        string = string + "ReportStatus: " + this.reportHeader.getReportStatus();
        string = string + ", ";
        if (null != this.reportHeader.getNextDueDate()) {
            string = string + "NextDueDate: " + this.reportHeader.getNextDueDate().toString();
            string = string + ", ";
        }
        string = string + "ExternalRefID: " + this.reportHeader.getExternalRefID();
        string = string + ", ";
        string = string + "ObjectType: " + this.reportHeader.getObjectType();
        string = string + ", ";
        if (null != this.reportHeader.getAdditionalReferenceInfo()) {
            AdditionalReferenceInfo info = this.reportHeader.getAdditionalReferenceInfo();
            string = string + "AdditionalReferenceInfo { ";
            string = string + "AccountingEntity: " + info.getAccountingEntity();
            string = string + ", ";
            string = string + "RentalObject: " + info.getRentalObject();
            string = string + " } ";
        } else {
            string = string + "AdditionalReferenceInfo: null";
        }
        string = string + " } ";
        if (this.reportPositions != null) {
            for (ReportPositions pos : this.reportPositions) {
                string = string + ", ";
                string = string + "ReportPosition { ";
                string = string + "PositionID: " + pos.getPositionID();
                string = string + ", ";
                string = string + "ExternalRefPosID: " + pos.getExternalRefPosID();
                string = string + ", ";
                string = string + "FaultMainGroup: " + pos.getFaultMainGroup();
                string = string + ", ";
                string = string + "FaultGroup: " + pos.getFaultGroup();
                string = string + ", ";
                string = string + "FaultType: " + pos.getFaultType();
                string = string + ", ";
                string = string + "RiskClass: " + pos.getRiskClass();
                string = string + ", ";
                string = string + "RepairPeriod: " + pos.getRepairPeriod();
                string = string + ", ";
                if (null != pos.getLocationInfo()) {
                    AddressInfo info = pos.getLocationInfo();
                    string = string + "LocationInfo { ";
                    string = string + "Location: " + info.getLocation();
                    string = string + ", ";
                    string = string + "Stair: " + info.getStair();
                    string = string + ", ";
                    if (null != info.getFloorInfo()) {
                        FloorInfo floor = info.getFloorInfo();
                        string = string + "FloorInfo { ";
                        string = string + "Floor: " + floor.getFloor();
                        string = string + ", ";
                        string = string + "SpecialFloor: " + floor.getSpecialFloor();
                        string = string + " } ";
                    } else {
                        string = string + "FloorInfo: null";
                    }
                    string = string + " } ";
                } else {
                    string = string + "LocationInfo: null";
                }
                string = string + ", ";
                string = string + "Notes: " + pos.getNotes();
                string = string + " } ";
            }
        }
        if (this.attachments != null) {
            for (Attachments att : this.attachments) {
                string = string + ", ";
                string = string + "Attachments { ";
                string = string + "Base64Content: " + Arrays.toString(att.getBase64Content());
                string = string + ", ";
                string = string + "MimeType: " + att.getMimeType();
                string = string + ", ";
                string = string + "Name: " + att.getName();
                string = string + " } ";
            }
        }
        string = string + " }";
        return string;
    }
}

