/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.wrw.data;

import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;

public class SoapObservationObject {
    private boolean transfered;
    private String title;
    private String number;
    private String description;
    private long observationId;

    public static SoapObservationObject fromObservation(CmsObservation observation) {
        SoapObservationObject result = new SoapObservationObject();
        result.setTransfered(false);
        result.setTitle(observation.getTitle());
        CmsLocation location = observation.getLocation();
        result.setNumber(location.getAttributeValue("number") + "." + observation.getAttributeValue("number"));
        result.setDescription(observation.getSummary());
        result.setObservationId(observation.getId());
        return result;
    }

    public static SoapObservationObject fromRecord(DataRecord rec) {
        SoapObservationObject result = new SoapObservationObject();
        result.setTransfered(false);
        result.setTitle(rec.getString("observationtitle"));
        result.setNumber(rec.getString("fullnumber"));
        result.setDescription(rec.getString("observationdescription"));
        result.setObservationId(rec.getLong("observationid"));
        return result;
    }

    public boolean isTransfered() {
        return this.transfered;
    }

    public void setTransfered(boolean transfered) {
        this.transfered = transfered;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getObservationId() {
        return this.observationId;
    }

    public void setObservationId(long observationId) {
        this.observationId = observationId;
    }
}

