/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.beans;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class DateUtils {
    public static boolean debug;
    protected static String reISO8601;

    static {
        reISO8601 = "(\\d\\d\\d\\d)(-(\\d\\d)(-(\\d\\d))?)?([T| ]?(\\d\\d):(\\d\\d)(:((\\d\\d)(\\.(\\d+))?)?)?(Z|([+-]\\d\\d:\\d\\d)|([A-Z]{3}))?)?";
    }

    public static void main(String[] args) {
        debug = true;
        int i = 0;
        while (i < args.length) {
            System.out.println(DateUtils.parseDate(args[i]));
            ++i;
        }
    }

    public static Date parseDate(String s) {
        Date date = null;
        try {
            date = new Date(s);
            return date;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                date = DateFormat.getDateInstance().parse(s);
                return date;
            }
            catch (ParseException parseException) {
                try {
                    long secs = Long.parseLong(s);
                    date = new Date(s);
                    return date;
                }
                catch (NumberFormatException numberFormatException) {
                    ISO8601 iso = DateUtils.parseISO8601(s);
                    if (iso != null) {
                        TimeZone tz = null;
                        Calendar cal = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
                        cal.set(1, iso.year);
                        cal.set(2, iso.month - 1);
                        cal.set(5, iso.day);
                        cal.set(10, iso.hour + 12);
                        cal.set(12, iso.min);
                        cal.set(13, iso.sec);
                        return cal.getTime();
                    }
                    return null;
                }
            }
        }
    }

    public static ISO8601 parseISO8601(String s) {
        try {
            RE re = new RE(reISO8601);
            if (re.match(s)) {
                if (debug) {
                    DateUtils.showParens(re);
                }
                ISO8601 iso = new ISO8601();
                iso.year = DateUtils.toInt(re.getParen(1));
                iso.month = DateUtils.toInt(re.getParen(3));
                iso.day = DateUtils.toInt(re.getParen(5));
                iso.hour = DateUtils.toInt(re.getParen(7));
                iso.min = DateUtils.toInt(re.getParen(8));
                iso.sec = DateUtils.toInt(re.getParen(11));
                iso.frac = DateUtils.toInt(re.getParen(13));
                iso.tz = re.getParen(14);
                if (debug) {
                    System.out.println("year='" + iso.year + "'");
                    System.out.println("month='" + iso.month + "'");
                    System.out.println("day='" + iso.day + "'");
                    System.out.println("hour='" + iso.hour + "'");
                    System.out.println("min='" + iso.min + "'");
                    System.out.println("sec='" + iso.sec + "'");
                    System.out.println("frac='" + iso.frac + "'");
                    System.out.println("tz='" + iso.tz + "'");
                }
                return iso;
            }
        }
        catch (RESyntaxException ree) {
            ree.printStackTrace();
        }
        return null;
    }

    static void showParens(RE r) {
        int i = 0;
        while (i < r.getParenCount()) {
            System.out.println("$" + i + " = " + r.getParen(i));
            ++i;
        }
    }

    public static int toInt(String x) {
        if (x == null) {
            return 0;
        }
        try {
            return Integer.parseInt(x);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static class ISO8601 {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int min;
        public int sec;
        public int frac;
        public String tz;
    }
}

