/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.beans;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class JDOMBean {
    private static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    private String parser;
    private SAXBuilder builder;
    private Map files = new HashMap();
    private File fileRoot;

    public JDOMBean() {
        this.setParser(DEFAULT_PARSER);
    }

    public JDOMBean(String parser) {
        this.setParser(parser);
    }

    public Document getDocument(String filename) throws JDOMException, IOException {
        FileInfo info = (FileInfo)this.files.get(filename);
        File file = this.getFile(filename);
        if (info == null || info.modified < file.lastModified()) {
            Document doc = this.builder.build(file);
            info = new FileInfo(filename, file.lastModified(), doc);
            this.files.put(filename, info);
        }
        return info.document;
    }

    private File getFile(String filename) {
        if (this.fileRoot == null) {
            return new File(filename);
        }
        return new File(this.fileRoot, filename);
    }

    public String getFileRoot() {
        if (this.fileRoot == null) {
            return null;
        }
        return this.fileRoot.getAbsolutePath();
    }

    public String getParser() {
        return this.parser;
    }

    public Element getRootElement(String file) throws JDOMException, IOException {
        Document doc = this.getDocument(file);
        if (doc != null) {
            return doc.getRootElement();
        }
        return null;
    }

    public static void main(String[] args) throws IOException, JDOMException {
        JDOMBean bean;
        int i = 0;
        if (args[i].equals("-parser")) {
            bean = new JDOMBean(args[++i]);
            ++i;
        } else {
            bean = new JDOMBean();
        }
        XMLOutputter out = new XMLOutputter();
        while (i < args.length) {
            Document doc = bean.getDocument(args[i]);
            out.output(doc, (OutputStream)System.out);
            System.out.println();
            ++i;
        }
    }

    public void setFileRoot(String root) {
        if (!root.endsWith("/")) {
            root = String.valueOf(root) + "/";
        }
        this.fileRoot = new File(root);
        System.out.println("fileroot=" + this.fileRoot);
    }

    public void setParser(String parser) {
        this.parser = parser;
        this.builder = new SAXBuilder(parser);
    }

    class FileInfo {
        String name;
        long modified;
        Document document;

        public FileInfo(String name, long modified, Document document) {
            this.name = name;
            this.modified = modified;
            this.document = document;
        }
    }
}

