/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.beans;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import org.jdom.Document;
import org.jdom.contrib.beans.BeanMapper;
import org.jdom.contrib.beans.BeanMapperException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TestBean
implements Serializable {
    private String name;
    private int age;
    private Date birthdate;
    private TestBean friend;

    public int getAge() {
        return this.age;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public TestBean getFriend() {
        return this.friend;
    }

    public String getName() {
        return this.name;
    }

    public static void main(String[] args) throws IntrospectionException, IOException {
        try {
            BeanMapper mapper = new BeanMapper();
            mapper.addMapping("birthdate", "dob");
            mapper.addMapping("age", "dob", "age");
            mapper.setBeanPackage("org.jdom.contrib.beans");
            TestBean alex = new TestBean();
            alex.setName("Alex");
            alex.setAge(31);
            alex.setBirthdate(new Date(69, 7, 8));
            TestBean amy = new TestBean();
            amy.setName("Amy");
            amy.setAge(25);
            amy.setBirthdate(new Date(75, 4, 1));
            alex.setFriend(amy);
            Document doc = mapper.toDocument(alex);
            XMLOutputter o = new XMLOutputter(Format.getPrettyFormat());
            o.output(doc, (OutputStream)System.out);
            System.out.println();
            TestBean test2 = (TestBean)mapper.toBean(doc);
            System.out.println(test2);
        }
        catch (BeanMapperException e) {
            e.printStackTrace();
        }
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public void setFriend(TestBean friend) {
        this.friend = friend;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "TestBean[name='" + this.name + "', age=" + this.age + ", birthdate=" + this.birthdate + ", friend=" + this.friend + "]";
    }
}

