/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.beans;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Document;
import org.jdom.contrib.beans.BeanMapper;
import org.jdom.contrib.beans.BeanMapperException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TestIndexed
implements Serializable {
    private String name;
    private List toppings = new ArrayList();
    private int[] measurements = new int[]{36, 24, 38};

    public int[] getMeasurements() {
        return this.measurements;
    }

    public String getName() {
        return this.name;
    }

    public String[] getTopping() {
        String[] a = new String[this.toppings.size()];
        int i = 0;
        while (i < this.toppings.size()) {
            a[i] = (String)this.toppings.get(i);
            ++i;
        }
        return a;
    }

    public String getTopping(int i) {
        return (String)this.toppings.get(i);
    }

    public static void main(String[] args) throws IntrospectionException, IOException, BeanMapperException {
        BeanMapper mapper = new BeanMapper();
        mapper.setBeanPackage("org.jdom.contrib.beans");
        TestIndexed pizza = new TestIndexed();
        pizza.setName("Abominable");
        pizza.setTopping(0, "Anchovies");
        pizza.setTopping(1, "Steak Tartare");
        pizza.setTopping(2, "Raw Eggs");
        BeanInfo info = Introspector.getBeanInfo(pizza.getClass());
        PropertyDescriptor[] ps = info.getPropertyDescriptors();
        int i = 0;
        while (i < ps.length) {
            if (ps[i] instanceof IndexedPropertyDescriptor) {
                IndexedPropertyDescriptor p = (IndexedPropertyDescriptor)ps[i];
                System.out.println("Indexed property " + p.getName() + " " + p.getShortDescription());
                System.out.println("Type = " + p.getPropertyType());
                System.out.println("Getter = " + p.getReadMethod());
                System.out.println("Indexed Getter = " + p.getIndexedReadMethod());
            }
            ++i;
        }
        System.out.println("===== Testing toDocument()");
        Document doc = mapper.toDocument(pizza);
        XMLOutputter o = new XMLOutputter(Format.getPrettyFormat());
        o.output(doc, (OutputStream)System.out);
        System.out.println();
        System.out.println("===== Testing toBean()");
        TestIndexed test2 = (TestIndexed)mapper.toBean(doc);
        System.out.println(test2);
        int[] test = new int[10];
        Class<?> a1 = test.getClass();
        Class<?> a2 = a1.getSuperclass();
        System.out.println("classes: " + a1 + " " + a2);
    }

    public void setMeasurements(int[] measurements) {
        this.measurements = measurements;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTopping(int i, String topping) {
        while (i >= this.toppings.size()) {
            this.toppings.add(null);
        }
        this.toppings.set(i, topping);
    }

    public void setTopping(String[] x) {
        if (x != null) {
            this.toppings = Arrays.asList(x);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TestIndexed[name='" + this.name + "'");
        int i = 0;
        while (i < this.toppings.size()) {
            buf.append(", topping=" + this.toppings.get(i));
            ++i;
        }
        buf.append(", measurements=");
        int i2 = 0;
        while (i2 < this.toppings.size()) {
            buf.append(" " + this.measurements[i2]);
            ++i2;
        }
        buf.append("]");
        return buf.toString();
    }
}

