/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.helpers;

import org.jdom.Element;
import org.jdom.Namespace;

public class TextHelper {
    public static String getChildText(Element parent, String name) {
        Element child = parent.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public static String getChildText(Element parent, String name, Namespace ns) {
        Element child = parent.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public static String getChildTextNormalize(Element parent, String name) {
        Element child = parent.getChild(name);
        if (child == null) {
            return null;
        }
        return TextHelper.normalize(child.getText());
    }

    public static String getChildTextNormalize(Element parent, String name, Namespace ns) {
        Element child = parent.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return TextHelper.normalize(child.getText());
    }

    public static String getChildTextTrim(Element parent, String name) {
        Element child = parent.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getText().trim();
    }

    public static String getChildTextTrim(Element parent, String name, Namespace ns) {
        Element child = parent.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getText().trim();
    }

    public static String normalize(String text) {
        char[] chars = text.toCharArray();
        char[] newChars = new char[chars.length];
        boolean white = true;
        int pos = 0;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t') {
                if (!white) {
                    newChars[pos++] = 32;
                    white = true;
                }
            } else {
                newChars[pos++] = c;
                white = false;
            }
            ++i;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(newChars, 0, pos);
    }
}

