/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.ids;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.contrib.ids.IdDocument;

public class IdElement
extends Element {
    public IdElement(String name) {
        this(name, (Namespace)null);
    }

    public IdElement(String name, String uri) {
        this(name, Namespace.getNamespace((String)"", (String)uri));
    }

    public IdElement(String name, String prefix, String uri) {
        this(name, Namespace.getNamespace((String)prefix, (String)uri));
    }

    public IdElement(String name, Namespace namespace) {
        super(name, namespace);
    }

    private static void addIdAttributes(Element elt, Map ids) {
        List attrs = elt.getAttributes();
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            if (attr.getAttributeType() != 2) continue;
            ids.put(attr.getValue(), elt);
            break;
        }
    }

    private static Map getIds(Element root, Map ids) {
        IdElement.addIdAttributes(root, ids);
        List children = root.getContent();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Element)) continue;
            IdElement.getIds((Element)o, ids);
        }
        return ids;
    }

    public Element setAttribute(Attribute attribute) {
        Document doc;
        super.setAttribute(attribute);
        if (attribute.getAttributeType() == 2 && (doc = this.getDocument()) instanceof IdDocument) {
            ((IdDocument)doc).addId(attribute.getValue(), this);
        }
        return this;
    }

    protected Element setDocument(Document doc) {
        Document prevDoc = this.getDocument();
        super.setParent((Parent)doc);
        if (doc != prevDoc) {
            this.transferIds(prevDoc, doc);
        }
        return this;
    }

    protected Element setParent(Element parent) {
        Document prevDoc = this.getDocument();
        Document newDoc = parent != null ? parent.getDocument() : null;
        super.setParent((Parent)parent);
        if (newDoc != prevDoc) {
            this.transferIds(prevDoc, newDoc);
        }
        return this;
    }

    private void transferIds(Document prevDoc, Document newDoc) {
        if (prevDoc instanceof IdDocument || newDoc instanceof IdDocument) {
            Iterator i;
            IdDocument idDoc;
            Map ids = IdElement.getIds(this, new HashMap());
            if (prevDoc instanceof IdDocument) {
                idDoc = (IdDocument)prevDoc;
                i = ids.keySet().iterator();
                while (i.hasNext()) {
                    idDoc.removeId(i.next().toString());
                }
            }
            if (newDoc instanceof IdDocument) {
                idDoc = (IdDocument)newDoc;
                i = ids.keySet().iterator();
                while (i.hasNext()) {
                    String key = i.next().toString();
                    idDoc.addId(key, (Element)ids.get(key));
                }
            }
        }
    }
}

