/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.input.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.contrib.input.scanner.ElementListener;
import org.jdom.contrib.input.scanner.XPathMatcher;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ElementScanner
extends XMLFilterImpl {
    private final Collection listeners = new ArrayList();
    private ParserBuilder parserBuilder = new ParserBuilder();
    private SAXHandler saxHandler = null;
    private StringBuffer currentPath = new StringBuffer();
    private Map activeRules = new HashMap();

    public ElementScanner() {
    }

    public ElementScanner(XMLReader parent) {
        super(parent);
    }

    public void addElementListener(ElementListener listener, String pattern) throws JDOMException {
        if (listener == null) {
            throw new JDOMException("Invalid listener object: <null>");
        }
        this.listeners.add(XPathMatcher.newXPathMatcher(pattern, listener));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.characters(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    public void endDocument() throws SAXException {
        this.saxHandler.endDocument();
        super.endDocument();
    }

    public void endElement(String nsUri, String localName, String qName) throws SAXException {
        String eltPath;
        Collection matchingRules;
        Element elt = this.saxHandler.getCurrentElement();
        if (this.activeRules.size() != 0) {
            this.saxHandler.endElement(nsUri, localName, qName);
        }
        if ((matchingRules = (Collection)this.activeRules.remove(eltPath = this.currentPath.substring(0))) != null) {
            try {
                Iterator i = matchingRules.iterator();
                while (i.hasNext()) {
                    XPathMatcher matcher = (XPathMatcher)i.next();
                    if (!matcher.match(eltPath, elt)) continue;
                    matcher.getListener().elementMatched(eltPath, elt);
                }
            }
            catch (JDOMException ex1) {
                throw new SAXException(ex1.getMessage(), (Exception)((Object)ex1));
            }
        }
        this.currentPath.setLength(this.currentPath.length() - (localName.length() + 1));
        super.endElement(nsUri, localName, qName);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.saxHandler.endPrefixMapping(prefix);
        super.endPrefixMapping(prefix);
    }

    private Collection getMatchingRules(String path, Attributes attrs) {
        ArrayList<XPathMatcher> matchingRules = null;
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            XPathMatcher rule = (XPathMatcher)i.next();
            if (!rule.match(path, attrs)) continue;
            if (matchingRules == null) {
                matchingRules = new ArrayList<XPathMatcher>();
            }
            matchingRules.add(rule);
        }
        return matchingRules;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.ignorableWhitespace(ch, start, length);
        }
        super.ignorableWhitespace(ch, start, length);
    }

    public void parse(InputSource source) throws IOException, SAXException {
        this.saxHandler = this.parserBuilder.getContentHandler();
        this.setParent(this.parserBuilder.getXMLReader(this.getParent(), this.saxHandler));
        super.parse(source);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.processingInstruction(target, data);
        }
        super.processingInstruction(target, data);
    }

    public void removeElementListener(ElementListener listener, String pattern) {
        if (listener != null || pattern != null) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                XPathMatcher m = (XPathMatcher)i.next();
                if (!m.getListener().equals(listener) && listener != null || !m.getExpression().equals(pattern) && pattern != null) continue;
                i.remove();
            }
        }
    }

    public void setExpandEntities(boolean expand) {
        this.parserBuilder.setExpandEntities(expand);
    }

    public void setFactory(JDOMFactory factory) {
        this.parserBuilder.setFactory(factory);
    }

    public void setFeature(String name, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.getParent() != null) {
            this.getParent().setFeature(name, state);
        }
        this.parserBuilder.setFeature(name, state);
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.parserBuilder.setIgnoringElementContentWhitespace(ignoringWhite);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.getParent() != null) {
            this.getParent().setProperty(name, value);
        }
        this.parserBuilder.setProperty(name, value);
    }

    public void setValidation(boolean validate) {
        this.parserBuilder.setValidation(validate);
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.skippedEntity(name);
        }
        super.skippedEntity(name);
    }

    public void startDocument() throws SAXException {
        this.currentPath.setLength(0);
        this.activeRules.clear();
        this.saxHandler.startDocument();
        super.startDocument();
    }

    public void startElement(String nsUri, String localName, String qName, Attributes attrs) throws SAXException {
        this.currentPath.append('/').append(localName);
        String eltPath = this.currentPath.substring(0);
        Collection matchingRules = this.getMatchingRules(eltPath, attrs);
        if (matchingRules != null) {
            this.activeRules.put(eltPath, matchingRules);
        }
        if (this.activeRules.size() != 0) {
            this.saxHandler.startElement(nsUri, localName, qName, attrs);
        }
        super.startElement(nsUri, localName, qName, attrs);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.saxHandler.startPrefixMapping(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    private static class ParserBuilder
    extends SAXBuilder {
        protected SAXHandler createContentHandler() {
            return new FragmentHandler(new EmptyDocumentFactory(this.getFactory()));
        }

        public SAXHandler getContentHandler() throws SAXException {
            try {
                SAXHandler handler = this.createContentHandler();
                this.configureContentHandler(handler);
                return handler;
            }
            catch (Exception ex1) {
                throw new SAXException(ex1.getMessage(), ex1);
            }
        }

        public XMLReader getXMLReader(XMLReader parser, SAXHandler handler) throws SAXException {
            try {
                if (parser == null) {
                    parser = this.createParser();
                }
                this.configureParser(parser, handler);
                return parser;
            }
            catch (Exception ex1) {
                throw new SAXException(ex1.getMessage(), ex1);
            }
        }
    }

    private static class FragmentHandler
    extends SAXHandler {
        public FragmentHandler(JDOMFactory factory) {
            super(factory);
            this.pushElement(new Element("root", null, null));
        }
    }

    private static class EmptyDocumentFactory
    implements JDOMFactory {
        private final JDOMFactory wrapped;

        public EmptyDocumentFactory(JDOMFactory factory) {
            this.wrapped = factory != null ? factory : new DefaultJDOMFactory();
        }

        public void addContent(Parent parent, Content c) {
            if (parent instanceof Element) {
                ((Element)parent).addContent(c);
            } else {
                ((Document)parent).addContent(c);
            }
        }

        public void addNamespaceDeclaration(Element element, Namespace additional) {
            element.addNamespaceDeclaration(additional);
        }

        public Attribute attribute(String name, String value) {
            return this.wrapped.attribute(name, value);
        }

        public Attribute attribute(String name, String value, int type) {
            return this.wrapped.attribute(name, value, type);
        }

        public Attribute attribute(String name, String value, int type, Namespace namespace) {
            return this.wrapped.attribute(name, value, type, namespace);
        }

        public Attribute attribute(String name, String value, Namespace namespace) {
            return this.wrapped.attribute(name, value, namespace);
        }

        public CDATA cdata(String text) {
            return this.wrapped.cdata(text);
        }

        public Comment comment(String text) {
            return this.wrapped.comment(text);
        }

        public DocType docType(String elementName) {
            return this.wrapped.docType(elementName);
        }

        public DocType docType(String elementName, String systemID) {
            return this.wrapped.docType(elementName, systemID);
        }

        public DocType docType(String elementName, String publicID, String systemID) {
            return this.wrapped.docType(elementName, publicID, systemID);
        }

        public Document document(Element rootElement) {
            return new EmptyDocument();
        }

        public Document document(Element rootElement, DocType docType) {
            return new EmptyDocument();
        }

        public Document document(Element rootElement, DocType docType, String baseURI) {
            return new EmptyDocument();
        }

        public Element element(String name) {
            return this.wrapped.element(name);
        }

        public Element element(String name, String uri) {
            return this.wrapped.element(name, uri);
        }

        public Element element(String name, String prefix, String uri) {
            return this.wrapped.element(name, prefix, uri);
        }

        public Element element(String name, Namespace namespace) {
            return this.wrapped.element(name, namespace);
        }

        public EntityRef entityRef(String name) {
            return this.wrapped.entityRef(name);
        }

        public EntityRef entityRef(String name, String systemID) {
            return this.wrapped.entityRef(name, systemID);
        }

        public EntityRef entityRef(String name, String publicID, String systemID) {
            return this.wrapped.entityRef(name, publicID, systemID);
        }

        public ProcessingInstruction processingInstruction(String target, String data) {
            return this.wrapped.processingInstruction(target, data);
        }

        public ProcessingInstruction processingInstruction(String target, Map data) {
            return this.wrapped.processingInstruction(target, data);
        }

        public void setAttribute(Element element, Attribute a) {
            element.setAttribute(a);
        }

        public Text text(String text) {
            return this.wrapped.text(text);
        }
    }

    private static class EmptyDocument
    extends Document {
        public Document addContent(Comment comment) {
            return this;
        }

        public Document addContent(ProcessingInstruction pi) {
            return this;
        }

        public Document setContent(List newContent) {
            return this;
        }

        public Document setDocType(DocType docType) {
            return this;
        }

        public Document setRootElement(Element root) {
            return this;
        }
    }
}

