/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.input.scanner;

import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.contrib.input.scanner.ElementListener;
import org.jdom.contrib.input.scanner.XPathMatcher;
import org.jdom.xpath.XPath;
import org.xml.sax.Attributes;

class JakartaRegExpXPathMatcher
extends XPathMatcher {
    private final RE re;
    private final XPath test;

    public JakartaRegExpXPathMatcher(String expression, ElementListener listener) throws JDOMException {
        super(expression, listener);
        try {
            String pathPattern = XPathMatcher.getPathPatternAsRE(expression);
            this.re = new RE(pathPattern);
            String testPattern = XPathMatcher.getTestPattern(expression);
            if (testPattern != null) {
                testPattern = "." + testPattern;
                this.test = XPath.newInstance((String)testPattern);
            } else {
                this.test = null;
            }
            if (XPathMatcher.isDebug()) {
                System.out.println("Listener " + listener + ":");
                System.out.println("   " + expression + " -> RE    = " + pathPattern);
                System.out.println("   " + expression + " -> XPath = " + testPattern);
            }
        }
        catch (RESyntaxException ex1) {
            throw new JDOMException("Illegal XPath expression: " + expression, (Throwable)ex1);
        }
    }

    public boolean match(String path, Element elt) {
        if (this.test != null) {
            boolean match = false;
            try {
                match = this.test.selectNodes((Object)elt).size() != 0;
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            return match;
        }
        return true;
    }

    public boolean match(String path, Attributes attrs) {
        return this.re.match(path);
    }
}

