/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.input.scanner;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.contrib.input.scanner.ElementListener;
import org.xml.sax.Attributes;

public abstract class XPathMatcher {
    private static final String IMPLEMENTATION_CLASS_PROPERTY = "org.jdom.XPathMatcher.class";
    private static final String DEFAULT_IMPLEMENTATION_CLASS = "org.jdom.contrib.input.scanner.JakartaRegExpXPathMatcher";
    private static Constructor constructor = null;
    private static boolean debug = false;
    private final String expression;
    private final ElementListener listener;
    static /* synthetic */ Class class$org$jdom$contrib$input$scanner$XPathMatcher;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jdom$contrib$input$scanner$ElementListener;

    protected XPathMatcher(String expression, ElementListener listener) throws JDOMException {
        if (expression == null || expression.length() == 0) {
            throw new JDOMException("Invalid XPath expression: \"" + expression + "\"");
        }
        if (listener == null) {
            throw new JDOMException("Invalid ElementListener: <null>");
        }
        this.expression = expression;
        this.listener = listener;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public ElementListener getListener() {
        return this.listener;
    }

    protected static String getPathPatternAsRE(String expr) throws JDOMException {
        if (expr == null || expr.length() == 0) {
            expr = "/*";
        }
        String path = expr.endsWith("]") ? expr.substring(0, expr.lastIndexOf(91)) : expr;
        int length = path.length();
        StringBuffer re = new StringBuffer(2 * length);
        int previous = 0;
        int i = 0;
        while (i < length) {
            char current = path.charAt(i);
            if (i == 0) {
                re.append(current == '/' ? (char)'^' : '/');
            }
            if (current == '*') {
                if (previous == 92) {
                    re.setLength(re.length() - 1);
                } else {
                    re.append(".[^/]");
                }
                re.append('*');
            } else if (current == '/' && previous == 47) {
                re.setLength(re.length() - 1);
                re.append("(/.*/|/)");
            } else {
                re.append(current);
            }
            previous = current;
            ++i;
        }
        re.append('$');
        return re.toString();
    }

    protected static String getTestPattern(String expr) throws JDOMException {
        if (expr.endsWith("]")) {
            return expr.substring(expr.lastIndexOf(91));
        }
        return null;
    }

    public static boolean isDebug() {
        return debug;
    }

    public abstract boolean match(String var1, Element var2);

    public abstract boolean match(String var1, Attributes var2);

    public static final XPathMatcher newXPathMatcher(String expression, ElementListener listener) throws JDOMException {
        try {
            if (constructor == null) {
                String className = System.getProperty(IMPLEMENTATION_CLASS_PROPERTY, DEFAULT_IMPLEMENTATION_CLASS);
                XPathMatcher.setXPathMatcherClass(Class.forName(className));
            }
            return (XPathMatcher)constructor.newInstance(expression, listener);
        }
        catch (InvocationTargetException ex1) {
            Throwable te = ex1.getTargetException();
            throw te instanceof JDOMException ? (JDOMException)te : new JDOMException(te.toString(), te);
        }
        catch (Exception ex3) {
            throw new JDOMException(ex3.toString(), (Throwable)ex3);
        }
    }

    public static void setDebug(boolean value) {
        debug = value;
    }

    public static void setXPathMatcherClass(Class aClass) throws IllegalArgumentException, JDOMException {
        if (aClass != null) {
            try {
                if (!(class$org$jdom$contrib$input$scanner$XPathMatcher != null ? class$org$jdom$contrib$input$scanner$XPathMatcher : (class$org$jdom$contrib$input$scanner$XPathMatcher = XPathMatcher.class$("org.jdom.contrib.input.scanner.XPathMatcher"))).isAssignableFrom(aClass) || Modifier.isAbstract(aClass.getModifiers())) {
                    throw new JDOMException(String.valueOf(aClass.getName()) + " is not a concrete XPathMatcher");
                }
                constructor = aClass.getConstructor(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = XPathMatcher.class$("java.lang.String")), class$org$jdom$contrib$input$scanner$ElementListener != null ? class$org$jdom$contrib$input$scanner$ElementListener : (class$org$jdom$contrib$input$scanner$ElementListener = XPathMatcher.class$("org.jdom.contrib.input.scanner.ElementListener")));
            }
            catch (Exception ex1) {
                throw new JDOMException(ex1.toString(), (Throwable)ex1);
            }
        } else {
            throw new IllegalArgumentException("aClass");
        }
    }
}

