/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.schema;

public class ValidationError {
    public static final Severity WARNING = new Severity(0);
    public static final Severity ERROR = new Severity(1);
    public static final Severity FATAL = new Severity(2);
    private final Severity severity;
    private final String message;
    private final Object node;

    public ValidationError(Severity severity, String message) {
        this(severity, message, null);
    }

    public ValidationError(Severity severity, String message, Object node) {
        this.severity = severity;
        this.message = message;
        this.node = node;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getNode() {
        return this.node;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        if (this.severity == WARNING) {
            buf.append("WARNING");
        } else if (this.severity == ERROR) {
            buf.append("ERROR");
        } else if (this.severity == FATAL) {
            buf.append("FATAL");
        }
        buf.append("] message: \"").append(this.getMessage());
        if (this.getNode() != null) {
            buf.append("\", location: \"").append(this.getNode().toString());
        }
        buf.append("\"");
        return buf.toString();
    }

    public static final class Severity {
        private final int level;

        protected Severity(int level) {
            this.level = level;
        }

        public boolean equals(Object o) {
            return o == this || o != null && this.hashCode() == o.hashCode() && this.getClass().getName().equals(o.getClass().getName());
        }

        public int hashCode() {
            return this.level;
        }

        public String toString() {
            return "[" + this.getClass().getName() + "] " + this.level;
        }
    }
}

