/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import jj2000.j2k.entropy.CodedCBlk;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class CBlkRateDistStats
extends CodedCBlk {
    public SubbandAn sb;
    public int nTotTrunc;
    public int nVldTrunc;
    public int[] truncRates;
    public double[] truncDists;
    public float[] truncSlopes;
    public int[] truncIdxs;
    public boolean[] isTermPass;
    public int nROIcoeff = 0;
    public int nROIcp = 0;

    public CBlkRateDistStats() {
    }

    public CBlkRateDistStats(int m, int n, int skipMSBP, byte[] data, int[] rates, double[] dists, boolean[] termp, int np, boolean inclast) {
        super(m, n, skipMSBP, data);
        this.selectConvexHull(rates, dists, termp, np, inclast);
    }

    public void selectConvexHull(int[] rates, double[] dists, boolean[] termp, int n, boolean inclast) {
        int k;
        int p;
        int first_pnt;
        for (first_pnt = 0; first_pnt < n && rates[first_pnt] <= 0; ++first_pnt) {
        }
        int npnt = n - first_pnt;
        float p_slope = 0.0f;
        block1: while (true) {
            p = -1;
            for (k = first_pnt; k < n; ++k) {
                double delta_dist;
                int delta_rate;
                if (rates[k] < 0) continue;
                if (p >= 0) {
                    delta_rate = rates[k] - rates[p];
                    delta_dist = dists[k] - dists[p];
                } else {
                    delta_rate = rates[k];
                    delta_dist = dists[k];
                }
                if (delta_dist < 0.0 || delta_dist == 0.0 && delta_rate > 0) {
                    rates[k] = -rates[k];
                    --npnt;
                    continue;
                }
                float k_slope = (float)(delta_dist / (double)delta_rate);
                if (p >= 0 && (delta_rate <= 0 || k_slope >= p_slope)) {
                    rates[p] = -rates[p];
                    --npnt;
                    continue block1;
                }
                p_slope = k_slope;
                p = k;
            }
            break;
        }
        if (inclast && n > 0 && rates[n - 1] < 0) {
            rates[n - 1] = -rates[n - 1];
            ++npnt;
        }
        this.nTotTrunc = n;
        this.nVldTrunc = npnt;
        this.truncRates = new int[n];
        this.truncDists = new double[n];
        this.truncSlopes = new float[npnt];
        this.truncIdxs = new int[npnt];
        if (termp != null) {
            this.isTermPass = new boolean[n];
            System.arraycopy(termp, 0, this.isTermPass, 0, n);
        } else {
            this.isTermPass = null;
        }
        System.arraycopy(rates, 0, this.truncRates, 0, n);
        p = -1;
        int i = 0;
        for (k = first_pnt; k < n; ++k) {
            if (rates[k] > 0) {
                this.truncDists[k] = dists[k];
                this.truncSlopes[i] = p < 0 ? (float)(dists[k] / (double)rates[k]) : (float)((dists[k] - dists[p]) / (double)(rates[k] - rates[p]));
                this.truncIdxs[i] = k;
                ++i;
                p = k;
                continue;
            }
            this.truncDists[k] = -1.0;
            this.truncRates[k] = -this.truncRates[k];
        }
    }

    public String toString() {
        return super.toString() + "\n nVldTrunc = " + this.nVldTrunc + ", nTotTrunc=" + this.nTotTrunc + ", num. ROI coeff=" + this.nROIcoeff + ", num. ROI coding passes=" + this.nROIcp;
    }
}

