/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.annotations.jmx.JmxManaged;
import de.mhus.lib.core.MCount;
import de.mhus.lib.core.MThread;

@JmxManaged(descrition="Counter with delay")
public class MCountWithDelay
extends MCount {
    private long sleepInterval = 0L;
    private int sleepSeconds = 0;
    private boolean throwExceptionOnNextCount = false;

    public MCountWithDelay() {
    }

    public MCountWithDelay(String name) {
        super(name);
    }

    @JmxManaged(descrition="Get the interval")
    public long getSleepInterval() {
        return this.sleepInterval;
    }

    @JmxManaged(descrition="Set the interval after it will sleeping")
    public void setSleepInterval(long sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    @JmxManaged(descrition="Get the seconds to sleep each interval")
    public int getSleepSeconds() {
        return this.sleepSeconds;
    }

    @JmxManaged(descrition="Set the seconds to sleep each interval")
    public void setSleepSeconds(int sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    @Override
    public void inc() {
        super.inc();
        if (this.throwExceptionOnNextCount) {
            this.throwExceptionOnNextCount = false;
            throw new RuntimeException("Counter " + this.getName() + " is thrown by request at " + this.getValue());
        }
        if (this.isClosed) {
            return;
        }
        if (this.sleepInterval > 0L && this.sleepSeconds > 0 && this.cnt % this.sleepInterval == 0L) {
            this.log().i(this.getName(), "Sleep", this.sleepSeconds);
            MThread.sleep(this.sleepSeconds * 1000);
        }
    }

    @JmxManaged(descrition="Should the counter create and throw a RunntimeException() on next count")
    public boolean isThrowExceptionOnNextCount() {
        return this.throwExceptionOnNextCount;
    }

    @JmxManaged(descrition="Should the counter create and throw a RunntimeException() on next count")
    public void setThrowExceptionOnNextCount(boolean throwExceptionOnNextCount) {
        this.throwExceptionOnNextCount = throwExceptionOnNextCount;
    }
}

