/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.errors.MException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class MFile {
    private static final String DEFAULT_MIME = "plain/text";
    private static ResourceNode mimeConfigCache;
    private static ResourceNode mhuMimeConfigCache;
    private static Log log;

    public static String getFileSuffix(File _file) {
        if (_file == null) {
            return null;
        }
        return MFile.getFileSuffix(_file.getAbsolutePath());
    }

    public static String getFileSuffix(String name) {
        if (name == null) {
            return null;
        }
        if (!MString.isIndex(name, '.')) {
            return "";
        }
        name = MString.afterLastIndex(name, '.');
        return name;
    }

    public static String getFileName(String path) {
        if (path == null) {
            return null;
        }
        while (MString.isIndex(path, File.separatorChar)) {
            path = MString.afterIndex(path, File.separatorChar);
        }
        return path;
    }

    public static File getWorkingDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public static String readFile(File _f) {
        return MFile.readFile(_f, "UTF-8");
    }

    public static String readFile(File _f, String encoding) {
        if (_f == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            FileInputStream fis = new FileInputStream(_f);
            InputStreamReader fr = new InputStreamReader((InputStream)fis, encoding);
            String ret = MFile.readFile(fr);
            fis.close();
            return ret;
        }
        catch (Exception e) {
            log.d(_f, e);
            return null;
        }
    }

    public static String readFile(Reader _is) {
        if (_is == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            while (true) {
                int size;
                if ((size = _is.read(buffer)) < 0) {
                    return sb.toString();
                }
                if (size > 0) {
                    sb.append(buffer, 0, size);
                    continue;
                }
                MThread.sleep(50L);
            }
        }
        catch (EOFException size) {
        }
        catch (Exception e) {
            log.d(e);
        }
        return sb.toString();
    }

    public static String readFile(InputStream _is) {
        return MFile.readFile(_is, "UTF-8");
    }

    public static String readFile(InputStream _is, String encoding) {
        if (_is == null) {
            return null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            InputStreamReader fr = new InputStreamReader(_is, encoding);
            String ret = MFile.readFile(fr);
            return ret;
        }
        catch (Exception e) {
            log.d(e);
            return null;
        }
    }

    public static byte[] readBinaryFile(File in) throws IOException {
        if (in == null) {
            return null;
        }
        FileInputStream fis = new FileInputStream(in);
        return MFile.readBinary(fis, false);
    }

    public static byte[] readBinary(InputStream is) throws IOException {
        return MFile.readBinary(is, false);
    }

    public static byte[] readBinary(InputStream is, boolean close) throws IOException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int size;
            while ((size = is.read(buffer)) >= 0) {
                if (size == 0) {
                    MThread.sleep(50L);
                    continue;
                }
                baos.write(buffer, 0, size);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (close) {
            is.close();
        }
        return baos.toByteArray();
    }

    public static void readBinary(InputStream is, byte[] buffer, int offset, int length) throws IOException {
        int j;
        if (is == null || buffer == null) {
            return;
        }
        do {
            if ((j = is.read(buffer, offset, length)) < 0) {
                throw new EOFException();
            }
            if (j == 0) {
                MThread.sleep(10L);
            }
            offset += j;
        } while ((length -= j) > 0);
    }

    public static boolean writeFile(File _f, String _content) {
        if (_f == null) {
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream(_f);
            if (_content != null) {
                char[] c = _content.toCharArray();
                for (int i = 0; i < c.length; ++i) {
                    ((OutputStream)fos).write(c[i]);
                }
            }
            ((OutputStream)fos).close();
        }
        catch (Exception e) {
            log.d(_f, e);
            return false;
        }
        return true;
    }

    public static boolean writeFile(File _f, byte[] _content) {
        if (_f == null) {
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream(_f);
            if (_content != null) {
                MFile.writeFile(fos, _content, 0, _content.length);
            }
            ((OutputStream)fos).close();
        }
        catch (Exception e) {
            log.d(_f, e);
            return false;
        }
        return true;
    }

    public static void writeFile(OutputStream fos, byte[] _content, int offset, int length) throws IOException {
        if (fos == null || _content == null) {
            return;
        }
        fos.write(_content, offset, length);
    }

    public static boolean copyFile(File _src, File _dest) {
        if (_src == null || _dest == null) {
            return false;
        }
        if (_src.isDirectory()) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(_src);
            FileOutputStream fos = new FileOutputStream(_dest);
            MFile.copyFile(fis, fos);
            ((InputStream)fis).close();
            ((OutputStream)fos).close();
        }
        catch (Exception e) {
            log.d(_src, _dest, e);
            return false;
        }
        return true;
    }

    public static void copyFile(InputStream _is, OutputStream _os) {
        if (_is == null || _os == null) {
            return;
        }
        long free = Runtime.getRuntime().freeMemory();
        if (free < 1024L) {
            free = 1024L;
        }
        if (free > 32768L) {
            free = 32768L;
        }
        byte[] buffer = new byte[(int)free];
        int i = 0;
        try {
            while ((i = _is.read(buffer)) != -1) {
                _os.write(buffer, 0, i);
            }
        }
        catch (Exception e) {
            log.d(e);
        }
    }

    public static void copyFile(Reader _is, Writer _os) {
        if (_is == null || _os == null) {
            return;
        }
        long free = Runtime.getRuntime().freeMemory();
        if (free < 1024L) {
            free = 1024L;
        }
        if (free > 32768L) {
            free = 32768L;
        }
        char[] buffer = new char[(int)free / 2];
        int i = 0;
        try {
            while ((i = _is.read(buffer)) != -1) {
                _os.write(buffer, 0, i);
            }
        }
        catch (Exception e) {
            log.d(e);
        }
    }

    public static String toFileName(String _name) {
        if (_name == null) {
            return null;
        }
        String out = _name.replace('\\', '_');
        out = out.replace('/', '_');
        out = out.replace('*', '_');
        out = out.replace('?', '_');
        out = out.replace('+', '_');
        out = out.replace('#', '_');
        out = out.replace('\'', '_');
        out = out.replace('\"', '_');
        out = out.replace('$', '_');
        out = out.replace('%', '_');
        out = out.replace('?', '_');
        out = out.replace(':', '_');
        out = out.replace('<', '_');
        out = out.replace('>', '_');
        out = out.replace('{', '_');
        out = out.replace('}', '_');
        return out;
    }

    public static void deleteDir(File _dir) {
        if (_dir == null) {
            return;
        }
        if (!_dir.isDirectory()) {
            _dir.delete();
            return;
        }
        File[] list = _dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            MFile.deleteDir(list[i]);
        }
        _dir.delete();
    }

    public static void copyDir(File _src, File _dest) {
        MFile.copyDir(_src, _dest, (String)null);
    }

    public static void copyDir(File _src, File _dest, String _filter) {
        if (_src == null || _dest == null) {
            return;
        }
        if (_filter == null) {
            MFile.copyDir(_src, _dest, (FileFilter)null);
        } else {
            MFile.copyDir(_src, _dest, MString.split(_filter, ","));
        }
    }

    public static void copyDir(File _src, File _dest, final String[] _filter) {
        if (_src == null || _dest == null) {
            return;
        }
        if (_filter == null) {
            MFile.copyDir(_src, _dest, (FileFilter)null);
        } else {
            MFile.copyDir(_src, _dest, new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    for (int i = 0; i < _filter.length; ++i) {
                        if (_filter[i] == null || !_filter[i].equals(arg0.getName())) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    public static void copyDir(File _src, File _dest, FileFilter _filter) {
        if (_src == null || _dest == null) {
            return;
        }
        if (_filter != null && !_filter.accept(_src)) {
            return;
        }
        if (!_src.isDirectory()) {
            MFile.copyFile(_src, _dest);
            return;
        }
        try {
            _dest.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File[] list = _src.listFiles();
        for (int i = 0; i < list.length; ++i) {
            MFile.copyDir(list[i], new File(_dest, list[i].getName()), _filter);
        }
    }

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(92) >= 0) {
            name = name.replaceAll("\\\\", "_");
        }
        if (name.indexOf(47) >= 0) {
            name = name.replaceAll("/", "_");
        }
        if (name.indexOf(42) >= 0) {
            name = name.replaceAll("\\*", "_");
        }
        if (name.indexOf(63) >= 0) {
            name = name.replaceAll("\\?", "_");
        }
        if (name.indexOf(58) >= 0) {
            name = name.replaceAll(":", "_");
        }
        if (name.indexOf(32) >= 0) {
            name = name.replaceAll(" ", "_");
        }
        return name;
    }

    public static String getFileNameOnly(String key) {
        if (key == null) {
            return null;
        }
        if (key.indexOf(47) >= 0) {
            key = MString.afterLastIndex(key, '/');
        }
        if (key.indexOf(92) >= 0) {
            key = MString.afterLastIndex(key, '\\');
        }
        if (key.length() > 1 && key.indexOf(46, 1) >= 0) {
            key = MString.beforeLastIndex(key, '.');
        }
        return key;
    }

    public static String replaceExtension(String name, String newExtension) {
        if (name == null || newExtension == null) {
            return name;
        }
        return MString.beforeLastIndex(name, '.') + "." + newExtension;
    }

    public static String getMimeType(String extension) {
        ResourceNode map;
        if (extension == null) {
            return null;
        }
        extension = extension.trim().toLowerCase();
        String mime = null;
        ResourceNode config = MSingleton.get().getConfigProvider().getConfig(MFile.class, null);
        if (config != null && (map = config.getNode("mapping")) != null) {
            try {
                mime = map.getExtracted(extension);
            }
            catch (MException mException) {
                // empty catch block
            }
        }
        if (mime == null && config != null) {
            try {
                String file = config.getExtracted("file");
                if (file != null) {
                    if (mimeConfigCache == null) {
                        // empty if block
                    }
                    if (mimeConfigCache != null && (mime = mimeConfigCache.getExtracted(extension)) == null) {
                        mime = mimeConfigCache.getExtracted("default");
                    }
                }
            }
            catch (MException mException) {
                // empty catch block
            }
        }
        if (mime == null) {
            if (mhuMimeConfigCache == null) {
                // empty if block
            }
            try {
                if (mhuMimeConfigCache != null && (mime = mhuMimeConfigCache.getExtracted(extension)) == null) {
                    mime = mhuMimeConfigCache.getExtracted("default");
                }
            }
            catch (MException mException) {
                // empty catch block
            }
        }
        if (mime == null) {
            mime = DEFAULT_MIME;
        }
        return mime;
    }

    public static void writeLines(File file, List<String> lines, boolean append) throws IOException {
        if (file == null || lines == null) {
            return;
        }
        FileWriter w = new FileWriter(file, append);
        MFile.writeLines(w, lines);
        w.close();
    }

    private static void writeLines(Writer w, List<String> lines) throws IOException {
        for (String line : lines) {
            w.write(line);
            w.write(10);
        }
    }

    public static List<String> readLines(File file, boolean removeLastEmpty) throws IOException {
        if (file == null) {
            return null;
        }
        final LinkedList<String> out = new LinkedList<String>();
        MFile.readLines(file, new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                out.add((String)arg);
            }
        });
        if (removeLastEmpty && out.size() > 0 && MString.isEmpty(out.getLast())) {
            out.removeLast();
        }
        return out;
    }

    public static void readLines(File file, Observer lineObserver) throws IOException {
        if (file == null || lineObserver == null) {
            return;
        }
        FileReader r = new FileReader(file);
        MFile.readLines(r, lineObserver);
        r.close();
    }

    public static void readLines(Reader r, Observer lineObserver) throws IOException {
        if (r == null || lineObserver == null) {
            return;
        }
        BufferedReader br = new BufferedReader(r);
        String line = null;
        do {
            if ((line = br.readLine()) == null) continue;
            lineObserver.update(null, line);
        } while (line != null);
    }

    static {
        log = Log.getLog(MFile.class);
    }
}

