/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.io.TextReader;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.Rot13;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class MPassword {
    private static Log log = Log.getLog(MPassword.class);
    private static final Random random = new Random();

    public static String encode(String in) {
        return MPassword.encode(1, in);
    }

    public static String encode(int method, String in) {
        if (in == null) {
            return null;
        }
        if (MPassword.isEncoded(in)) {
            return in;
        }
        switch (method) {
            case 1: {
                return ":1" + Rot13.encode(in);
            }
        }
        return null;
    }

    public static boolean isEncoded(String in) {
        if (in == null) {
            return false;
        }
        return in.startsWith(":");
    }

    public static String decode(String in) {
        if (in == null) {
            return null;
        }
        if (!MPassword.isEncoded(in)) {
            return in;
        }
        if (in.startsWith(":1")) {
            return Rot13.decode(in.substring(2));
        }
        return in;
    }

    public static String encodePasswordMD5(String real) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(real.getBytes());
            return MCast.toBinaryString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            log.t(e);
            return null;
        }
    }

    public static String sha1(String ... input) throws NoSuchAlgorithmException {
        MessageDigest mDigest = MessageDigest.getInstance("SHA1");
        for (String in : input) {
            mDigest.update(in.getBytes());
        }
        byte[] result = mDigest.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            sb.append(Integer.toString((result[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.print("decoded: ");
            TextReader reader = new TextReader(System.in);
            args = new String[]{reader.readLine()};
        }
        System.out.println("encoded: " + MPassword.encode(args[0]));
    }

    public static String generate(int min, int max, boolean upper, boolean numbers, boolean specials) {
        int c;
        char[] symbols = new char[75];
        int i = 0;
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            symbols[i++] = c;
        }
        if (upper) {
            for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
                symbols[i++] = c;
            }
        }
        if (numbers) {
            for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
                symbols[i++] = c;
            }
        }
        if (specials) {
            symbols[i++] = 95;
            symbols[i++] = 45;
            symbols[i++] = 46;
            symbols[i++] = 33;
            symbols[i++] = 43;
            symbols[i++] = 47;
            symbols[i++] = 64;
            symbols[i++] = 35;
            symbols[i++] = 59;
        }
        return MPassword.generate(max == min ? min : random.nextInt(max - min) + max, symbols, i);
    }

    public static String generate(int length, char[] symbols, int symbolLength) {
        char[] buf = new char[length];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = symbols[random.nextInt(symbolLength)];
        }
        return new String(buf);
    }
}

