/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.configupdater.ConfigUpdater;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.TrailLevelMapper;
import de.mhus.lib.core.system.DefaultSingleton;
import de.mhus.lib.core.system.DummyClass;
import de.mhus.lib.core.system.ISingleton;
import de.mhus.lib.core.system.ISingletonFactory;
import de.mhus.lib.core.system.SingletonInitialize;
import java.util.UUID;
import java.util.WeakHashMap;

public class MSingleton {
    private static ISingleton singleton;
    protected static Boolean trace;
    private static WeakHashMap<UUID, Log> loggers;
    private static ResourceNode emptyConfig;
    private static ConfigUpdater configUpdater;

    private MSingleton() {
    }

    public static synchronized ISingleton get() {
        if (singleton == null) {
            block9: {
                try {
                    ISingletonFactory factory;
                    ISingleton obj = null;
                    String path = "de.mhus.lib.mutable.SingletonFactory";
                    if (System.getProperty("mhu.lib.singleton.factory") != null) {
                        path = System.getProperty("mhus.singleton.factory");
                    }
                    if (MSingleton.isDirtyTrace()) {
                        System.out.println("--- MSingletonFactory:" + path);
                    }
                    if ((factory = (ISingletonFactory)Class.forName(path).newInstance()) != null) {
                        obj = factory.createSingleton();
                    }
                    singleton = obj;
                }
                catch (Throwable t) {
                    if (!MSingleton.isDirtyTrace()) break block9;
                    t.printStackTrace();
                }
            }
            if (singleton == null) {
                singleton = new DefaultSingleton();
            }
            if (MSingleton.isDirtyTrace()) {
                System.out.println("--- MSingleton: " + singleton.getClass().getCanonicalName());
            }
            if (singleton instanceof SingletonInitialize) {
                ((SingletonInitialize)((Object)singleton)).doInitialize(DummyClass.class.getClassLoader());
            }
        }
        return singleton;
    }

    public static boolean isDirtyTrace() {
        if (trace == null) {
            trace = "true".equals(System.getProperty("mhu.lib.singleton.trace"));
        }
        return trace;
    }

    public static void setDirtyTrace(boolean dt) {
        trace = dt;
    }

    public static boolean isTrace(String name) {
        if (MSingleton.isDirtyTrace()) {
            System.out.println("--- Ask for trace: " + name);
        }
        return MSingleton.get().isTrace(name);
    }

    public static void doStartTrailLog() {
        LevelMapper mapper = MSingleton.get().getLogFactory().getLevelMapper();
        if (mapper != null && mapper instanceof TrailLevelMapper) {
            ((TrailLevelMapper)mapper).doConfigureTrail("MAP");
        }
    }

    public static void doStopTrailLog() {
        LevelMapper mapper = MSingleton.get().getLogFactory().getLevelMapper();
        if (mapper != null && mapper instanceof TrailLevelMapper) {
            ((TrailLevelMapper)mapper).doResetTrail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLogger(Log log) {
        WeakHashMap<UUID, Log> weakHashMap = loggers;
        synchronized (weakHashMap) {
            loggers.put(log.getId(), log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLogger(Log log) {
        WeakHashMap<UUID, Log> weakHashMap = loggers;
        synchronized (weakHashMap) {
            loggers.remove(log.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLoggers() {
        block6: {
            try {
                WeakHashMap<UUID, Log> weakHashMap = loggers;
                synchronized (weakHashMap) {
                    for (UUID logId : loggers.keySet().toArray(new UUID[loggers.size()])) {
                        loggers.get(logId).update();
                    }
                }
            }
            catch (Throwable t) {
                if (!MSingleton.isDirtyTrace()) break block6;
                t.printStackTrace();
            }
        }
    }

    public static ResourceNode getConfig(Object owner) {
        if (emptyConfig == null) {
            emptyConfig = new HashConfig();
        }
        return MSingleton.get().getConfigProvider().getConfig(owner, emptyConfig);
    }

    public static synchronized ConfigUpdater getConfigUpdater() {
        if (configUpdater == null) {
            configUpdater = new ConfigUpdater();
        }
        return configUpdater;
    }

    static {
        loggers = new WeakHashMap();
        emptyConfig = null;
    }
}

