/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MThreadManager;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.logging.Log;

public class MThread
extends MObject
implements Runnable {
    protected static Log log = Log.getLog(MThread.class);
    protected Runnable task = this;
    protected String name = "";
    protected ThreadContainer tc = null;

    public MThread() {
    }

    public MThread(String _name) {
        this.name = _name;
    }

    public MThread(Runnable _task) {
        this.task = _task;
    }

    public MThread(Runnable _task, String _name) {
        this.task = _task;
        this.name = _name;
    }

    protected Runnable getTask() {
        return this.task;
    }

    @Override
    public void run() {
    }

    public MThread start() {
        this.tc = this.base(MThreadManager.class).start(this, this.name);
        return this;
    }

    public void setName(String _name) {
        if (this.tc != null) {
            this.tc.setName(_name);
        }
    }

    public String getName() {
        if (this.tc != null) {
            return this.tc.getName();
        }
        return "";
    }

    public void setPriority(int _p) {
        if (this.tc != null) {
            this.tc.setPriority(_p);
        }
    }

    public int getPriority() {
        if (this.tc != null) {
            return this.tc.getPriority();
        }
        return 0;
    }

    public void stop() {
        if (this.tc == null) {
            return;
        }
        this.tc.stop();
    }

    public void throwException(Throwable throwable) {
        if (this.tc == null) {
            return;
        }
        this.tc.stop(throwable);
    }

    public static void sleep(long _millisec) {
        try {
            Thread.sleep(_millisec);
        }
        catch (InterruptedException e) {
            log.i(e);
        }
    }

    private void taskFinish() {
        this.tc = null;
    }

    public void taskError(Throwable t) {
    }

    protected static class ThreadContainer
    extends Thread {
        private boolean running = true;
        private MThread task = null;
        private String name;
        private long sleepStart;

        public ThreadContainer(ThreadGroup group, String pName) {
            super(group, pName);
            this.name = pName;
            this.setName(this.name + " sleeping");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean newWork(MThread _task) {
            ThreadContainer threadContainer = this;
            synchronized (threadContainer) {
                if (this.task != null || !this.running) {
                    return false;
                }
                this.task = _task;
                this.notify();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWorking() {
            ThreadContainer threadContainer = this;
            synchronized (threadContainer) {
                return this.task != null;
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean stopRunning() {
            ThreadContainer threadContainer = this;
            synchronized (threadContainer) {
                if (this.task != null) {
                    return false;
                }
                this.running = false;
                this.notifyAll();
            }
            return true;
        }

        public long getSleepTime() {
            if (this.task != null) {
                return 0L;
            }
            return System.currentTimeMillis() - this.sleepStart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                this.sleepStart = System.currentTimeMillis();
                while (this.task == null && this.running) {
                    try {
                        ThreadContainer threadContainer = this;
                        synchronized (threadContainer) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                MThread currentTask = this.task;
                if (this.task != null) {
                    this.setName(this.name + '[' + this.getId() + "] " + currentTask.getTask().getClass().getName());
                    try {
                        log.d("Enter Thread Task");
                        currentTask.getTask().run();
                        log.d("Leave Thread Task");
                    }
                    catch (Throwable t) {
                        try {
                            log.i("Thread Task Error", this.getName(), t);
                            currentTask.taskError(t);
                        }
                        catch (Throwable t2) {
                            log.i("Thread Task Finish Error", this.getName(), t2);
                        }
                    }
                    log.d("###: LEAVE THREAD");
                    this.setName(this.name + " sleeping");
                }
                if (currentTask != null) {
                    currentTask.taskFinish();
                }
                this.task = null;
            }
        }
    }
}

