/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MHousekeeper;
import de.mhus.lib.core.MHousekeeperTask;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.MThreadDaemon;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.lang.MObject;
import java.util.Vector;

public class MThreadManager
extends MObject
implements IBase {
    public static long SLEEP_TIME = 600000L;
    public static long PENDING_TIME = 60000L;
    private Vector<MThread.ThreadContainer> pool = new Vector();
    private ThreadGroup group = new ThreadGroup("AThread");
    private ThreadHousekeeper housekeeper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MThread.ThreadContainer start(MThread _task, String _name) {
        MThread.ThreadContainer tc = null;
        Vector<MThread.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            if (this.housekeeper == null) {
                this.housekeeper = new ThreadHousekeeper();
                this.base(MHousekeeper.class).register(this.housekeeper, SLEEP_TIME, true);
            }
            for (int i = 0; i < this.pool.size(); ++i) {
                if (this.pool.elementAt(i).isWorking()) continue;
                tc = this.pool.elementAt(i);
                break;
            }
            if (tc == null) {
                tc = new MThread.ThreadContainer(this.group, "AT" + this.pool.size());
                tc.start();
                this.pool.addElement(tc);
            }
            this.log().t("###: NEW THREAD", tc.getId());
            tc.setName(_name);
            tc.newWork(_task);
        }
        return tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poolClean(long pendingTime) {
        Vector<MThread.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThread.ThreadContainer[] list = this.pool.toArray(new MThread.ThreadContainer[this.pool.size()]);
            for (int i = 0; i < list.length; ++i) {
                long sleep = list[i].getSleepTime();
                if (sleep == 0L || sleep > pendingTime) continue;
                this.pool.remove(list[i]);
                list[i].stopRunning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poolClean() {
        Vector<MThread.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThread.ThreadContainer[] list = this.pool.toArray(new MThread.ThreadContainer[this.pool.size()]);
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isWorking()) continue;
                this.pool.remove(list[i]);
                list[i].stopRunning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poolSize() {
        Vector<MThread.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            return this.pool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poolWorkingSize() {
        int size = 0;
        Vector<MThread.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThread.ThreadContainer[] list = this.pool.toArray(new MThread.ThreadContainer[this.pool.size()]);
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isWorking()) continue;
                ++size;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        this.log().t("finalize");
        Vector<MThread.ThreadContainer> vector = this.pool;
        synchronized (vector) {
            MThread.ThreadContainer[] list;
            for (MThread.ThreadContainer tc : list = this.pool.toArray(new MThread.ThreadContainer[this.pool.size()])) {
                tc.stopRunning();
            }
        }
    }

    private class ThreadHousekeeper
    extends MHousekeeperTask {
        private ThreadHousekeeper() {
        }

        @Override
        public void doit() {
            this.log().t(this.getClass(), "Housekeeper");
            MThreadManager.this.poolClean(PENDING_TIME);
            MThreadDaemon.poolClean(PENDING_TIME);
        }
    }
}

