/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MXml {
    public static String getValue(Element root, boolean inner) {
        if (root == null) {
            return null;
        }
        NodeList raw = root.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < raw.getLength(); ++i) {
            if (raw.item(i).getNodeType() == 1 && inner) {
                sb.append(MXml.getValue((Element)raw.item(i), inner));
                continue;
            }
            if (raw.item(i).getNodeType() == 3) {
                sb.append(raw.item(i).getNodeValue());
                continue;
            }
            if (raw.item(i).getNodeType() != 4) continue;
            sb.append(raw.item(i).getNodeValue());
        }
        return sb.toString();
    }

    public static String getValue(Element root, ValueListener listener) {
        if (root == null) {
            return null;
        }
        NodeList raw = root.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < raw.getLength(); ++i) {
            if (raw.item(i).getNodeType() == 1) {
                sb.append(listener.valueOf((Element)raw.item(i), MXml.getValue((Element)raw.item(i), listener)));
                continue;
            }
            if (raw.item(i).getNodeType() != 3) continue;
            sb.append(raw.item(i).getNodeValue());
        }
        return sb.toString();
    }

    public static NodeList getLocalElements(Element root, String name) {
        if (root == null || name == null) {
            return null;
        }
        NodeList raw = root.getChildNodes();
        MyNodeList out = new MyNodeList();
        for (int i = 0; i < raw.getLength(); ++i) {
            if (raw.item(i).getNodeType() != 1 || !name.equals("*") && !name.equals(raw.item(i).getNodeName())) continue;
            out.add(raw.item(i));
        }
        return out;
    }

    public static NodeList getLocalElements(Element root) {
        if (root == null) {
            return null;
        }
        NodeList raw = root.getChildNodes();
        MyNodeList out = new MyNodeList();
        for (int i = 0; i < raw.getLength(); ++i) {
            if (raw.item(i).getNodeType() != 1) continue;
            out.add(raw.item(i));
        }
        return out;
    }

    public static ElementIterator getLocalElementIterator(Element root, String name) {
        return new ElementIterator(MXml.getLocalElements(root, name));
    }

    public static ElementIterator getLocalElementIterator(Element root) {
        return new ElementIterator(MXml.getLocalElements(root));
    }

    public static Element getElementByPath(Element root, String path) {
        if (root == null || path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            while (root.getParentNode() != null && root.getParentNode() instanceof Element) {
                root = (Element)root.getParentNode();
            }
            path = path.substring(1);
        }
        String[] parts = path.split("\\/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            int index = 0;
            String key = null;
            String value = null;
            int pos = part.indexOf(64);
            if (pos >= 0) {
                String kv = part.substring(pos + 1);
                key = MString.beforeIndex(kv, '=');
                value = MString.afterIndex(kv, '=');
                part = part.substring(0, pos);
            }
            if ((pos = part.indexOf(91)) >= 0) {
                int pos2 = part.indexOf(93, pos);
                try {
                    index = Integer.parseInt(part.substring(pos + 1, pos2));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                part = part.substring(0, pos);
            }
            NodeList list = MXml.getLocalElements(root, part);
            if (key != null) {
                root = null;
                for (int j = 0; j < list.getLength(); ++j) {
                    Node e = list.item(j);
                    if (!(e instanceof Element) || !value.equals(((Element)e).getAttribute(key))) continue;
                    root = (Element)e;
                    break;
                }
                if (root != null) continue;
                return null;
            }
            if (list.getLength() <= index) {
                return null;
            }
            root = (Element)list.item(index);
        }
        return root;
    }

    public static String getPathAsString(Node in) {
        if (in == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        do {
            if (in instanceof Document) continue;
            out.insert(0, in.getNodeName());
            out.insert(0, '/');
        } while ((in = in.getParentNode()) != null);
        return out.toString();
    }

    public static Document loadXml(String xml, String charset) throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException {
        if (xml == null) {
            return null;
        }
        if (!xml.startsWith("<?xml")) {
            xml = "<?xml version=\"1.0\" encoding=\"" + charset + "\"?>" + xml;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(xml.getBytes(charset)));
    }

    public static Document loadXml(String xml) throws ParserConfigurationException, SAXException, IOException {
        return MXml.loadXml(xml, "UTF-8");
    }

    public static Document loadXml(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.parse(is);
    }

    public static Document loadXml(Reader file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.parse(new InputSource(file));
    }

    public static void saveXml(Node e, OutputStream out) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(e);
        transformer.transform(source, result);
    }

    public static void saveXml(Node e, Writer out, boolean intend) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", intend ? "yes" : "no");
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(e);
        transformer.transform(source, result);
    }

    public static String toString(Node e, boolean intend) throws Exception {
        StringWriter sw = new StringWriter();
        MXml.saveXml(e, sw, intend);
        return sw.toString();
    }

    public static Document createDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.newDocument();
    }

    public static String encode(String _in) {
        if (_in == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (c > '~' || c < ' ') {
                out.append("&#" + c + ";");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c == '\"') {
                out.append("&quot;");
                continue;
            }
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String unicodeEncode(String _in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (c > '\u00ff') {
                out.append("&#" + c + ";");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String decode(String _in) {
        if (_in == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        boolean mode = false;
        StringBuffer joker = null;
        int jLen = 0;
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (!mode) {
                if (c == '&') {
                    mode = true;
                    jLen = 0;
                    joker = new StringBuffer();
                    continue;
                }
                out.append(c);
                continue;
            }
            ++jLen;
            if (c == ';') {
                String j = joker.toString();
                if (j.length() > 0) {
                    if (j.startsWith("#")) {
                        out.append((char)Integer.parseInt(j.substring(1)));
                    } else if (j.equals("quot")) {
                        out.append('\"');
                    } else if (j.equals("lt")) {
                        out.append('<');
                    } else if (j.equals("gt")) {
                        out.append('>');
                    } else if (j.equals("amp")) {
                        out.append('&');
                    } else if (j.equals("auml")) {
                        out.append('\u00e4');
                    } else if (j.equals("Auml")) {
                        out.append('\u00c4');
                    } else if (j.equals("ouml")) {
                        out.append('\u00f6');
                    } else if (j.equals("Ouml")) {
                        out.append('\u00d6');
                    } else if (j.equals("uuml")) {
                        out.append('\u00fc');
                    } else if (j.equals("Uuml")) {
                        out.append('\u00dc');
                    } else if (j.equals("szlig")) {
                        out.append('\u00df');
                    } else if (j.equals("nbsp")) {
                        out.append(' ');
                    } else {
                        out.append("&" + j + ";");
                    }
                } else {
                    out.append("&;");
                }
                mode = false;
                continue;
            }
            joker.append(c);
            if (jLen <= 8) continue;
            out.append("&").append(joker);
            mode = false;
        }
        return out.toString();
    }

    public static String dump(Node element) {
        if (element == null) {
            return "null";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream o = new PrintStream(out);
        MXml.dump(o, element, "");
        return out.toString();
    }

    public static void dump(PrintStream o, Node element) {
        MXml.dump(o, element, "");
    }

    public static void dump(PrintStream o, Node node, String level) {
        if (node instanceof Document) {
            MXml.dump(o, ((Document)node).getDocumentElement(), level);
        } else if (node instanceof Element) {
            Element element = (Element)node;
            o.print(level + "<" + element.getNodeName());
            NamedNodeMap attrs = element.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                o.print(" " + attrs.item(i).getNodeName() + "='" + attrs.item(i).getNodeValue() + "'");
            }
            o.println("> {" + node.getClass().getCanonicalName() + "}");
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                MXml.dump(o, nodes.item(i), level + "  ");
            }
            o.println(level + "</" + element.getNodeName() + ">");
        } else if (node instanceof ProcessingInstruction) {
            o.println(level + "<?" + node.getNodeName() + " " + ((ProcessingInstruction)node).getData() + "?> {" + node.getClass().getCanonicalName() + "}");
        } else if (node instanceof Comment) {
            o.println(level + "<!--" + ((Comment)node).getData() + "--> {" + node.getClass().getCanonicalName() + "}");
        } else if (node instanceof Text) {
            o.println(level + "'" + ((Text)node).getData() + "' {" + node.getClass().getCanonicalName() + "}");
        } else if (node instanceof DocumentType) {
            o.println(level + "<!DOCTYPE " + ((DocumentType)node).getName() + " " + ((DocumentType)node).getInternalSubset() + " \"" + ((DocumentType)node).getPublicId() + "\"> {" + node.getClass().getCanonicalName() + "}");
        } else {
            o.println(level + "{" + node.getClass().getCanonicalName() + "}");
        }
    }

    public static void dump(PrintStream out, NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            MXml.dump(out, nodes.item(i), "");
        }
    }

    public static String innerXml(Node node) {
        return MXml.innerXml(node, true);
    }

    public static String innerXml(Node node, boolean instructions) {
        if (node == null) {
            return null;
        }
        Node childChild = null;
        try {
            DOMImplementationLS lsImpl = (DOMImplementationLS)node.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
            LSSerializer lsSerializer = lsImpl.createLSSerializer();
            NodeList childNodes = node.getChildNodes();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                int pos;
                childChild = childNodes.item(i);
                if (childChild instanceof Text) {
                    sb.append(childChild.getNodeValue());
                    continue;
                }
                if (childChild instanceof ProcessingInstruction) {
                    if (!instructions) continue;
                    sb.append("<?").append(childChild.getNodeName()).append(" ").append(childChild.getNodeValue()).append("?>");
                    continue;
                }
                String ser = lsSerializer.writeToString(childChild);
                if (ser.substring(0, 2).equals("<?") && (pos = ser.indexOf("?>\n")) > 0) {
                    ser = ser.substring(pos + 3);
                }
                sb.append(ser);
            }
            return sb.toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static NodeIterator queryXPath(Node root, String query) throws XPathExpressionException {
        if (root == null || query == null) {
            return new NodeIterator(null);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(query);
        NodeList result = (NodeList)expr.evaluate(root, XPathConstants.NODESET);
        return new NodeIterator(result);
    }

    public static ElementIterator queryXPathElements(Node root, String query) throws XPathExpressionException {
        if (root == null || query == null) {
            return new ElementIterator(null);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(query);
        NodeList result = (NodeList)expr.evaluate(root, XPathConstants.NODESET);
        return new ElementIterator(result);
    }

    public static void trim(Element element) {
        if (element == null) {
            return;
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String value;
            Node node = nodes.item(i);
            if (node instanceof Element) {
                MXml.trim((Element)node);
                continue;
            }
            if (!(node instanceof Text) || (value = ((Text)node).getNodeValue()) == null) continue;
            value = value.trim();
            node.setNodeValue(value);
        }
    }

    public static void carveOut(Element element) {
        if (element == null) {
            return;
        }
        Element parent = (Element)element.getParentNode();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            element.removeChild(child);
            parent.insertBefore(child, element);
        }
        parent.removeChild(element);
    }

    public static String normalizeName(String key) {
        boolean doIt = false;
        if (key == null) {
            return null;
        }
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '-') continue;
            doIt = true;
            break;
        }
        if (doIt) {
            StringBuffer out = new StringBuffer();
            for (int i = 0; i < key.length(); ++i) {
                int c = key.charAt(i);
                if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c == 46 || c == 45)) {
                    c = 95;
                }
                out.append((char)c);
            }
            key = out.toString();
        }
        return MXml.encode(key);
    }

    public static String removeTags(String txt) {
        txt = txt.replaceAll("<([\\s\\S]*?)>", "");
        return txt;
    }

    public static String removeHtmlTags(String txt) {
        txt = txt.replaceAll("<script([\\s\\S]*?)</script>", "");
        txt = txt.replaceAll("<SCRIPT([\\s\\S]*?)</SCRIPT>", "");
        txt = txt.replaceAll("<!--([\\s\\S]*?)-->", "");
        txt = MXml.removeTags(txt);
        while (txt.indexOf("\n\n\n") >= 0) {
            txt = txt.replaceAll("\n\n\n", "\n\n");
        }
        txt = txt.trim();
        return txt;
    }

    public static String getValue(Element root, String path, String def) {
        Element ele = MXml.getElementByPath(root, path);
        if (ele == null) {
            return def;
        }
        return MXml.getValue(ele, false);
    }

    public static CDATASection findCDataSection(Element a) {
        NodeList list = a.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!(child instanceof CDATASection)) continue;
            return (CDATASection)child;
        }
        return null;
    }

    public static class NodeIterator
    implements Iterator<Node>,
    Iterable<Node> {
        private NodeList list;
        private int next;

        public NodeIterator(NodeList list) {
            this.list = list;
            this.next = 0;
        }

        @Override
        public boolean hasNext() {
            return this.list != null && this.list.getLength() > this.next;
        }

        @Override
        public Node next() {
            Node ret = this.list.item(this.next);
            ++this.next;
            return ret;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<Node> iterator() {
            return this;
        }
    }

    public static class ElementIterator
    implements Iterator<Element>,
    Iterable<Element> {
        private NodeList list;
        private int next;

        public ElementIterator(NodeList list) {
            this.list = list;
            this.next = 0;
        }

        @Override
        public boolean hasNext() {
            return this.list != null && this.list.getLength() > this.next;
        }

        @Override
        public Element next() {
            Element ret = (Element)this.list.item(this.next);
            ++this.next;
            return ret;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<Element> iterator() {
            return this;
        }
    }

    private static class MyNodeList
    extends Vector<Node>
    implements NodeList {
        private MyNodeList() {
        }

        @Override
        public int getLength() {
            return this.size();
        }

        @Override
        public Node item(int index) {
            return (Node)this.elementAt(index);
        }
    }

    public static interface ValueListener {
        public String valueOf(Element var1, String var2);
    }
}

