/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.IFlatConfig;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.directory.WritableResourceNode;
import de.mhus.lib.errors.MException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;

public class PropertiesConfig
extends IConfig
implements IFlatConfig {
    protected Properties properties = null;
    protected boolean changed = false;
    protected String name;

    public PropertiesConfig() {
        this(new Properties());
    }

    public PropertiesConfig(Properties config) {
        this.properties = config;
    }

    public PropertiesConfig(String fill) {
        this.properties = new Properties();
        if (fill != null) {
            try {
                this.readConfig(new StringReader(fill));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeConfig(Writer os) throws IOException {
        this.properties.store(os, "");
        this.changed = false;
    }

    public void readConfig(Reader file) throws IOException {
        this.properties.load(file);
    }

    public void configRemoved() {
    }

    @Override
    public ResourceNode getNode(String key) {
        return null;
    }

    @Override
    public ResourceNode[] getNodes(String key) {
        return new WritableResourceNode[0];
    }

    @Override
    public ResourceNode[] getNodes() {
        return new WritableResourceNode[0];
    }

    @Override
    public String[] getNodeKeys() {
        return new String[0];
    }

    @Override
    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
        this.changed = true;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.setProperty(key, MCast.objectToString(value));
        this.changed = true;
    }

    public boolean isConfigChanged() {
        return this.changed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WritableResourceNode createConfig(String key) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public int moveConfig(ResourceNode config, int newPos) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public void removeConfig(ResourceNode config) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public WritableResourceNode getParent() {
        return null;
    }

    @Override
    public InputStream getInputStream(String key) {
        return null;
    }

    @Override
    public URL getUrl() {
        return null;
    }
}

