/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.configupdater;

import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.MSystem;

public abstract class ConfigValue<T> {
    private String path;
    private T def;
    private T value;
    private Object owner;

    public ConfigValue(Object owner, String path, T def) {
        this.owner = owner;
        this.path = path;
        this.def = def;
        MSingleton.getConfigUpdater().register(this);
        this.update();
    }

    public T value() {
        return this.value == null ? this.def : this.value;
    }

    public String getPath() {
        return this.path;
    }

    public Object getOwner() {
        return this.owner;
    }

    public T getDefault() {
        return this.def;
    }

    void update() {
        T newValue = this.loadValue();
        if (MSystem.equals(this.value, newValue)) {
            return;
        }
        this.onUpdate(newValue);
        this.value = newValue;
    }

    protected abstract T loadValue();

    protected void onUpdate(T newValue) {
    }
}

