/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.console.Console;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConsoleTable {
    public static final String SEPARATOR_LINE = "---";
    public List<String> header = new ArrayList<String>();
    public List<List<String>> content = new ArrayList<List<String>>();
    private int maxColSize = -1;
    private boolean lineSpacer = false;

    public List<String> addRow() {
        ArrayList<String> row = new ArrayList<String>();
        this.content.add(row);
        return row;
    }

    public void addRowValues(Object ... values) {
        List<String> row = this.addRow();
        for (Object v : values) {
            row.add(String.valueOf(v));
        }
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeaderValues(String ... values) {
        List<String> row = this.getHeader();
        row.clear();
        for (String v : values) {
            row.add(v);
        }
    }

    public void print(Console console) {
        this.setMaxColSize(console.getWidth());
        this.print((PrintStream)console);
    }

    public void print(PrintStream out) {
        int[] sizes = new int[this.header.size()];
        this.updateSizes(sizes, this.header);
        for (List<String> row : this.content) {
            this.updateSizes(sizes, row);
        }
        String headerLine = this.getRow(sizes, this.header, " | ");
        out.println(headerLine);
        out.println(this.underline(headerLine.length()));
        boolean first = true;
        for (List<String> row : this.content) {
            if (!first && this.lineSpacer) {
                out.println();
            }
            out.println(this.getRow(sizes, row, " | "));
            first = false;
        }
    }

    private String underline(int length) {
        char[] exmarks = new char[length];
        Arrays.fill(exmarks, '-');
        return new String(exmarks);
    }

    private String getRow(int[] sizes, List<String> row, String separator) {
        if (row.size() == 1 && row.get(0).equals(SEPARATOR_LINE)) {
            int s = 0;
            for (int i : sizes) {
                if (s != 0) {
                    s += separator.length();
                }
                s += i;
            }
            return MString.rep('-', s);
        }
        StringBuilder line = new StringBuilder();
        int c = 0;
        for (String cell : row) {
            if (cell == null) {
                cell = "";
            }
            if (this.maxColSize > 0 && cell.length() > this.maxColSize) {
                cell = cell.substring(0, this.maxColSize - 1);
            }
            cell = cell.replaceAll("\n", "");
            line.append(String.format("%-" + sizes[c] + "s", cell));
            if (c + 1 < row.size()) {
                line.append(separator);
            }
            ++c;
        }
        return line.toString();
    }

    private void updateSizes(int[] sizes, List<String> row) {
        int c = 0;
        for (String cellContent : row) {
            int cellSize = cellContent != null ? cellContent.length() : 0;
            int n = cellSize = this.maxColSize > 0 ? Math.min(cellSize, this.maxColSize) : cellSize;
            if (cellSize > sizes[c]) {
                sizes[c] = cellSize;
            }
            ++c;
        }
    }

    public int getMaxColSize() {
        return this.maxColSize;
    }

    public void setMaxColSize(int maxColSize) {
        this.maxColSize = maxColSize;
    }

    public boolean isLineSpacer() {
        return this.lineSpacer;
    }

    public void setLineSpacer(boolean lineSpacer) {
        this.lineSpacer = lineSpacer;
    }
}

