/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import java.io.PrintWriter;
import java.io.Writer;

public class CSVWriter {
    private String lineSeparator = "\r\n";
    private PrintWriter pw;
    private final boolean trim;
    private int column = 0;
    private char quote;
    private char separator;
    private int quoteLevel;
    private String defaultNullValue = "";
    private ValueWriter writer = new DefaultValueWriter();

    public CSVWriter(Writer pw) {
        this(pw, 1, ',', '\"', true);
    }

    public CSVWriter(Writer pw, int quoteLevel, char separator, char quote, boolean trim) {
        this.pw = pw instanceof PrintWriter ? (PrintWriter)pw : new PrintWriter(pw);
        if (this.pw == null) {
            throw new IllegalArgumentException("invalid Writer");
        }
        this.quoteLevel = quoteLevel;
        this.separator = separator;
        this.quote = quote;
        this.trim = trim;
    }

    public void close() {
        if (this.pw != null) {
            this.pw.close();
            this.pw = null;
        }
    }

    public void setDefaultNullValue(String in) {
        this.defaultNullValue = in;
    }

    public String getDefaultNullValue() {
        return this.defaultNullValue;
    }

    public void nl() {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        this.writer.nl(this);
        this.column = 0;
    }

    public void print(Object ... values) {
        String[] v = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = String.valueOf(values[i]);
        }
        this.put(v);
    }

    public void println(Object ... values) {
        String[] v = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = String.valueOf(values[i]);
        }
        this.put(v);
        this.nl();
    }

    public void put(String ... values) {
        if (this.pw == null) {
            throw new IllegalArgumentException("attempt to use a closed CSVWriter");
        }
        if (values == null || values.length == 0) {
            return;
        }
        for (String s : values) {
            if (this.column != 0) {
                this.pw.write(this.separator);
            }
            this.writer.write(this, s);
            ++this.column;
        }
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public char getQuote() {
        return this.quote;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public int getQuoteLevel() {
        return this.quoteLevel;
    }

    public int getColumnOfLine() {
        return this.column;
    }

    public ValueWriter getValueWriter() {
        return this.writer;
    }

    public void setValueWriter(ValueWriter writer) {
        this.writer = writer;
    }

    public static class DefaultValueWriter
    implements ValueWriter {
        @Override
        public void write(CSVWriter writer, String s) {
            PrintWriter pw = writer.getPrintWriter();
            int quoteLevel = this.getQuoteLevel(writer);
            char quote = writer.getQuote();
            if (s == null) {
                if (writer.getDefaultNullValue() == null) {
                    writer.nl();
                    return;
                }
                s = writer.getDefaultNullValue();
            }
            if (writer.isTrim()) {
                s = s.trim();
            }
            if (s.indexOf(quote) >= 0) {
                if (quote != '\u0000') {
                    pw.write(quote);
                }
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == quote) {
                        if (quote != '\u0000') {
                            pw.write(quote);
                        }
                        pw.write(writer.getQuote());
                        continue;
                    }
                    pw.write(c);
                }
                if (quote != '\u0000') {
                    pw.write(writer.getQuote());
                }
            } else if (quoteLevel == 2 || quoteLevel == 1 && s.indexOf(32) >= 0 || s.indexOf(writer.getLineSeparator()) >= 0) {
                if (quote != '\u0000') {
                    pw.write(quote);
                }
                pw.write(s);
                if (quote != '\u0000') {
                    pw.write(quote);
                }
            } else {
                pw.write(s);
            }
        }

        public int getQuoteLevel(CSVWriter writer) {
            return writer.getQuoteLevel();
        }

        @Override
        public void nl(CSVWriter writer) {
            writer.getPrintWriter().write(writer.getLineSeparator());
        }
    }

    public static interface ValueWriter {
        public void write(CSVWriter var1, String var2);

        public void nl(CSVWriter var1);
    }
}

