/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContentCache
extends MObject {
    private File root;
    private boolean saveWrite = false;

    public ContentCache(ResourceNode config) throws MException {
        if (config != null) {
            String rootString = config.getExtracted("root");
            this.saveWrite = config.getBoolean("save", this.saveWrite);
            if (rootString != null) {
                this.root = new File(rootString);
                if (!this.root.exists() || !this.root.isDirectory()) {
                    this.root = null;
                }
            }
        }
        if (this.root == null) {
            this.log().w("cache disabled");
        }
    }

    public boolean isCached(String id) {
        if (this.root == null || id == null) {
            return false;
        }
        File dir = this.getDir(id);
        if (!dir.exists()) {
            return false;
        }
        File file = this.getFile(dir, id);
        return file.exists();
    }

    public InputStream cacheAndReturn(String id, InputStream is) throws IOException {
        if (this.root == null || id == null) {
            return is;
        }
        this.doCache(id, is);
        return this.getCached(id);
    }

    public void doCache(String id, InputStream is) throws IOException {
        if (this.root == null || id == null) {
            return;
        }
        this.openLock();
        this.log().d("cache", id);
        File dir = this.getDir(id);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = this.getFile(dir, id);
        FileOutputStream os = new FileOutputStream(file);
        MFile.copyFile(is, os);
        is.close();
        ((OutputStream)os).close();
        this.closeLock();
    }

    private void closeLock() {
        if (!this.saveWrite) {
            return;
        }
    }

    private void openLock() {
        if (!this.saveWrite) {
            return;
        }
    }

    public InputStream getCached(String id) throws FileNotFoundException {
        File file;
        if (this.root == null || id == null) {
            return null;
        }
        this.log().d("load cached", id);
        File dir = this.getDir(id);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = this.getFile(dir, id)).exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    private File getFile(File dir, String id) {
        if (id.length() < 3) {
            return new File(dir, id + ".bin");
        }
        return new File(dir, id.substring(id.length() - 3) + ".bin");
    }

    private File getDir(String id) {
        if (id.length() < 3) {
            return this.root;
        }
        StringBuffer x = new StringBuffer();
        for (int i = 0; i < id.length() - 3; ++i) {
            if (i % 3 == 0 && i != 0) {
                x.append("/");
            }
            x.append(id.charAt(i));
        }
        return new File(this.root, x.toString());
    }
}

