/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.jmx;

import de.mhus.lib.core.jmx.JmxDescription;
import de.mhus.lib.core.jmx.JmxObject;
import de.mhus.lib.core.jmx.MRemoteManager;
import de.mhus.lib.core.lang.MObject;
import java.lang.ref.WeakReference;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

final class MBeanProxy
extends MObject
implements DynamicMBean {
    private final ReferenceImpl weak;
    private MRemoteManager server;
    private ObjectName name;
    private JmxDescription desc;

    public MBeanProxy(Object realObject, JmxDescription desc, MRemoteManager server, ObjectName name, boolean weak) throws Exception {
        this.weak = new ReferenceImpl(realObject);
        this.desc = desc;
        if (desc == null) {
            this.desc = JmxDescription.create(realObject);
        }
        this.server = server;
        this.name = name;
        if (realObject instanceof JmxObject) {
            ((JmxObject)realObject).setJmxProxy(this);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.desc.getAttribute(this.getObject(), attribute);
    }

    private Object getObject() {
        Object out = this.weak.get();
        if (out == null) {
            this.unregsiter();
            throw new IllegalStateException(this.name + " no longer exists");
        }
        return out;
    }

    private synchronized void unregsiter() {
        if (this.server == null) {
            return;
        }
        this.server.unregister(this.name);
        this.server = null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.desc.setAttribute(this.getObject(), attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return this.desc.getAttributes(this.getObject(), attributes);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return this.desc.setAttributes(this.getObject(), attributes);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.desc.invoke(this.getObject(), actionName, params, signature);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.desc.getMBeanInfo();
    }

    public void setName(ObjectName objectName) {
        this.name = objectName;
    }

    public void check() {
        try {
            this.getObject();
        }
        catch (Throwable t) {
            this.log().t(this.name, "closed");
        }
    }

    private class ReferenceImpl
    extends WeakReference<Object> {
        public ReferenceImpl(Object referent) {
            super(referent);
        }
    }
}

