/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.json;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.json.TransformHelper;
import de.mhus.lib.core.logging.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class SecurityTransformHelper
extends TransformHelper {
    private Log log;
    private ClassLoader loader;
    private LinkedList<Rule> rules = null;

    public SecurityTransformHelper(ClassLoader loader, Log log) {
        this.log = log;
        this.loader = loader;
    }

    @Override
    public void log(String string, Throwable t) {
        if (this.log != null) {
            this.log.t(string, t);
        }
    }

    @Override
    public void log(String msg) {
        if (this.log != null) {
            this.log.t(msg);
        }
    }

    @Override
    public Object createObject(Class<?> type) throws InstantiationException, IllegalAccessException {
        if (!this.checkSecurityForClass(type.getCanonicalName())) {
            throw new IllegalAccessException(type.getCanonicalName());
        }
        return super.createObject(type);
    }

    @Override
    public Class<?> getType(String cName) throws IllegalAccessException {
        if (!this.checkSecurityForClass(cName)) {
            throw new IllegalAccessException(cName);
        }
        return super.getType(cName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSecurityForClass(String type) {
        if (this.rules == null) {
            return true;
        }
        LinkedList<Rule> linkedList = this.rules;
        synchronized (linkedList) {
            for (Rule rule : this.rules) {
                if (rule.isAllowed(type)) {
                    return true;
                }
                if (!rule.isDenied(type)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return super.getClassLoader();
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRule(Rule rule) {
        if (this.rules == null) {
            this.rules = new LinkedList();
        }
        LinkedList<Rule> linkedList = this.rules;
        synchronized (linkedList) {
            this.rules.add(rule);
        }
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new LinkedList();
        }
        return this.rules;
    }

    public static class RuleRegexDeny
    extends Rule {
        private Pattern matcher;

        public RuleRegexDeny(String allow) {
            this.matcher = Pattern.compile(allow);
        }

        @Override
        public boolean isDenied(String type) {
            return this.matcher.matcher(type).matches();
        }

        @Override
        public boolean isAllowed(String type) {
            return false;
        }
    }

    public static class RuleRegexAllow
    extends Rule {
        private Pattern matcher;

        public RuleRegexAllow(String allow) {
            this.matcher = Pattern.compile(allow);
        }

        @Override
        public boolean isDenied(String type) {
            return false;
        }

        @Override
        public boolean isAllowed(String type) {
            return this.matcher.matcher(type).matches();
        }
    }

    public static class RuleDeny
    extends Rule {
        private String pattern;

        public RuleDeny(String deny) {
            this.pattern = deny;
        }

        @Override
        public boolean isDenied(String type) {
            return MString.compareFsLikePattern(type, this.pattern);
        }

        @Override
        public boolean isAllowed(String type) {
            return false;
        }
    }

    public static class RuleAllow
    extends Rule {
        private String pattern;

        public RuleAllow(String allow) {
            this.pattern = allow;
        }

        @Override
        public boolean isDenied(String type) {
            return false;
        }

        @Override
        public boolean isAllowed(String type) {
            return MString.compareFsLikePattern(type, this.pattern);
        }
    }

    public static abstract class Rule {
        public abstract boolean isDenied(String var1);

        public abstract boolean isAllowed(String var1);
    }
}

