/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.logging.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class StreamToLogAdapter
extends PrintStream {
    protected static Log log = Log.getLog("Console");
    protected Log.LEVEL level;
    protected StringBuffer line = new StringBuffer();
    protected PrintStream forward;

    public StreamToLogAdapter(Log.LEVEL level, PrintStream forward) {
        super(new MyOutputStream());
        this.level = level;
        this.forward = forward;
        ((MyOutputStream)this.out).setAdapter(this);
    }

    protected void writeByte(int b) {
        if (this.forward != null) {
            this.forward.write(b);
        }
        if (b == 10) {
            this.writeLine();
        } else if (b != 13) {
            this.line.append((char)b);
        }
        if (this.line.length() > 1000) {
            this.writeLine();
        }
    }

    protected void writeLine() {
        log.log(this.level, this.line);
        this.line.setLength(0);
    }

    private static class MyOutputStream
    extends OutputStream {
        private StreamToLogAdapter adapter;

        public void setAdapter(StreamToLogAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.adapter == null) {
                return;
            }
            this.adapter.writeByte(b);
        }
    }
}

