/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.annotations.pojo.Embedded;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.pojo.FunctionAction;
import de.mhus.lib.core.pojo.FunctionAttribute;
import de.mhus.lib.core.pojo.PojoModelImpl;
import de.mhus.lib.core.pojo.PojoParser;
import de.mhus.lib.core.pojo.PojoStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;

public class FunctionsStrategy
extends MObject
implements PojoStrategy {
    private boolean embedded;
    private boolean toLower = true;
    private String embedGlue;
    private boolean actionsOnly;
    private Class<? extends Annotation>[] annotationMarker;

    public FunctionsStrategy() {
        this(true, true, ".", false, new Class[0]);
    }

    public FunctionsStrategy(boolean actionsOnly) {
        this(true, true, ".", actionsOnly, new Class[0]);
    }

    public FunctionsStrategy(boolean embedded, boolean toLower, String embedGlue, boolean actionsOnly, Class<? extends Annotation> ... annotationMarker) {
        this.embedded = embedded;
        this.toLower = toLower;
        this.embedGlue = embedGlue;
        this.actionsOnly = actionsOnly;
        this.annotationMarker = annotationMarker;
    }

    @Override
    public void parse(PojoParser parser, Class<?> clazz, PojoModelImpl model) {
        this.parse("", null, parser, clazz, model, 0);
    }

    protected void parse(String prefix, FunctionAttribute<Object> parent, PojoParser parser, Class<?> clazz, PojoModelImpl model, int level) {
        if (level > 10) {
            return;
        }
        for (Method m : this.getMethods(clazz)) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            try {
                String s;
                String mName = m.getName();
                String string = s = this.toLower ? mName.toLowerCase() : mName;
                if (s.startsWith("get") || s.startsWith("set")) {
                    s = s.substring(3);
                } else if (s.startsWith("is")) {
                    s = s.substring(2);
                }
                String name = prefix + s;
                Method getter = null;
                Method setter = null;
                if (mName.startsWith("get")) {
                    mName = mName.substring(3);
                    getter = m;
                    try {
                        setter = clazz.getMethod("set" + mName, getter.getReturnType());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                } else if (mName.startsWith("set")) {
                    mName = mName.substring(3);
                    setter = m;
                    try {
                        getter = clazz.getMethod("get" + mName, new Class[0]);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            getter = clazz.getMethod("is" + mName, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                    }
                } else if (mName.startsWith("is")) {
                    mName = mName.substring(2);
                    getter = m;
                    try {
                        setter = clazz.getMethod("set" + mName, getter.getReturnType());
                    }
                    catch (NoSuchMethodException nsme) {}
                } else {
                    FunctionAction action = new FunctionAction(clazz, m, name, parent);
                    model.addAction(action);
                    continue;
                }
                if (this.actionsOnly || !this.isEmbedded(getter, setter) && !this.isMarker(getter, setter)) continue;
                FunctionAttribute<Object> attr = new FunctionAttribute<Object>(clazz, getter, setter, name, parent);
                if (this.isEmbedded(getter, setter)) {
                    this.parse(prefix + name + this.embedGlue, attr, parser, attr.getType(), model, level + 1);
                    continue;
                }
                if (model.hasAttribute(name)) continue;
                model.addAttribute(attr);
            }
            catch (Exception e) {
                this.log().d(e);
            }
        }
    }

    private boolean isEmbedded(Method getter, Method setter) {
        if (!this.embedded) {
            return false;
        }
        return getter != null && getter.isAnnotationPresent(Embedded.class);
    }

    private boolean isMarker(Method getter, Method setter) {
        if (this.annotationMarker == null || this.annotationMarker.length == 0) {
            return true;
        }
        if (getter != null) {
            for (Class<? extends Annotation> a : this.annotationMarker) {
                if (!getter.isAnnotationPresent(a)) continue;
                return true;
            }
        }
        if (setter != null) {
            for (Class<? extends Annotation> a : this.annotationMarker) {
                if (!setter.isAnnotationPresent(a)) continue;
                return true;
            }
        }
        return false;
    }

    protected LinkedList<Method> getMethods(Class<?> clazz) {
        LinkedList<Method> out = new LinkedList<Method>();
        do {
            for (Method m : clazz.getMethods()) {
                out.add(m);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return out;
    }

    @Override
    public void parseObject(PojoParser parser, Object pojo, PojoModelImpl model) {
        Class<?> clazz = pojo.getClass();
        this.parse(parser, clazz, model);
    }
}

