/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.pojo.DefaultFilter;
import de.mhus.lib.core.pojo.DefaultStrategy;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoFilter;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.core.pojo.PojoModelImpl;
import de.mhus.lib.core.pojo.PojoStrategy;
import java.io.IOException;
import java.lang.annotation.Annotation;

public class PojoParser {
    private PojoModelImpl model;

    public PojoParser parse(Object pojo) {
        return this.parse(pojo, null);
    }

    public PojoParser parse(Object pojo, String embedGlue, Class<? extends Annotation>[] annotationMarker) {
        return this.parse(pojo, new DefaultStrategy(true, embedGlue, annotationMarker));
    }

    public PojoParser parse(Object pojo, PojoStrategy strategy) {
        if (this.model == null) {
            this.model = new PojoModelImpl(pojo.getClass());
        }
        if (strategy == null) {
            strategy = new DefaultStrategy();
        }
        if (pojo instanceof Class) {
            strategy.parse(this, (Class)pojo, this.model);
        } else {
            strategy.parseObject(this, pojo, this.model);
        }
        return this;
    }

    public PojoParser filter(boolean removeHidden, boolean removeEmbedded, boolean removeWriteOnly, boolean removeReadOnly, boolean removeNoActions) {
        return this.filter(new DefaultFilter(removeHidden, removeEmbedded, removeWriteOnly, removeReadOnly, removeNoActions));
    }

    public PojoParser filter(PojoFilter filter) {
        filter.filter(this.model);
        return this;
    }

    public PojoModel getModel() {
        return this.model;
    }

    public static Object checkParent(PojoAttribute<Object> parent, Object pojo) throws IOException {
        Object out = pojo;
        if (parent != null && (out = parent.get(pojo)) == null) {
            try {
                out = parent.getType().newInstance();
                parent.set(pojo, out);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IOException("can't create parent: " + parent.getName(), e);
            }
        }
        return out;
    }
}

