/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.security;

import java.security.Principal;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;

public class MSecurity {
    public static final String USER_CLASS = "UserPrincipal";
    public static final String GROUP_CLASS = "GroupPrincipal";
    public static final String ROLE_CLASS = "RolePrincipal";

    public static Principal getUser(Subject subject) {
        for (Principal p : subject.getPrincipals()) {
            if (!p.getClass().getSimpleName().equals(USER_CLASS)) continue;
            return p;
        }
        return null;
    }

    public static boolean hasGroup(Subject subject, String name) {
        if (name == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!p.getClass().getSimpleName().equals(GROUP_CLASS) || !name.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRole(Subject subject, String name) {
        if (name == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!p.getClass().getSimpleName().equals(ROLE_CLASS) || !name.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public static List<Principal> getGroups(Subject subject) {
        LinkedList<Principal> out = new LinkedList<Principal>();
        for (Principal p : subject.getPrincipals()) {
            if (!p.getClass().getSimpleName().equals(GROUP_CLASS)) continue;
            out.add(p);
        }
        return out;
    }

    public static List<Principal> getRoles(Subject subject) {
        LinkedList<Principal> out = new LinkedList<Principal>();
        for (Principal p : subject.getPrincipals()) {
            if (!p.getClass().getSimpleName().equals(ROLE_CLASS)) continue;
            out.add(p);
        }
        return out;
    }
}

