/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.service;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.lang.MObject;

public class ConfigProvider
extends MLog {
    private IConfig config;

    public ConfigProvider() {
        this.config = new HashConfig();
    }

    public ConfigProvider(IConfig config) {
        this.config = config;
    }

    public ResourceNode getConfig(Object owner, ResourceNode def) {
        if (this.config == null && owner instanceof MObject) {
            this.config = MSingleton.get().getBaseControl().getBaseOf((MObject)owner).lookup(IConfig.class);
        }
        if (this.config != null) {
            ResourceNode cClass;
            String name;
            Class<?> c = null;
            if (owner instanceof String) {
                name = (String)owner;
                cClass = this.config.getNode(name);
                if (cClass != null) {
                    this.log().t("found", name);
                    return cClass;
                }
            } else {
                c = owner instanceof Class ? (Class<?>)owner : owner.getClass();
            }
            while (c != null) {
                name = c.getCanonicalName();
                cClass = this.config.getNode(name);
                if (cClass != null) {
                    this.log().t("found", owner.getClass(), name);
                    return cClass;
                }
                c = c.getSuperclass();
            }
            this.log().t("not found", owner.getClass());
        }
        return def;
    }
}

