/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.strategy.ExecuteStrategy;
import de.mhus.lib.core.strategy.NotSuccessful;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationDescription;
import de.mhus.lib.core.strategy.OperationResult;
import de.mhus.lib.core.strategy.TaskContext;

public class SynchronizedExecuteStrategy
extends ExecuteStrategy {
    private Operation executable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OperationResult doExecute2(TaskContext context) throws Exception {
        SynchronizedExecuteStrategy synchronizedExecuteStrategy = this;
        synchronized (synchronizedExecuteStrategy) {
            if (this.executable == null) {
                return new NotSuccessful(this, "executable not found", -10L);
            }
            this.executable.setBusy(this);
            OperationResult out = this.executable.doExecute(context);
            this.executable.releaseBusy(this);
            return out;
        }
    }

    @Override
    public Operation getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(Operation executable) {
        this.executable = executable;
    }

    @Override
    public OperationDescription getDescription() {
        if (this.executable == null) {
            return null;
        }
        return this.executable.getDescription();
    }

    @Override
    public boolean canExecute(TaskContext context) {
        if (this.executable == null) {
            return false;
        }
        return this.executable.canExecute(context);
    }

    @Override
    public boolean hasAccess() {
        if (this.executable == null) {
            return false;
        }
        return this.executable.hasAccess();
    }
}

