/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FallbackMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;
    private Map<K, V> fall;
    private boolean fro = true;

    public FallbackMap(Map<K, V> map, Map<K, V> fallback, boolean fallbackReadOnly) {
        this.map = map;
        this.fall = fallback;
        this.fro = fallbackReadOnly;
    }

    @Override
    public int size() {
        return Math.max(this.map.size(), this.fall.size());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty() && this.fall.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key) || this.fall.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value) || this.fall.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V ret = this.map.get(key);
        if (ret == null) {
            return this.fall.get(key);
        }
        return ret;
    }

    @Override
    public V put(K key, V value) {
        V ret = this.get(key);
        this.map.put(key, value);
        return ret;
    }

    @Override
    public V remove(Object key) {
        V ret = this.get(key);
        this.map.remove(key);
        if (!this.fro) {
            this.fall.remove(key);
        }
        return ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
        if (!this.fro) {
            this.fall.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

