/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.directory.ClassLoaderResourceProvider;
import de.mhus.lib.core.directory.MResourceProvider;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.lang.Base;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.util.MNls;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;

public class MNlsFactory
extends MObject {
    private ResourceNode config;

    public MNlsFactory() {
        this(null);
    }

    public MNlsFactory(ResourceNode config) {
        this.config = config;
    }

    public MNls create(Object owner) {
        try {
            this.installBase();
            MNls mNls = this.load(null, owner.getClass(), null, null);
            return mNls;
        }
        finally {
            this.leaveBase();
        }
    }

    public MNls load(Class<?> owner) {
        return this.load(null, owner, null, null);
    }

    public MNls load(MResourceProvider<?> res, Class<?> owner, String resourceName, String locale) {
        try {
            if (resourceName == null) {
                resourceName = owner.getCanonicalName().replace('.', '/');
            }
            if (res == null) {
                res = owner != null ? new ClassLoaderResourceProvider(owner.getClassLoader()) : new ClassLoaderResourceProvider();
            }
            if (locale == null) {
                locale = this.getDefaultLocale();
            }
            InputStream is = null;
            Properties properties = new Properties();
            is = ((ResourceNode)res.getResource(locale.toString() + "/" + resourceName + ".properties")).getInputStream();
            if (is == null) {
                is = ((ResourceNode)res.getResource(this.getDefaultLocale() + "/" + resourceName + ".properties")).getInputStream();
            }
            if (is == null) {
                is = ((ResourceNode)res.getResource(resourceName + ".properties")).getInputStream();
            }
            if (is != null) {
                this.log().t("Load Resource", resourceName, locale);
                InputStreamReader r = new InputStreamReader(is, "UTF-8");
                properties.load(r);
                is.close();
            } else {
                this.log().d("Resource not found", resourceName, locale);
            }
            return new MNls(properties, "");
        }
        catch (Exception e) {
            this.log().i(e);
            return new MNls();
        }
    }

    public String getDefaultLocale() {
        return Locale.getDefault().toString();
    }

    public MNls load(InputStream is) {
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            this.log().i(e);
        }
        return new MNls(properties, "");
    }

    public static MNlsFactory lookup(Object owner) {
        Base base = Base.lookup(owner);
        if (base != null) {
            return base.lookup(MNlsFactory.class);
        }
        return null;
    }
}

