/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.util.Util;
import java.util.Date;

public class ColorOption {
    public static CmsObservation obs0 = (CmsObservation)ThemisApplication.getInstance().getProject().getDefaultElement("observation");
    public static CmsLocation loc0 = (CmsLocation)ThemisApplication.getInstance().getProject().getDefaultElement("location");
    public static Integer BLUE = -16776961;
    public static Integer LIGHT_GRAY = -4144960;
    public static Integer red = -50384;
    public static Integer lightred = -21591;
    public static Integer green = -11150484;
    public static Integer lightgreen = -4591422;
    public static Integer yellow = -10703;
    public static Integer lightyellow = -4438;
    public static Integer orange = -27392;
    public static Integer lightorange = -9302;
    public static Integer brown = -4947376;
    public static Integer lightbrown = -2902118;
    public static Integer darkblue = -16745729;
    public static Integer blue = -13525505;
    public static Integer lightblue = -5582081;
    public static Integer gray = -6250336;
    public static Integer lightgray = -3618616;
    public static Integer white = -1;
    public static Integer black = -16119286;
    Method method;
    ThemisAttribute ta;
    Keytable tbl;
    Integer backgroundColor;
    Integer foregroundColor;
    String display;

    public ColorOption(String lbl, ThemisAttribute ta) {
        if ("done".equals(ta.getId())) {
            this.method = Method.STATUS;
        } else if ("duedate".equals(ta.getId())) {
            this.method = Method.URGGENCY;
        } else {
            this.method = Method.ATTRIBUTE;
            this.ta = ta;
            this.tbl = ThemisApplication.getInstance().getProject().getKeytable(ta.getCmsCode());
        }
        this.display = lbl;
    }

    public ColorOption(String lbl) {
        this.method = Method.NOCOLOR;
        this.display = lbl;
    }

    public ColorOption(String lbl, Integer color) {
        this.method = color == null ? Method.NOCOLOR : Method.STATIC;
        this.backgroundColor = color;
        this.display = lbl;
    }

    public void update(ColorOption co) {
        this.method = co.method;
        this.backgroundColor = co.backgroundColor;
        this.display = co.display;
        this.ta = co.ta;
        this.tbl = co.tbl;
    }

    public void setColor(Integer c) {
        this.backgroundColor = c;
    }

    public void setForegroundColor(Integer c) {
        this.foregroundColor = c;
    }

    public Method getMethod() {
        return this.method;
    }

    public ThemisAttribute getAttribute() {
        return this.ta;
    }

    public Integer getStaticColor() {
        return this.backgroundColor == null ? blue : this.backgroundColor;
    }

    public Integer getStaticForegroundColor() {
        return this.foregroundColor == null ? white : this.foregroundColor;
    }

    public Integer getColor(CmsLocation loc, CmsObservation obs) {
        switch (this.method) {
            case NOCOLOR: {
                return null;
            }
            case STATIC: {
                return this.backgroundColor;
            }
            case URGGENCY: {
                if (obs == null) {
                    return null;
                }
                Date dt = obs.getDateAttribute("duedate").getDate();
                Date refDate = ThemisApplication.getInstance().getAppointmentInfoDate();
                boolean isDue = dt == null ? true : dt.before(refDate);
                boolean isOverdue = dt == null ? false : dt.before(new Date());
                int colorlevel = ThemisColors.getObservationColorLevel((int)obs.getKeyAttribute("type").getId(), obs.isControlledInCurrentEvent(), obs.isDone(), isDue, isOverdue);
                switch (colorlevel) {
                    case 0: {
                        return green;
                    }
                    case 1: {
                        return yellow;
                    }
                    case 2: {
                        return lightred;
                    }
                }
                return null;
            }
            case STATUS: {
                if (obs == null) {
                    return null;
                }
                long obsType = obs.getKeyAttribute("type").getId();
                if (obsType == 2L || obsType == 3L) {
                    return null;
                }
                if (obs.isDone()) {
                    return green;
                }
                return red;
            }
            case ATTRIBUTE: {
                KeyAttribute att = null;
                switch (this.ta.getTarget()) {
                    case OBSERVATION: {
                        att = obs == null ? null : obs.getKeyAttribute(this.ta.getCmsCode());
                        break;
                    }
                    case LOCATION: {
                        KeyAttribute keyAttribute = att = loc == null ? null : loc.getKeyAttribute(this.ta.getCmsCode());
                    }
                }
                if (att == null) break;
                Integer color = att.getKeytable().getColor(att.getId());
                return color;
            }
        }
        return null;
    }

    public Integer getColor(DataRecord rec) {
        Integer bg = rec.getInt("colorbackground");
        if (bg != null) {
            return bg;
        }
        switch (this.method) {
            case NOCOLOR: {
                return null;
            }
            case STATIC: {
                return this.backgroundColor;
            }
            case URGGENCY: {
                int colorlevel = rec.getInt("colorlevel", Integer.valueOf(0));
                switch (colorlevel) {
                    case 1: {
                        return yellow;
                    }
                    case 2: {
                        return red;
                    }
                }
                return lightgray;
            }
            case STATUS: {
                if (rec.isEmpty("done")) {
                    return lightgray;
                }
                if (rec.getBoolean("done").booleanValue()) {
                    return green;
                }
                return red;
            }
            case ATTRIBUTE: {
                Keytable keytable = null;
                if (this.ta.getTypeId() == ThemisAttribute.Type.LIST) {
                    Long id = rec.getLong(this.ta.getSqlCode() + "id", Long.valueOf(-1L));
                    switch (this.ta.getTarget()) {
                        case OBSERVATION: {
                            keytable = obs0.getKeyAttribute(this.ta.getCmsCode()).getKeytable();
                            break;
                        }
                        case LOCATION: {
                            keytable = loc0.getKeyAttribute(this.ta.getCmsCode()).getKeytable();
                        }
                    }
                    if (id == null || id < 0L || keytable == null) {
                        return lightgray;
                    }
                    Integer ccc = keytable.getColor(id.longValue());
                    return ccc;
                }
                return lightgray;
            }
        }
        return null;
    }

    public Integer getForegroundColor(CmsLocation loc, CmsObservation obs) {
        switch (this.method) {
            case NOCOLOR: {
                return black;
            }
            case STATIC: {
                return this.foregroundColor;
            }
            case URGGENCY: 
            case STATUS: 
            case ATTRIBUTE: {
                return ThemisApplication.getInstance().getColorManager().isBright(this.getColor(loc, obs)) ? black : white;
            }
        }
        return black;
    }

    public Integer getForegroundColor(DataRecord rec) {
        switch (this.method) {
            case NOCOLOR: {
                return black;
            }
            case STATIC: {
                return this.foregroundColor;
            }
            case URGGENCY: 
            case STATUS: 
            case ATTRIBUTE: {
                Integer cInt = this.getColor(rec);
                if (cInt == null) {
                    return black;
                }
                return ThemisApplication.getInstance().getColorManager().isBright(cInt) ? black : white;
            }
        }
        return black;
    }

    public static Integer getForegroundColor(int bgcolor) {
        return ThemisApplication.getInstance().getColorManager().isBright(bgcolor) ? black : white;
    }

    public String toString() {
        return this.display;
    }

    public static ColorOption fromString(String co) {
        ColorOption coNew;
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (co == null) {
            return new ColorOption(project.getResourceText("ColorOption.none"));
        }
        String[] colors = co.split("#");
        Integer bgColor = null;
        Integer txtColor = null;
        if (colors.length >= 2) {
            bgColor = Util.parseInt((String)colors[1], (int)-1);
        }
        if (colors.length >= 3) {
            txtColor = Util.parseInt((String)colors[2], (int)-1);
        }
        String[] split = colors[0].split(":");
        ThemisAttribute ta = null;
        switch (split[0].toLowerCase()) {
            case "static": {
                Integer c = "null".equals(split[1]) ? null : Integer.valueOf(Util.parseInt((String)split[1], (int)-1));
                ColorOption coNew2 = new ColorOption(project.getResourceText("ColorOption.static"), c);
                if (split.length > 2) {
                    c = "null".equals(split[2]) ? null : Integer.valueOf(Util.parseInt((String)split[2], (int)-1));
                    coNew2.setForegroundColor(c);
                }
                return coNew2;
            }
            case "status": {
                ta = app.getSettings().getObservationAttribute("done");
                coNew = new ColorOption(project.getResourceText("ColorOption.status"), ta);
                break;
            }
            case "urgency": {
                ta = app.getSettings().getObservationAttribute("duedate");
                coNew = new ColorOption(project.getResourceText("ColorOption.urgency"), ta);
                break;
            }
            case "attribute": {
                ta = null;
                String preLabel = "?";
                if (split.length == 1 || split[1].equalsIgnoreCase("null")) {
                    coNew = new ColorOption(project.getResourceText("ColorOption.none"));
                    break;
                }
                String[] att = split[1].split("\\.");
                switch (att[0]) {
                    case "observation": {
                        ta = app.getSettings().getObservationAttribute(att[1]);
                        preLabel = "B.";
                        break;
                    }
                    case "location": {
                        ta = app.getSettings().getLocationAttribute(att[1]);
                        preLabel = "G.";
                    }
                }
                if (ta == null) {
                    coNew = new ColorOption(project.getResourceText("ColorOption.none"));
                    break;
                }
                coNew = new ColorOption(preLabel + ta.getLabel(), ta);
                break;
            }
            default: {
                coNew = new ColorOption(project.getResourceText("ColorOption.none"));
            }
        }
        if (bgColor != null) {
            coNew.setColor(bgColor);
        }
        if (txtColor != null) {
            coNew.setForegroundColor(txtColor);
        }
        return coNew;
    }

    public String toStringDefinition() {
        String staticColor = "#" + this.getStaticColor() + "#" + this.getStaticForegroundColor();
        if (this.getMethod() == Method.NOCOLOR) {
            return "none" + staticColor;
        }
        switch (this.getMethod()) {
            case STATIC: {
                return "static:" + this.getStaticColor() + ":" + this.getStaticForegroundColor() + staticColor;
            }
            case STATUS: {
                return "status" + staticColor;
            }
            case ATTRIBUTE: {
                ThemisAttribute ta = this.getAttribute();
                return "attribute:" + (ta == null ? "null" : ta.getTargetCode() + "." + ta.getId()) + staticColor;
            }
            case URGGENCY: {
                return "urgency" + staticColor;
            }
        }
        return "none" + staticColor;
    }

    public static int getColorFromString(String c) {
        return ThemisApplication.getInstance().getColorManager().getColorFromString(c);
    }

    public boolean equals(Object o) {
        if (o instanceof ColorOption) {
            return this.toStringDefinition().equals(((ColorOption)o).toStringDefinition());
        }
        return false;
    }

    public static enum Method {
        NOCOLOR,
        STATIC,
        STATUS,
        ATTRIBUTE,
        URGGENCY;

    }
}

