/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.Dimension;
import at.grid.util.NumberRange;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PlanManager {
    ThemisApplication app;
    ThemisProject project;

    public PlanManager(ThemisApplication app, ThemisProject project) {
        this.app = app;
        this.project = project;
    }

    public CmsPlan addNewPlanVersion(CmsPlan p, File planFile, String pagenumbers, CmsPlan.Papersize papersize, int customLongSideMM) throws IOException {
        File fImage = new File(ThemisApplication.getInstance().getProject().getTempfileLocation(), Util.getFileNameWithoutExtension((File)planFile) + ".jpg");
        if (fImage.isFile()) {
            this.project.getFileAccess().delete(fImage);
        }
        BufferedImage bi = null;
        File fPdf = null;
        if (planFile.getName().toLowerCase().endsWith(".pdf")) {
            NumberRange pages;
            if (pagenumbers == null || "".equals(pagenumbers)) {
                pagenumbers = "1";
            }
            if (!(pages = new NumberRange(pagenumbers)).isSingle()) {
                this.app.getDialog().showWarningDialog("Nur einzelne Seite k\u00f6nnen als Planversion hinzugf\u00fcgt werden.");
                return p;
            }
            ArrayList<File> planFiles = PlanManager.extractPdfPages(planFile, pagenumbers);
            if (planFiles == null || planFiles.isEmpty()) {
                return p;
            }
            fPdf = planFiles.get(0);
            bi = PlanManager.convertPdfToImage(PDDocument.load((File)fPdf), papersize, customLongSideMM);
        } else if (!this.isMaxNumberOfPlansReached()) {
            bi = ImageIO.read(planFile);
            int widthPx = PlanManager.getImageWidthPx(papersize, customLongSideMM, new Dimension(bi.getWidth(), bi.getHeight()));
            bi = Util.resizeImage((BufferedImage)bi, (int)widthPx);
        }
        if (bi != null) {
            ImageIO.write((RenderedImage)bi, "jpg", fImage);
            p.addPlanFile(fImage, fPdf, new Dimension(bi.getWidth(), bi.getHeight()), new Date());
        }
        p.save();
        return p;
    }

    public ArrayList<Long> createNewPlanElements(ArrayList<File> planfiles, long idBuilding, CmsPlan.Papersize papersize, int customLongSideMM, ProgressHandler ph) throws IOException {
        ArrayList<Long> ids = new ArrayList<Long>();
        int countPlan = planfiles.size();
        if (countPlan == 0) {
            return ids;
        }
        int counter = 0;
        int failedCount = 0;
        String failedPlans = "";
        for (File f : planfiles) {
            if (PlanManager.isValidPlanfile(f)) {
                try {
                    ArrayList<Long> newPlanIds = this.createNewPlanElements(f, null, null, idBuilding, papersize, customLongSideMM, ph);
                    ids.addAll(newPlanIds);
                }
                catch (Exception ex) {
                    if (!failedPlans.isEmpty()) {
                        failedPlans = failedPlans + ", ";
                    }
                    failedPlans = failedPlans + f.getName();
                    ++failedCount;
                }
            }
            ++counter;
        }
        if (!failedPlans.isEmpty()) {
            if (failedCount == 1) {
                this.app.getDialog().showErrorDialog(MessageFormat.format(this.project.getResourceText("error.plan.loading"), failedPlans));
            } else {
                this.app.getDialog().showErrorDialog(MessageFormat.format(this.project.getResourceText("error.plans.loading"), failedPlans));
            }
        }
        return ids;
    }

    public ArrayList<Long> createNewPlanElements(File planFile, String pagenumbers, String title, long idBuilding, CmsPlan.Papersize papersize, int customLongSideMM, ProgressHandler ph) throws IOException {
        int widthPx;
        BufferedImage bi;
        CmsPlan newPlan;
        ArrayList<Long> planIds = new ArrayList<Long>();
        if (planFile == null || !planFile.isFile()) {
            return planIds;
        }
        if (planFile.getName().toLowerCase().endsWith(".pdf")) {
            ArrayList<File> planFiles = PlanManager.extractPdfPages(planFile, pagenumbers);
            for (File p : planFiles) {
                if (!this.isMaxNumberOfPlansReached()) {
                    BufferedImage bi2;
                    CmsPlan newPlan2 = this.createNewPlanElement(title == null ? Util.getFileNameWithoutExtension((File)p) : title, idBuilding, bi2 = PlanManager.convertPdfToImage(PDDocument.load((File)p), papersize, customLongSideMM), p.getName(), p);
                    if (newPlan2 == null) continue;
                    planIds.add(newPlan2.getId());
                    continue;
                }
                break;
            }
        } else if (!this.isMaxNumberOfPlansReached() && (newPlan = this.createNewPlanElement(title, idBuilding, Util.resizeImage((BufferedImage)(bi = ImageIO.read(planFile)), (int)(widthPx = PlanManager.getImageWidthPx(papersize, customLongSideMM, new Dimension(bi.getWidth(), bi.getHeight())))), planFile.getName(), null)) != null) {
            planIds.add(newPlan.getId());
        }
        return planIds;
    }

    public CmsPlan createNewPlanElement(String title, long idBuilding, BufferedImage image, String filename, File fPdf) throws IOException {
        File fImage = new File(ThemisApplication.getInstance().getProject().getTempfileLocation(), Util.getFileNameWithoutExtension((File)new File(filename)) + ".jpg");
        if (fImage.isFile()) {
            this.project.getFileAccess().delete(fImage);
        }
        CmsPlan plan = this.project.createPlan(idBuilding);
        if (title == null || "".equals(title.trim())) {
            title = Util.getFileNameWithoutExtension((File)fImage);
        }
        plan.setAttributeValue("title", title);
        ImageIO.write((RenderedImage)image, "jpg", fImage);
        plan.addPlanFile(fImage, fPdf, new Dimension(image.getWidth(), image.getHeight()), new Date());
        if (idBuilding > 0L) {
            plan.getRelationAttribute("building").set(idBuilding);
        } else {
            plan.getRelationAttribute("building").clear();
        }
        plan.save();
        return plan;
    }

    public static ArrayList<File> extractPdfPages(File planFile, String pagenumbers) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        NumberRange pages = pagenumbers == null || "".equals(pagenumbers) ? null : new NumberRange(pagenumbers);
        PDDocument doc = PDDocument.load((File)planFile);
        int pageCount = doc.getNumberOfPages();
        boolean singlePage = pageCount == 1;
        for (int page = 0; page < pageCount; ++page) {
            if (pages != null && !pages.containsNumber(page + 1)) continue;
            String fn = Util.getFileNameWithoutExtension((File)planFile) + (singlePage ? "" : "_" + (page + 1)) + ".pdf";
            files.add(PlanManager.getSinglePageAsPdf(doc, page, fn));
        }
        return files;
    }

    public static File getSinglePageAsPdf(PDDocument pdfDoc, int page, String filename) throws IOException {
        PDDocument doc2 = new PDDocument();
        doc2.addPage(pdfDoc.getPage(page));
        File filePdf = new File(ThemisApplication.getInstance().getProject().getTempfileLocation(), filename);
        doc2.save(filePdf);
        doc2.close();
        return filePdf;
    }

    public static BufferedImage convertPdfToImage(PDDocument pdfDoc, CmsPlan.Papersize papersize, int customLongSideMM) throws IOException {
        PDFRenderer pdfRenderer = new PDFRenderer(pdfDoc);
        PDPage pdfPage = pdfDoc.getPage(0);
        Dimension pageSize = PlanManager.getPageSize(pdfPage);
        boolean isLandscape = pageSize.width >= pageSize.height;
        int widthMM = PlanManager.getImageWidth(papersize, customLongSideMM, pageSize);
        float dpi = 300 * widthMM / pageSize.getWidth();
        BufferedImage image = pdfRenderer.renderImageWithDPI(0, dpi, ImageType.RGB);
        pdfDoc.close();
        return image;
    }

    public static boolean isValidPlanfile(File f) {
        if (f == null || !f.isFile()) {
            return false;
        }
        String fileext = Util.getFileExtension((File)f).toLowerCase();
        return "jpg".equals(fileext) || "png".equals(fileext) || "pdf".equals(fileext);
    }

    public static int getImageWidth(CmsPlan.Papersize papersize, int customLongSideMM, Dimension pageDim) {
        boolean isLandscape = pageDim.width >= pageDim.height;
        switch (papersize) {
            case PDF: {
                return pageDim.getWidth();
            }
            case Custom: {
                int targetWidth;
                int n = targetWidth = isLandscape ? customLongSideMM : pageDim.getHeight() * customLongSideMM / pageDim.getWidth();
                if (targetWidth <= 0) {
                    targetWidth = pageDim.getWidth();
                }
                return targetWidth;
            }
        }
        return isLandscape ? papersize.getHeight() : papersize.getWidth();
    }

    public static int getImageWidthPx(CmsPlan.Papersize papersize, int customLongSideMM, Dimension pageDim) {
        int widthMM = PlanManager.getImageWidth(papersize, customLongSideMM, pageDim);
        return (int)((float)(widthMM * 300) / 25.4f);
    }

    public static Dimension getPageSize(PDPage page) {
        PDRectangle mediabox = page.getMediaBox();
        PDRectangle cropbox = page.getCropBox();
        PDRectangle trimbox = page.getTrimBox();
        PDRectangle box = trimbox;
        if (box == null) {
            box = cropbox;
        }
        if (box == null) {
            box = mediabox;
        }
        int pageSizeWidthMM = Math.round(25.4f * box.getWidth() / 72.027f);
        int pageSizeHeightMM = Math.round(25.4f * box.getHeight() / 72.027f);
        if (page.getRotation() == 90 || page.getRotation() == 270) {
            pageSizeWidthMM = Math.round(25.4f * box.getHeight() / 72.027f);
            pageSizeHeightMM = Math.round(25.4f * box.getWidth() / 72.027f);
        }
        return new Dimension(pageSizeWidthMM, pageSizeHeightMM);
    }

    public static Dimension getPageSize(CmsPlan.Papersize selectedPaperSize, int customWidthMM, float imageRatio) {
        switch (selectedPaperSize) {
            case PDF: 
            case Custom: {
                return new Dimension(customWidthMM, (int)((float)customWidthMM / imageRatio));
            }
        }
        int pageWidth = selectedPaperSize.getWidth();
        int pageHeight = selectedPaperSize.getHeight();
        if (imageRatio > 0.0f) {
            if (imageRatio > 1.0f) {
                pageWidth = selectedPaperSize.getHeight();
            }
            pageHeight = (int)((float)pageWidth / imageRatio);
        }
        return new Dimension(pageWidth, pageHeight);
    }

    public boolean isMaxNumberOfPlansReached() {
        int currentCount;
        int maxCount = 99999;
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.APP)) {
            maxCount = 15;
        }
        return (currentCount = this.project.getPlans().size()) >= maxCount;
    }
}

