/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class SelectionManager {
    ThemisProject project;
    ThemisApplication app;
    private final ArrayList<Long> selectedObservationIds = new ArrayList();
    private final ArrayList<Long> selectedLocationIds = new ArrayList();
    private boolean selectAll = false;
    private CmsPlan currentPlan = null;
    private CmsEvent currentEvent;

    public SelectionManager(ThemisApplication a, ThemisProject p) {
        this.app = a;
        this.project = p;
    }

    public void reset(boolean trigger, Object source) {
        this.clearCurrentEvent();
        this.clearCurrentPlan();
        this.clearSelection(trigger, source);
    }

    public long getCurrentPlanId() {
        return this.currentPlan == null ? -1L : this.currentPlan.getId();
    }

    public CmsPlan getCurrentPlan() {
        return this.currentPlan;
    }

    public void setCurrentPlan(long id, boolean trigger, Object source) {
        this.currentPlan = (CmsPlan)this.project.loadElement(id, this.project.getUser());
        this.project.setProjectProperty("project.plan.loaded", String.valueOf(id));
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.PLAN_SELECTED.from(source, "current plan set"));
        }
    }

    public void clearCurrentPlan() {
        this.currentPlan = null;
    }

    public long getCurrentEventId() {
        return this.currentEvent == null ? -1L : this.currentEvent.getId();
    }

    public CmsEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(long id, boolean trigger, Object source) {
        this.project.getLogger().info("trying to load event with ID=" + id);
        CmsEvent e = (CmsEvent)this.project.loadElement(id, this.project.getUser());
        if (e == null) {
            this.project.getLogger().info("set current event to ID=" + (e == null ? "NONE" : Long.valueOf(e.getId())) + " from " + (source == null ? "undefined" : source.getClass().getName()));
            this.clearCurrentEvent();
        } else {
            this.setCurrentEvent(e, trigger, source);
        }
    }

    public void setCurrentEvent(CmsEvent e, boolean trigger, Object source) {
        this.setCurrentEvent(e, trigger, false, source);
    }

    public void setCurrentEvent(CmsEvent e, boolean trigger, boolean silent, Object source) {
        if (this.currentEvent != null && this.currentEvent.equalsId((Object)e)) {
            return;
        }
        if (e != null && !e.isNew()) {
            Date dt0 = new Date();
            String today = Util.formatDate((Date)dt0, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone());
            String eventdate = Util.formatDate((Date)e.getEventDate(), (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone());
            if (dt0.after(e.getEventDate()) && !today.equals(eventdate) && !silent && !this.app.getDialog().showConfirmDialog("Das ausgew\u00e4hlte Ereignis liegt in der Vergangenheit. Sind Sie sicher, dass Sie dieses Ereignis weiter bearbeiten wollen? Falls nein, legen Sie ein neues Ereignis an.", "Ereignis in der Vergangenheit")) {
                e = null;
            }
        }
        this.currentEvent = e;
        this.project.getLogger().info("set current event to ID=" + (e == null ? "NONE" : Long.valueOf(e.getId())) + " from " + (source == null ? "undefined" : source.getClass().getName()));
        if (e != null && !e.isSigned()) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(e.getDateAttribute("date").getDate());
            int year = cal.get(1);
            if (!this.project.yearsForStatistics.contains(year)) {
                this.project.yearsForStatistics.add(year);
            }
            this.app.getSettings().setLastEventId(e.getId());
        }
        this.project.createActionLog("event_setactive", e == null ? -1L : e.getId(), "");
        this.app.getFilter().resetSearchResult();
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.EVENT_SET_AS_CURRENT.from(source, "current event set"));
        }
    }

    public void clearCurrentEvent() {
        this.project.getLogger().info("cleared current event, no current event defined");
        this.currentEvent = null;
    }

    public void updateCurrentEvent() {
        if (this.currentEvent != null) {
            this.currentEvent.reload();
        }
    }

    public void setSelectAll(boolean trigger, Object source) {
        this.selectAll = true;
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source, "selected all"));
        }
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelection(List<Long> idLocations, List<Long> idObservations, boolean trigger, Object source) {
        this.clearSelection(false, null);
        if (idLocations != null) {
            this.selectedLocationIds.addAll(idLocations);
        }
        if (idObservations != null) {
            this.selectedObservationIds.addAll(idObservations);
        }
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source, "selected list"));
        }
    }

    public void setSelection(long idLocation, long idObservation, boolean trigger, Object source) {
        this.clearSelection(false, null);
        if (idLocation >= 0L) {
            this.selectedLocationIds.add(idLocation);
        }
        if (idObservation >= 0L) {
            this.selectedObservationIds.add(idObservation);
        }
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source, "selected single"));
        }
    }

    public void setSelectedObservation(long idObservation, boolean trigger, Object source) {
        long locId = this.project.getDatastorage().getRelationIdsFromFirst(idObservation, "locationobservation", false);
        this.setSelection(locId, idObservation, trigger, source);
    }

    public void setSelectedObservations(List<Long> ids, boolean trigger, Object source) {
        this.clearSelection(false, source);
        this.selectedObservationIds.addAll(ids);
        ArrayList locIds = this.project.getDatastorage().getRelationIds(ids, "locationobservation", false);
        this.selectedLocationIds.addAll(locIds);
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
        }
    }

    public void setSelectedLocation(long idLocation, boolean trigger, Object source) {
        ArrayList obsIds = this.project.getDatastorage().getRelationIdsTo(idLocation, "locationobservation", false);
        if (this.selectedObservationIds.size() == 1 && obsIds.contains(this.selectedObservationIds.get(0))) {
            this.selectedLocationIds.clear();
            this.selectedLocationIds.add(idLocation);
            if (trigger) {
                this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
            }
        } else {
            long obsId = obsIds.isEmpty() ? -1L : (Long)obsIds.get(0);
            this.setSelection(idLocation, obsId, trigger, source);
        }
    }

    public void setSelectedLocations(List<Long> ids, boolean trigger, Object source) {
        this.clearSelection(false, source);
        if (!ids.isEmpty()) {
            this.selectedLocationIds.addAll(ids);
            for (long id : ids) {
                long obsId = this.project.getDatastorage().getRelationIdsToFirst(id, "locationobservation", false);
                if (obsId < 0L) continue;
                this.selectedObservationIds.add(obsId);
                break;
            }
        }
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
        }
    }

    public void clearSelection(boolean trigger, Object source) {
        this.selectedLocationIds.clear();
        this.selectedObservationIds.clear();
        this.selectAll = false;
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
        }
    }

    public boolean hasSelectedObservationIds() {
        return !this.selectedObservationIds.isEmpty();
    }

    public ArrayList<Long> getSelectedObservationIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.addAll(this.selectedObservationIds);
        return ids;
    }

    public boolean hasSelectedLocationIds() {
        return !this.selectedLocationIds.isEmpty();
    }

    public ArrayList<Long> getSelectedLocationIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.addAll(this.selectedLocationIds);
        return ids;
    }

    public void addSelectedLocation(long id, boolean trigger, Object source) {
        this.selectedLocationIds.add(id);
        if (this.selectedObservationIds.isEmpty()) {
            long obsId = this.project.getDatastorage().getRelationIdsToFirst(id, "locationobservation", false);
            this.selectedObservationIds.add(obsId);
        }
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
        }
    }

    public void removeSelectedLocation(long id, boolean trigger, Object source) {
        this.selectedLocationIds.remove(id);
        Iterator iterator = this.project.getDatastorage().getRelationIdsTo(id, "locationobservation", false).iterator();
        while (iterator.hasNext()) {
            long obsId = (Long)iterator.next();
            this.selectedObservationIds.remove(obsId);
        }
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
        }
    }

    public void addSelectedObservation(long id, boolean trigger, Object source) {
        long locId = this.project.getDatastorage().getRelationIdsFromFirst(id, "locationobservation", false);
        this.selectedObservationIds.add(id);
        if (!this.selectedLocationIds.contains(locId)) {
            this.selectedLocationIds.add(locId);
        }
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
        }
    }

    public void removeSelectedObservation(long id, boolean trigger, Object source) {
        this.selectedObservationIds.remove(id);
        if (trigger) {
            this.app.getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from(source));
        }
    }
}

