/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.OntologyFileAccess;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsUser;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ActionProvider;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.api.ColorManager;
import at.grid.themis.ontology.api.OntologyGUImanager;
import at.grid.themis.ontology.api.OntologyImageHandler;
import at.grid.themis.ontology.communication.ThemisDefaultDialog;
import at.grid.themis.ontology.communication.ThemisDialog;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.interfaces.AwtColorManager;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.LoggerProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h2.tools.Recover;
import org.h2.tools.RunScript;
import org.jdom.JDOMException;
import org.openide.util.Exceptions;

public class ThemisApplication {
    public static final String CONF_LANGUAGE = "system.language";
    public static final String CONF_CURRENTFOLDER = "file.currentfolder";
    public static final String CONF_LASTPROJECT = "file.lastproject";
    public static final String CONF_FILEFOLDER = "file.filefolder";
    public static final String CONF_LAST_SYSTEM_START = "file.systemid";
    public static final String CONF_TEMPLATE_PROTOCOL = "file.templateprotocol";
    public static final String CONF_TEMPLATE_LOCATION_OBSERVATION = "file.templatelocationobservation";
    public static final String CONF_TEMPLATE_CHK_BOX = "file.templatechkbox";
    public static final String CONF_UNPACK_FOLDER = "file.unpackfolder";
    public static final String CONF_EXPORT_FOLDER = "file.exportfolder";
    public static final String CONF_EXPORT_FOLDER_KUBUS360 = "file.exportfolderkubus360";
    public static final String CONF_EMAIL_FOLDER_THYSSEN = "file.emailfolderthyssen";
    public static final String CONF_DOCUMENT_IMPORT_FOLDER = "file.documentimportfolder";
    public static final String CONF_PICTURE_IMPORT_FOLDER = "file.pictureimportfolder";
    public static final String CONF_ICON_IMPORT_FOLDER = "file.pictureimportfolder";
    public static final String CONF_PLAN_LONGSIDE = "file.planlongside";
    public static final String CONF_LOGOFILE = "company.logo";
    public static final String CONF_COMPANYNAME = "company.name";
    public static final String CONF_IMAGE_SYNC_DELTA = "image.sync.delta";
    public static final String CONF_ICON_POINT = "display.icon.point";
    public static final String CONF_ICON_POINTSEL = "display.icon.pointsel";
    public static final String CONF_ICON_POINTINACTIVE = "display.icon.pointinactive";
    public static final String CONF_ATTRIBUTE_VISIBILITY = "observationtable.column";
    public static final String CONF_CHECKLIST_ATTRIBUTES = "checklist.display";
    public static final String CONF_OBSERVATIONLIST_ATTRIBUTES = "observationtable.display";
    public static final String CONF_ATTRIBUTE_TABLE = "observationtable.attribute";
    public static final String CONF_DIALOG_SIZE = "dialog.#.size";
    public static final String CONF_DIALOG_LOCATION = "dialog.#.location";
    public static final String CONF_DISPLAY_LABEL = "display.label";
    public static final String CONF_DISPLAY_HIDEDONE = "display.hidedone";
    public static final String CONF_DISPLAY_TRANSPARENCY = "display.transparency";
    public static final String CONF_TIME_ZONE = "system.timezone";
    public static final String CONF_RECENTPROJECT = "system.lastproject";
    public static final String CONF_FILE_SINGLECLICK = "file.singlecklick";
    public static final String CONF_SHOW_NOTIFICATION = "display.notification";
    public static final String CONF_SHOW_NOTIFICATION_EVENT = "display.notification.event";
    public static final String CONF_SHOW_NOTIFICATION_APPOINTMENT = "display.notification.appointment";
    public static final String CONF_SHOW_NOTIFICATION_APPOINTMENT_COUNT = "display.notification.count";
    public static final String CONF_SHOW_NOTIFICATION_APPOINTMENT_REPEAT = "display.notification.repeat";
    public static final String CONF_LOC_TEMPLATE_ID = "loc.last.used.locationtemplate";
    public static final String CONF_EMAIL_SYNC_ENABLED = "system.email.sync.enabled";
    public static final String CONF_NOTIFICATION_DUEDATE = "duedate";
    public static final String CONF_NOTIFICATION_NOEVENT = "noevent";
    public static final String CONF_NOTIFICATION_NOSTARTSCREEN = "dontshowstartscreen";
    public static final String SHOW_LOC_QUANTITY = "locQuantity";
    public static final String SHOW_LOC_LIST1 = "locList1";
    public static final String SHOW_LOC_LIST2 = "locList2";
    public static final String SHOW_LOC_CODE1 = "locCode1";
    public static final String SHOW_LOC_CODE2 = "locCode2";
    public static final String SHOW_LOC_DOCUMENT = "locDocument";
    public static final String SHOW_LOC_ICON = "locIcon";
    public static final String SHOW_LOC_GROUP = "locGroup";
    public static final String SHOW_LOC_DIMENSION = "locDimension";
    public static final String SHOW_LOC_PREFIXSUFFIX = "locPrefixSuffix";
    public static final String SHOW_LOC_BARCODE = "locBarcode";
    public static final String SHOW_OBS_EDITOR = "editor";
    public static final String SHOW_OBS_REFERENCEDATE = "referencedate";
    public static final String SHOW_OBS_DUEDATE = "duedate";
    public static final String SHOW_OBS_STATUS = "done";
    public static final String SHOW_OBS_CONTACT = "contactname";
    public static final String SHOW_OBS_PRIORITY = "priority";
    public static final String SHOW_OBS_TOPIC = "topic";
    public static final String SHOW_OBS_OBSERVATIONTYPE = "observationtype";
    public static final String SHOW_OBS_CODE1 = "obsCode1";
    public static final String SHOW_OBS_FREETEXT1 = "freetext1";
    public static final String SHOW_OBS_FREETEXT2 = "freetext2";
    public static final String SHOW_OBS_FREETEXT3 = "freetext3";
    public static final String SHOW_OBS_LANGTEXT1 = "langtext1";
    public static final String SHOW_OBS_LANGTEXT2 = "langtext2";
    public static final String SHOW_OBS_QUANTITY = "quantity";
    public static final String SHOW_OBS_MEASURE = "measure";
    public static final String SHOW_OBS_DOCUMENT = "document";
    public static final String SHOW_OBS_RISK = "risk";
    public static final String VIEW_TREE_EXPLORER = "system.tree.explorer";
    public static final String VIEW_TREE_MAP = "system.tree.plan";
    public static final String VIEW_TREE_TEMPLATES = "system.tree.template";
    public static final String CONF_UPDATE_LASTCHECK = "system.update.lastcheck";
    public static final String CONF_UPDATE_SOURCE = "system.update.source";
    public static final String CONF_UPDATE_SOURCE_SELECTION = "system.update.source.selection";
    public static final String CONF_EMAIL_SMTP = "system.email.smtp";
    public static final String CONF_EMAIL_FROM = "system.email.from";
    public static final String CONF_EMAIL_PORT = "system.email.port";
    public static final String CONF_EMAIL_ENCRYPT = "system.email.encrypt";
    public static final String CONF_EMAIL_IMAP = "system.email.imap";
    public static final String CONF_EMAIL_IMAP_PORT = "system.email.imap.port";
    public static final String CONF_EMAIL_IMAP_ENCRYPT = "system.email.imap.encrypt";
    public static final String CONF_SYSTEM_RAM = "system.system.ram";
    public static final String CONF_SYSTEM_USE_INTEGRATED_JAVA = "system.system.useInegratedJava";
    public static final String CONF_PROJECT_LOGO = "system.project.logo";
    public static final String CONF_LAST_USED_CAMERA = "system.camera.lastused";
    public static final String CONF_OEHMKE_EXPORT_EDITOR = "oehmke.export.editor";
    public static final String CONF_OEHMKE_EXPORT_FILENAME = "oehmke.export.filename";
    public static final String CONF_OEHMKE_EXPORT_FOLDER = "oehmke.export.folder";
    public static final String CONF_OEHMKE_EXPORT_NR = "oehmke.export.nr";
    public static final String CONF_OEHMKE_EXPORT_OUTPUT = "oehmke.export.output";
    public static final String CONF_OEHMKE_EXPORT_TEMPLATE = "oehmke.export.template";
    public static final String CONF_CUSTOM_WRW_SOAP_ENDPOINT = "custom.wrw.soap.endpoint";
    public static final String CONF_CUSTOM_WRW_SOAP_OTFUSER = "custom.wrw.soap.otfuser";
    public static final String CONF_CUSTOM_WRW_SOAP_PARTNERID = "custom.wrw.soap.partnerid";
    public static final String CONF_CUSTOM_WRW_SOAP_OBJECTTYPE = "custom.wrw.soap.objecttype";
    public static final String CONF_CUSTOM_WRW_SOAP_PONUMBER = "custom.wrw.soap.ponumber";
    public static final String CONF_CERT_KEYSTORE = "cert.keystore";
    public static final String CONF_CERT_KEYSTORE_TYPE = "cert.keystore.type";
    public static final String CONF_CERT_KEYSTORE_PASSWORD = "cert.keystore.password";
    ThemisProject project;
    ThemisFilter filter;
    ArrayList<File> recentProjects = new ArrayList();
    final int maxCountRecentProjects = 5;
    List<ThemisFolder> selectedProjects = null;
    ThemisLicense license;
    File currentFolder;
    private Properties conf = new Properties();
    private boolean adminMode = false;
    private boolean debugMode = false;
    private boolean locationEdit = false;
    private static ThemisApplication app;
    private ThemisSettings settings;
    private ActionProvider actionProvider = new ActionProvider();
    private boolean performancetest = false;
    public static String emailAuthenticationPassword;
    private boolean updateRunning;
    private OntologyImageHandler imageHandler;
    private ThemisDialog dialog = new ThemisDefaultDialog();
    private ColorManager colorManager = new AwtColorManager();
    private OntologyGUImanager guiManager = new OntologyGUImanager(this);

    public OntologyImageHandler getImageHandler() {
        return this.imageHandler;
    }

    public void setImageHandler(OntologyImageHandler h) {
        this.imageHandler = h;
    }

    public void setColorManager(ColorManager m) {
        this.colorManager = m;
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public void setGUImanager(OntologyGUImanager m) {
        this.guiManager = m;
    }

    public OntologyGUImanager getGUImanager() {
        return this.guiManager;
    }

    private ThemisApplication() {
        System.setProperty("license4j-user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0");
    }

    public static ThemisApplication getInstance() {
        return ThemisApplication.getInstance(null);
    }

    public static ThemisApplication getInstance(OntologyFileAccess fileaccess) {
        if (app == null) {
            app = new ThemisApplication();
            ThemisApplication.app.project = new ThemisProject(app);
            app.getActionProvider().setLogger(ThemisApplication.app.project.getLogger());
            if (fileaccess != null) {
                ThemisApplication.app.project.setFileAccess(fileaccess);
            }
            ThemisApplication.app.filter = new ThemisFilter(app);
            ThemisApplication.app.settings = new ThemisSettings(app, ThemisApplication.app.project);
            ThemisApplication.app.settings.initialiseAttributes(app);
            try {
                ThemisApplication.app.settings.loadFromFile();
            }
            catch (JDOMException ex) {
                Logger.getLogger(ThemisApplication.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ThemisApplication.class.getName()).log(Level.SEVERE, null, ex);
            }
            app.loadConfiguration();
            for (int ii = 0; ii < ThemisApplication.app.maxCountRecentProjects; ++ii) {
                String f = app.getConfiguration("system.lastproject." + ii);
                if (f == null) continue;
                File file = new File(f);
                if (file.exists()) {
                    if (ThemisApplication.app.recentProjects.contains(file)) continue;
                    ThemisApplication.app.recentProjects.add(file);
                    continue;
                }
                app.updateRecentProjectList(file, true);
            }
            app.setSysemLanguage();
            try {
                File propertiesFile = new File(app.getApplicationDataConfigFolder(), "cert.properties");
                if (!propertiesFile.isFile()) {
                    propertiesFile = new File(app.getApplicationDataConfigFolder(), "hab.properties");
                }
                if (propertiesFile.isFile()) {
                    Properties props = new Properties();
                    props.load(new FileReader(propertiesFile));
                    String keystoreFileName = props.getProperty(CONF_CERT_KEYSTORE, "");
                    String keystorePassword = props.getProperty(CONF_CERT_KEYSTORE_PASSWORD, "");
                    String keystoreType = props.getProperty(CONF_CERT_KEYSTORE_TYPE, "");
                    if (!"".equals(keystoreFileName) && new File(keystoreFileName).isFile()) {
                        System.setProperty("javax.net.ssl.keyStore", keystoreFileName);
                        System.setProperty("javax.net.ssl.keyStorePassword", keystorePassword);
                        System.setProperty("javax.net.ssl.keyStoreType", keystoreType);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ThemisApplication.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ThemisApplication.class.getName()).log(Level.SEVERE, null, ex);
            }
            app.getActionProvider().invokeAction(ThemisAction.THEMIS_INITIALISATION_DONE);
        }
        return app;
    }

    public void setThemisLicense(ThemisLicense l) {
        this.license = l;
    }

    public void setThemisDialog(ThemisDialog dlg) {
        this.dialog = dlg;
    }

    public ThemisDialog getDialog() {
        return this.dialog;
    }

    public ThemisSettings getSettings() {
        return this.settings;
    }

    public void setActionProvider(ActionProvider ap) {
        if (this.actionProvider != null) {
            ArrayList<ThemisActionListener> listeners = this.actionProvider.getListeners();
            for (ThemisActionListener l : listeners) {
                ap.register(l);
            }
        }
        this.actionProvider = ap;
    }

    public ActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public ThemisFilter getFilter() {
        return this.filter;
    }

    public ThemisLicense getLicense() {
        if (this.license == null) {
            this.license = new ThemisLicense(this);
        }
        return this.license;
    }

    public void updateRecentProjectList(File fOld, File fNew) {
        int idx = this.recentProjects.indexOf(fOld);
        if (idx >= 0) {
            this.recentProjects.add(idx, fNew);
            this.recentProjects.remove(fOld);
        }
    }

    public void updateRecentProjectList() {
        if (this.getProject().isOpen() && !this.getProject().isThemisFileDirectAccess()) {
            this.updateRecentProjectList(this.getProject().getProjectFolder(), false);
        }
    }

    public void updateRecentProjectList(File f, boolean remove) {
        this.recentProjects.remove(f);
        if (!remove) {
            this.recentProjects.add(0, f);
        }
        if (this.recentProjects.size() > this.maxCountRecentProjects) {
            this.recentProjects.remove(this.recentProjects.size() - 1);
        }
        for (int ii = 0; ii < this.recentProjects.size(); ++ii) {
            this.setConfiguration("system.lastproject." + ii, this.recentProjects.get(ii).getAbsolutePath(), false);
        }
        this.saveConfiguration();
    }

    public synchronized ArrayList<File> getRecentProjectList() {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(this.recentProjects);
        return result;
    }

    public ThemisProject createProject(File folder, Properties props, boolean trigger) {
        return this.createProject(folder, props, trigger, false);
    }

    public ThemisProject createProject(File folder, Properties props, boolean trigger, boolean netorkDrive) {
        return this.createProject(folder, props, trigger, netorkDrive, null);
    }

    public ThemisProject createProject(File folder, Properties props, boolean trigger, boolean netorkDrive, ProgressHandler ph) {
        if (this.project.isOpen()) {
            this.getProject().close(new Closing().withoutWaiting(), ph);
        }
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.NONE)) {
            return this.project;
        }
        this.project.open(folder, null, props, trigger, netorkDrive, true, null);
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.APP)) {
            String productEdition = this.license.getProductEdition();
            URL url = null;
            switch (productEdition) {
                case "Brandschutzbuch": {
                    url = this.getClass().getResource("/at/grid/themis/ontology/media/vorlagen/projektvorlage_brandschutzbuch.themis");
                    break;
                }
                case "VdS-Arbeitssicherheit": {
                    url = this.getClass().getResource("/at/grid/themis/ontology/media/vorlagen/projektvorlage_vds_arbeitssicherheit.xlsx");
                    break;
                }
                case "ZIP-TEST": {
                    this.project.getTemplateManger().loadTemplatesFromZIP("/at/grid/themis/ontology/media/vorlagen/test_vorlage.zip");
                }
            }
            if (url != null) {
                try {
                    File f = new File(app.getApplicationDataTempFolder(), "projektvorlage_brandschutzbuch.themis");
                    Util.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(f));
                    try {
                        ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.TEMPLATE);
                        String string = tf.loadFromFile(f, true).getError();
                    }
                    catch (JDOMException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    f.delete();
                }
                catch (IOException ex) {
                    Logger.getLogger(ThemisApplication.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        ThemisLogger.logger.info("Project created at " + folder.getAbsolutePath());
        return this.project;
    }

    public ThemisProject loadProject(File folder, boolean lastOpened, boolean trigger, boolean networkDrive, ProgressHandler ph, File themisZipFile) {
        return this.loadProject(new ThemisFolder(folder), lastOpened, trigger, networkDrive, ph, themisZipFile);
    }

    public ThemisProject loadProject(ThemisFolder themisFile, boolean lastOpened, boolean trigger, boolean networkDrive, ProgressHandler ph, File themisZipFile) {
        File folder = themisFile.getProjectFolder();
        if (ph == null) {
            ph = new LoggerProgressHandler(this.project.getLogger(), MessageFormat.format(this.project.getResourceText("ThemisApplication.loadProject.text", this.getLocale()), folder.getAbsolutePath()));
        }
        if (!themisFile.isProject()) {
            this.getProject().getLogger().fine("folder '" + folder.getAbsolutePath() + "' is not a project folder");
            if (!lastOpened) {
                this.dialog.showErrorDialog(MessageFormat.format(this.project.getResourceText("ThemisApplication.notAProjectDirectory.text", this.getLocale()), folder.getAbsolutePath()));
                return this.project;
            }
            this.dialog.showErrorDialog(MessageFormat.format(this.project.getResourceText("ThemisApplication.projectDirectory.text", this.getLocale()), folder.getAbsolutePath()));
            return null;
        }
        if (ThemisProject.isProjectFolderAndroidReplacement(folder)) {
            if (this.dialog.showConfirmDialog(this.project.getResourceText("project.project-in-use-android"))) {
                this.project.renameAndroidReplacementFile(folder);
            } else {
                return this.project;
            }
        }
        if (this.project.isOpen()) {
            this.getProject().close(new Closing().withoutExport().withoutWaiting(), ph);
        }
        this.getProject().getLogger().fine("calling the project.open() method");
        boolean hasLocalCopy = themisFile.isLocal();
        if (!networkDrive) {
            hasLocalCopy = false;
        }
        this.project.open(themisFile, null, null, trigger, networkDrive, false, hasLocalCopy, false, ph);
        if (!this.project.isOpen()) {
            return this.project;
        }
        if (!ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.APP) && themisZipFile != null && themisZipFile.getName().endsWith(".themis")) {
            try {
                ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.TEMPLATE);
                String string = tf.loadFromFile(themisZipFile, true).getError();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ThemisLogger.logger.info("Project opened from " + folder.getAbsolutePath());
        if (!this.project.isThemisFileDirectAccess()) {
            this.updateRecentProjectList(folder, false);
        }
        this.project.loadRecentLocTemplates();
        ph.progressDone();
        return this.project;
    }

    public boolean isProjectOpen() {
        return this.project != null && this.project.isOpen();
    }

    public ThemisProject getProject() {
        return this.project;
    }

    public TimeZone getTimeZone() {
        if (this.project.isOpen()) {
            return this.project.getTimeZone();
        }
        return TimeZone.getTimeZone(this.getConfiguration(CONF_TIME_ZONE, "CET"));
    }

    public void setTimeZone(String tz) {
        this.setConfiguration(CONF_TIME_ZONE, tz, true);
    }

    public void setAppointmentInfo(String count, String repeat) {
        this.setConfiguration(CONF_SHOW_NOTIFICATION_APPOINTMENT_COUNT, count, true);
        this.setConfiguration(CONF_SHOW_NOTIFICATION_APPOINTMENT_REPEAT, repeat, true);
    }

    public String[] getAppointmentInfo() {
        return new String[]{this.getConfiguration(CONF_SHOW_NOTIFICATION_APPOINTMENT_COUNT, "14"), this.getConfiguration(CONF_SHOW_NOTIFICATION_APPOINTMENT_REPEAT, "1")};
    }

    public Date getAppointmentInfoDate() {
        CmsEvent ev = this.project.getCurrentEvent();
        Date refdate = ev == null ? new Date() : ev.getDateAttribute("date").getDate();
        String[] appointment = this.getAppointmentInfo();
        int count = Integer.parseInt(appointment[0]);
        int unit = Integer.parseInt(appointment[1]);
        return ThemisApplication.applyPeriodToDate(refdate, unit, count);
    }

    private File getAndCreateFolder(File f) {
        f.mkdirs();
        return f;
    }

    public File getApplicationDataFolder() {
        return this.getProject().getFileAccess().getApplicationDataFolder();
    }

    public File getApplicationDataConfigFolder() {
        return this.getAndCreateFolder(new File(this.getApplicationDataFolder(), "conf"));
    }

    public File getApplicationDataUpdateFolder() {
        return this.getAndCreateFolder(new File(this.getApplicationDataFolder(), "update"));
    }

    public File getApplicationDataDocumentsFolder() {
        return this.getAndCreateFolder(new File(this.getApplicationDataFolder(), "docs"));
    }

    public File getApplicationDataTemplatesFolder() {
        return this.getAndCreateFolder(new File(this.getApplicationDataFolder(), "templates61"));
    }

    public File getApplicationDataTempFolder() {
        return this.getAndCreateFolder(new File(this.getApplicationDataFolder(), "temp"));
    }

    public File getApplicationDataLicenseFolder() {
        return this.getAndCreateFolder(new File(this.getApplicationDataFolder(), "license"));
    }

    public File getApplicationDataLicenseKeyFile() {
        return new File(this.getApplicationDataLicenseFolder(), "themis.key");
    }

    public File getApplicationDataLicenseTextFile() {
        return new File(this.getApplicationDataLicenseFolder(), "themis.lic");
    }

    public File getApplicationDataLicenseFile() {
        return new File(this.getApplicationDataLicenseFolder(), "themislicense.lic");
    }

    public File getApplicationDataLocalProjectsFolder() {
        return this.getAndCreateFolder(new File(this.getApplicationDataFolder(), "projects"));
    }

    protected File getPropertiesFile() {
        return new File(this.getApplicationDataConfigFolder(), "themis.properties");
    }

    public static File getThemisProgramFolder() {
        return new File(".").getAbsoluteFile();
    }

    private void loadConfiguration() {
        File propfile = this.getPropertiesFile();
        try {
            if (propfile.isFile()) {
                this.conf.load(new FileReader(propfile));
            }
        }
        catch (IOException ex) {
            ThemisLogger.logger.warning("Error while loading application configuration properties from " + propfile.getAbsolutePath());
        }
    }

    public void setConfiguration(String key, String value, boolean save) {
        if (value == null) {
            this.conf.remove(key);
        } else {
            this.conf.setProperty(key, value);
        }
        if (save) {
            this.saveConfiguration();
        }
    }

    public void setConfiguration(Properties props) {
        for (String key : props.stringPropertyNames()) {
            this.conf.setProperty(key, props.getProperty(key));
        }
        this.saveConfiguration();
    }

    public void saveConfiguration() {
        File propfile = this.getPropertiesFile();
        propfile.getParentFile().mkdirs();
        try {
            this.conf.store(new FileWriter(propfile), null);
        }
        catch (IOException ex) {
            ThemisLogger.logger.warning("Error while saving application configuration properties to " + propfile.getAbsolutePath());
        }
        for (String p : this.conf.stringPropertyNames()) {
            this.getSettings().setProperty(p, this.conf.getProperty(p));
        }
    }

    public String getConfiguration(String key) {
        return this.getConfiguration(key, null);
    }

    public String getConfiguration(String key, String defaultValue) {
        String result = null;
        if (this.project != null && this.project.isOpen()) {
            result = this.project.getProjectProperty(key, null);
        }
        if (result != null) {
            return result;
        }
        return this.getSettings().getProperty(key, defaultValue);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Deprecated
    public boolean showAttribute(String col) {
        String[] defaultFalse;
        for (String c : defaultFalse = new String[]{"title", " control", SHOW_OBS_MEASURE, SHOW_OBS_QUANTITY, SHOW_LOC_DIMENSION, SHOW_OBS_FREETEXT1, SHOW_OBS_FREETEXT2, SHOW_OBS_FREETEXT3, SHOW_OBS_LANGTEXT1, SHOW_OBS_LANGTEXT2, SHOW_OBS_RISK, SHOW_OBS_TOPIC}) {
            if (!c.equals(col)) continue;
            return "show".equals(this.getConfiguration("observationtable.column." + col, "hide"));
        }
        return "show".equals(this.getConfiguration("observationtable.column." + col, "show"));
    }

    public void setLoadTemplateFile(boolean v) {
        this.setConfiguration(CONF_TEMPLATE_CHK_BOX, v ? "show" : "hide", true);
    }

    public boolean getLoadTemplateFile() {
        return "show".equals(this.getConfiguration(CONF_TEMPLATE_CHK_BOX, "null"));
    }

    public File getCurrentFolder() {
        if (this.currentFolder == null) {
            this.currentFolder = this.getSettings().getFolderProjectRoot().getValue(true);
        }
        return this.currentFolder;
    }

    public void setCurrentFolder(File currentFolder) {
        this.currentFolder = currentFolder;
    }

    public File getPathExportFolder() {
        return new File(this.getConfiguration(CONF_EXPORT_FOLDER, ""));
    }

    public void setPathExportFolder(File pathExportFolder) {
        this.setConfiguration(CONF_EXPORT_FOLDER, pathExportFolder.getAbsolutePath(), true);
    }

    public File getPathUnpackFolder() {
        return new File(this.getConfiguration(CONF_UNPACK_FOLDER, ""));
    }

    public void setPathUnpackFolder(File pathExportFolder) {
        this.setConfiguration(CONF_UNPACK_FOLDER, pathExportFolder.getAbsolutePath(), true);
    }

    public File getPathUpdateFolder() {
        return new File(this.getConfiguration(CONF_UPDATE_SOURCE, ""));
    }

    public void setPathUpdateFolder(File pathExportFolder) {
        this.setConfiguration(CONF_UPDATE_SOURCE, pathExportFolder.getAbsolutePath(), true);
    }

    public File getPathExportKubus360() {
        return new File(this.getConfiguration(CONF_EXPORT_FOLDER_KUBUS360, ""));
    }

    public void setPathExportKubus360(File pathExportFolder) {
        this.setConfiguration(CONF_EXPORT_FOLDER_KUBUS360, pathExportFolder.getAbsolutePath(), true);
    }

    public File getPathTemplateLocationObservation() {
        return new File(this.getConfiguration(CONF_TEMPLATE_LOCATION_OBSERVATION, ""));
    }

    public void setPathTemplateLocationObservation(File pathTemplateLocationObservation) {
        this.setConfiguration(CONF_TEMPLATE_LOCATION_OBSERVATION, pathTemplateLocationObservation.getAbsolutePath(), true);
    }

    public void setPlanLongside(String longside) {
        if (this.project.isOpen()) {
            this.project.setProjectProperty(CONF_PLAN_LONGSIDE, longside);
        }
        this.setConfiguration(CONF_PLAN_LONGSIDE, longside, this.adminMode);
    }

    public String getPlanLongside() {
        if (this.project.isOpen()) {
            return this.project.getProjectProperty(CONF_PLAN_LONGSIDE, "5000");
        }
        return this.getConfiguration(CONF_PLAN_LONGSIDE, "5000");
    }

    public void setPictureImportFolder(File pathPictureImportFolder) {
        this.setConfiguration("file.pictureimportfolder", pathPictureImportFolder.getAbsolutePath(), true);
    }

    public File getPictureImportFolder() {
        return new File(this.getConfiguration("file.pictureimportfolder", ""));
    }

    public void setIconImportFolder(File pathIconImportFolder) {
        this.setConfiguration("file.pictureimportfolder", pathIconImportFolder.getAbsolutePath(), true);
    }

    public File getIconImportFolder() {
        return new File(this.getConfiguration("file.pictureimportfolder", ""));
    }

    public void setDocumentImportFolder(File pathDocumentImportFolder) {
        this.setConfiguration(CONF_DOCUMENT_IMPORT_FOLDER, pathDocumentImportFolder.getAbsolutePath(), true);
    }

    public File getDocumentImportFolder() {
        return new File(this.getConfiguration(CONF_DOCUMENT_IMPORT_FOLDER, ""));
    }

    public File getFileFolder() {
        return new File(this.getConfiguration(CONF_FILEFOLDER, ""));
    }

    public void setFileFolder(File fileFolder) {
        this.setConfiguration(CONF_FILEFOLDER, fileFolder.getAbsolutePath(), true);
    }

    public void setSysemLanguage() {
        String lang = this.getConfiguration(CONF_LANGUAGE, "Deutsch");
        if ("Deutsch".equals(lang)) {
            Locale.setDefault(new Locale("de", "DE"));
        } else if ("English".equals(lang)) {
            Locale.setDefault(new Locale("en", "UK"));
        }
    }

    public String getSystemLanguage() {
        return "de";
    }

    public void setLastSystemStart() {
        this.setConfiguration(CONF_LAST_SYSTEM_START, System.currentTimeMillis() + "", true);
    }

    public BigInteger getLastSystemStart() {
        String lastSystemStart = this.getConfiguration(CONF_LAST_SYSTEM_START, "-1");
        try {
            return new BigInteger(lastSystemStart);
        }
        catch (Exception ex) {
            return new BigInteger("-1");
        }
    }

    public boolean checkLastSystemStartTime(BigInteger currentTime) {
        BigInteger lastSystemStart = this.getLastSystemStart();
        if (lastSystemStart.compareTo(new BigInteger("-1")) == 0) {
            this.setLastSystemStart();
            return true;
        }
        if (currentTime.compareTo(lastSystemStart) == -1) {
            return false;
        }
        this.setLastSystemStart();
        return true;
    }

    public File getIconPoint() {
        return new File(this.getConfiguration(CONF_ICON_POINT, ""));
    }

    public void setIconPoint(File icon) {
        this.setConfiguration(CONF_ICON_POINT, icon.getAbsolutePath(), true);
    }

    public File getIconPointSel() {
        return new File(this.getConfiguration(CONF_ICON_POINTSEL, ""));
    }

    public void setIconPointSel(File icon) {
        this.setConfiguration(CONF_ICON_POINTSEL, icon.getAbsolutePath(), true);
    }

    public File getIconPointInactive() {
        return new File(this.getConfiguration(CONF_ICON_POINTINACTIVE, ""));
    }

    public void setIconPointInactive(File icon) {
        this.setConfiguration(CONF_ICON_POINTINACTIVE, icon.getAbsolutePath(), true);
    }

    @Deprecated
    public boolean isAdminMode() {
        return this.adminMode;
    }

    @Deprecated
    public void setAdminMode(boolean mode) {
        this.adminMode = mode;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebug(boolean mode) {
        this.debugMode = mode;
        this.project.getLogger().setLevel(mode ? Level.FINE : Level.INFO);
        for (Handler handler : this.project.getLogger().getHandlers()) {
            handler.setLevel(mode ? Level.FINE : Level.INFO);
        }
        if (this.project.isOpen()) {
            try {
                if (mode) {
                    File traceFile = new File(new File(this.project.getProjectFolder(), "db"), "trace_" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.getTimeZone()) + ".sql");
                    this.getProject().getDatastorage().setTraceFile(traceFile, this.getProject().getFileAccess());
                } else {
                    this.getProject().getDatastorage().closeTraceFile();
                }
            }
            catch (IOException ex) {
                this.getProject().getLogger().severe("Cannot create database trace file");
            }
        }
        this.project.getLogger().info("Debug mode " + (mode ? "" : "de") + "activated");
    }

    public boolean isLocationEdit() {
        return this.locationEdit;
    }

    public void setLocationEdit(boolean locationEdit) {
        this.locationEdit = locationEdit;
    }

    public static Date applyPeriodToDate(Date dt, Integer idUnit, Integer count) {
        int field;
        if (dt == null || idUnit == null || count == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        switch (idUnit) {
            case 1: {
                field = 6;
                break;
            }
            case 2: {
                field = 3;
                break;
            }
            case 3: {
                field = 2;
                break;
            }
            case 4: {
                field = 1;
                break;
            }
            default: {
                field = 6;
            }
        }
        ((Calendar)cal).add(field, count);
        return cal.getTime();
    }

    public static ArrayList<UploadItem> getExportImages(UploadAttribute att) {
        return ThemisApplication.getExportImages(att.getImageUploadItems());
    }

    public static ArrayList<UploadItem> getExportImages(ArrayList<UploadItem> items) {
        ArrayList<UploadItem> imageitems = new ArrayList<UploadItem>();
        for (UploadItem item : items) {
            if (item.getUploadDetail() == 2L) continue;
            imageitems.add(item);
        }
        return imageitems;
    }

    public boolean isPerformancetest() {
        return this.performancetest;
    }

    public void setPerformancetest(boolean performancetest) {
        this.performancetest = performancetest;
    }

    @Deprecated
    public boolean isEditTemplateAllowed() {
        return this.isUserAdministrator();
    }

    public boolean isUserAdministrator() {
        String[] names;
        if (!ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            return false;
        }
        CmsUser u = this.project.getUser();
        if (u == null) {
            return false;
        }
        String username = u.getUsername();
        String usernames = app.getSettings().getPermissionEditTemplates();
        this.getProject().getLogger().info("Checking Admin permission for username '" + username + "', allowed are: " + usernames);
        if (username != null) {
            username = username.trim();
        }
        if ("*".equals(usernames)) {
            return true;
        }
        for (String n : names = usernames.split(",")) {
            if (!n.trim().equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    public void repairDatabase(File projectDir) {
        File dir = new File(projectDir, "db");
        String db = "themis";
        File dbFile = new File(dir, db + ".h2.db");
        File dbFileBackup = new File(projectDir, "repair/" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone()) + "/themis.h2.db");
        boolean success = false;
        String errorMessage = null;
        if (this.getProject().isOpen() && this.getProject().getProjectFolder().equals(projectDir)) {
            this.getProject().close(new Closing().withoutExport().withoutWaiting(), null);
        }
        try {
            dbFileBackup.getParentFile().mkdirs();
            Util.copy((File)dbFile, (File)dbFileBackup);
            Recover r = new Recover();
            RunScript script = new RunScript();
            r.runTool(new String[]{"-dir", dir.getAbsolutePath(), "-db", db});
            if (dbFileBackup.isFile()) {
                dbFile.delete();
                script.runTool(new String[]{"-url", "jdbc:h2:" + dir.getAbsolutePath() + "/themis;MV_STORE=FALSE", "-script", dir.getAbsolutePath() + "/themis.h2.sql", "-checkResults"});
                File sqlFile = new File(dir, "themis.h2.sql");
                sqlFile.renameTo(new File(dbFileBackup.getParentFile(), "themis.h2.sql"));
                success = true;
                app.getDialog().showInfoDialog("Datenbank repariert");
            }
        }
        catch (IOException ex) {
            errorMessage = ex.getMessage();
        }
        catch (SQLException ex) {
            errorMessage = ex.getMessage();
        }
        catch (Exception ex) {
            errorMessage = ex.getMessage();
        }
        if (!success) {
            if (dbFile.isFile()) {
                dbFile.renameTo(new File(dir, "themis_fail.h2.db"));
            }
            dbFileBackup.renameTo(new File(dir, "themis.h2.db"));
            app.getDialog().showErrorDialog("Fehler beim Reparieren: " + errorMessage + "<br>Die alte Datenbank-Version wird wiederhergestellt");
        }
    }

    public void setUpdateRunning(boolean b) {
        this.updateRunning = b;
        this.getProject().getLogger().info("Update process set to '" + (b ? "TRUE" : "FALSE") + "'");
    }

    public boolean isUpdateRunning() {
        return this.updateRunning;
    }

    public static Logger getLogger() {
        ThemisProject p = ThemisApplication.getInstance().getProject();
        return p == null ? Logger.getAnonymousLogger() : p.getLogger();
    }

    static {
        emailAuthenticationPassword = "";
    }
}

